/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.editors.parts.diagram.actions;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.editparts.LayerManager;
import org.eclipse.gef.ui.actions.PrintAction;
import org.eclipse.stardust.model.xpdl.carnot.DiagramType;
import org.eclipse.stardust.model.xpdl.carnot.INodeSymbol;
import org.eclipse.stardust.modeling.core.editors.WorkflowModelEditor;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.actions.DiagramPrintGraphicalViewerOperation;
import org.eclipse.swt.printing.PrintDialog;
import org.eclipse.swt.printing.Printer;
import org.eclipse.swt.printing.PrinterData;
import org.eclipse.ui.IWorkbenchPart;

public class DiagramPrintAction
extends PrintAction {
    public DiagramPrintAction(IWorkbenchPart part) {
        super(part);
    }

    public void run() {
        GraphicalViewer viewer = (GraphicalViewer)this.getWorkbenchPart().getAdapter(GraphicalViewer.class);
        LayerManager lm = (LayerManager)viewer.getEditPartRegistry().get(LayerManager.ID);
        IFigure f = lm.getLayer((Object)"Printable Layers");
        Rectangle oldBounds = f.getBounds();
        Rectangle printingBounds = this.getPrintingBounds(((WorkflowModelEditor)this.getWorkbenchPart()).getActiveDiagram());
        PrintDialog dialog = new PrintDialog(viewer.getControl().getShell(), 0);
        PrinterData data = dialog.open();
        if (data != null) {
            DiagramPrintGraphicalViewerOperation op = new DiagramPrintGraphicalViewerOperation(new Printer(data), viewer, printingBounds);
            op.run(this.getWorkbenchPart().getTitle());
        }
        f.setBounds(oldBounds);
    }

    private Rectangle getPrintingBounds(DiagramType activeDiagram) {
        long x = -1L;
        long y = -1L;
        long width = -1L;
        long height = -1L;
        FeatureMap.ValueListIterator iter = activeDiagram.getNodes().valueListIterator();
        while (iter.hasNext()) {
            INodeSymbol symbol = (INodeSymbol)iter.next();
            if (x == -1L || symbol.getXPos() < x) {
                x = symbol.getXPos();
            }
            if (y == -1L || symbol.getYPos() < y) {
                y = symbol.getYPos();
            }
            if (width == -1L || (long)symbol.getWidth() + symbol.getXPos() > width) {
                width = (long)symbol.getWidth() + symbol.getXPos();
            }
            if (height != -1L && (long)symbol.getHeight() + symbol.getYPos() <= height) continue;
            height = (long)symbol.getHeight() + symbol.getYPos();
        }
        return new Rectangle(new Point((double)(x -= 20L), (double)(y -= 20L)), new Dimension(new Long(width += 20L).intValue(), new Long(height += 20L).intValue()));
    }
}

