/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.editors.parts.diagram.actions;

import java.io.File;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.ui.actions.SelectionAction;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.stardust.common.Pair;
import org.eclipse.stardust.common.StringUtils;
import org.eclipse.stardust.model.xpdl.carnot.DiagramType;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.model.xpdl.carnot.ProcessDefinitionType;
import org.eclipse.stardust.model.xpdl.carnot.ProcessSymbolType;
import org.eclipse.stardust.modeling.core.Diagram_Messages;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.DiagramRootEditPart;
import org.eclipse.stardust.modeling.core.export.DiagramExporter;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPart;

public class ExportDiagramAction
extends SelectionAction {
    private Set<DiagramType> diagrams;
    private File fileNameProposal;
    private String selectedDirectoryName;

    public ExportDiagramAction(IWorkbenchPart part) {
        super(part);
        this.setId("org.eclipse.stardust.modeling.core.export.diagram");
    }

    public void run() {
        String format = null;
        int size = this.diagrams.size();
        if (1 == size) {
            if (this.fileNameProposal == null) {
                this.fileNameProposal = this.createFileName((DiagramType)this.diagrams.toArray()[0], null);
                Pair fileAndFormat = this.browseForFileAndFormat(this.fileNameProposal.getAbsolutePath());
                String selectedFileName = (String)fileAndFormat.getFirst();
                format = (String)fileAndFormat.getSecond();
                if (selectedFileName == null) {
                    return;
                }
                this.fileNameProposal = new File(selectedFileName);
            }
        } else if (1 < size && this.selectedDirectoryName == null) {
            Pair directoryAndFormat = this.browseForDirectoryAndFormat(null);
            this.selectedDirectoryName = (String)directoryAndFormat.getFirst();
            format = (String)directoryAndFormat.getSecond();
            if (this.selectedDirectoryName == null) {
                return;
            }
        }
        for (DiagramType diagram : this.diagrams) {
            File file;
            DiagramExporter exporter = new DiagramExporter(diagram, this.getWorkbenchPart());
            File file2 = file = this.fileNameProposal == null ? this.createFileName(diagram, this.selectedDirectoryName) : this.fileNameProposal;
            if (file == null) continue;
            format = StringUtils.isEmpty((String)format) ? "png" : format;
            String fileName = file.getName();
            int pointIdx = fileName.lastIndexOf(".");
            if (-1 == pointIdx) {
                file = new File(String.valueOf(file.getAbsolutePath()) + "." + format);
            }
            if ("png".equals(format)) {
                exporter.dumpDiagramToPNGFile(file);
                continue;
            }
            if ("jpeg".equals(format)) {
                exporter.dumpDiagramToJPEGFile(file);
                continue;
            }
            if (!"gif".equals(format)) continue;
            exporter.dumpDiagramToGIFFile(file);
        }
    }

    protected boolean calculateEnabled() {
        boolean result = false;
        this.diagrams = new HashSet<DiagramType>();
        this.fileNameProposal = null;
        this.selectedDirectoryName = null;
        for (Object selection : this.getSelectedObjects()) {
            if (!(selection instanceof EditPart)) continue;
            Object rawElement = ((EditPart)selection).getModel();
            Object object = rawElement = selection instanceof DiagramRootEditPart ? ((DiagramRootEditPart)((Object)selection)).getContents().getModel() : rawElement;
            if (rawElement instanceof DiagramType) {
                result = true;
                DiagramType diagram = (DiagramType)rawElement;
                this.diagrams.add(diagram);
                continue;
            }
            if (rawElement instanceof ProcessSymbolType) {
                result = true;
                ProcessSymbolType symbol = (ProcessSymbolType)rawElement;
                ProcessDefinitionType processDefinition = (ProcessDefinitionType)symbol.getModelElement();
                this.diagrams.addAll((Collection<DiagramType>)processDefinition.getDiagram());
                continue;
            }
            if (rawElement instanceof ProcessDefinitionType) {
                result = true;
                ProcessDefinitionType processDefinition = (ProcessDefinitionType)rawElement;
                this.diagrams.addAll((Collection<DiagramType>)processDefinition.getDiagram());
                continue;
            }
            if (!(rawElement instanceof ModelType)) continue;
            result = true;
            ModelType model = (ModelType)rawElement;
            this.diagrams.addAll((Collection<DiagramType>)model.getDiagram());
            for (ProcessDefinitionType processDefinition : model.getProcessDefinition()) {
                this.diagrams.addAll((Collection<DiagramType>)processDefinition.getDiagram());
            }
        }
        int size = this.diagrams.size();
        if (size == 0) {
            result = false;
        } else if (1 == size) {
            this.setText(Diagram_Messages.DESC_ExportDiagram);
        } else {
            this.setText(Diagram_Messages.MENU_ExportAllDiagrams);
        }
        return result;
    }

    public File getFileNameProposal() {
        return this.fileNameProposal;
    }

    public void setFileNameProposal(File fileNameProposal) {
        this.fileNameProposal = fileNameProposal;
    }

    public String getSelectedDirectoryName() {
        return this.selectedDirectoryName;
    }

    public void setSelectedDirectoryName(String selectedDirectoryName) {
        this.selectedDirectoryName = selectedDirectoryName;
    }

    private Pair browseForDirectoryAndFormat(String proposal) {
        DirectorySelectionDialog dialog = new DirectorySelectionDialog(Display.getCurrent().getActiveShell());
        dialog.setFilterPath(proposal);
        dialog.setBlockOnOpen(true);
        int result = dialog.open();
        if (result == 0) {
            Pair directoryAndFormat = new Pair((Object)dialog.getFileName(), (Object)dialog.getImageFormat());
            return directoryAndFormat;
        }
        return new Pair(null, null);
    }

    private Pair browseForFileAndFormat(String proposal) {
        FileSelectionDialog dialog = new FileSelectionDialog(Display.getCurrent().getActiveShell());
        File proposedFile = new File(proposal);
        dialog.setFileName(proposedFile.getName());
        dialog.setFilterExtensions(new String[]{"*.png", "*.jpg", "*.*"});
        dialog.setBlockOnOpen(true);
        int result = dialog.open();
        if (result == 0) {
            Pair fileAndFormat = new Pair((Object)dialog.getFileName(), (Object)dialog.getImageFormat());
            return fileAndFormat;
        }
        return new Pair(null, null);
    }

    private File createFileName(DiagramType diagram, String baseDir) {
        EObject rawContainer;
        StringBuffer buffer = new StringBuffer();
        if (baseDir != null) {
            buffer.append(baseDir).append(File.separatorChar);
        }
        if ((rawContainer = diagram.eContainer()) instanceof ModelType) {
            ModelType model = (ModelType)rawContainer;
            buffer.append(model.getId()).append("_");
        } else if (rawContainer instanceof ProcessDefinitionType) {
            ProcessDefinitionType processDefinition = (ProcessDefinitionType)rawContainer;
            ModelType model = (ModelType)processDefinition.eContainer();
            buffer.append(model.getId()).append("_");
            buffer.append(processDefinition.getId()).append("_");
        } else {
            return null;
        }
        buffer.append(diagram.getName());
        return new File(buffer.toString());
    }

    private class DirectorySelectionDialog
    extends Dialog {
        private String fileName;
        private String filterPath;
        private Button pngRadioButton;
        private Button jpgRadioButton;
        private Button gifRadioButton;
        private String imageFormat;
        private Text fileNameField;

        public DirectorySelectionDialog(Shell shell) {
            super(shell);
            this.imageFormat = "png";
        }

        protected void configureShell(Shell shell) {
            super.configureShell(shell);
            shell.setText(Diagram_Messages.MENU_SelectDirectoryAndImageFormat);
        }

        protected void cancelPressed() {
            super.cancelPressed();
        }

        protected Control createDialogArea(Composite parent) {
            Composite containerGroup = new Composite(parent, 0);
            GridLayout layout = new GridLayout();
            layout.numColumns = 3;
            containerGroup.setLayout((Layout)layout);
            containerGroup.setLayoutData((Object)new GridData(768));
            containerGroup.setFont(parent.getFont());
            Label label = new Label(containerGroup, 0);
            label.setText(Diagram_Messages.LABEL_SelectDirectory);
            label.setFont(parent.getFont());
            this.fileNameField = new Text(containerGroup, 2052);
            GridData data = new GridData(768);
            data.widthHint = 250;
            this.fileNameField.setLayoutData((Object)data);
            this.fileNameField.setFont(parent.getFont());
            this.fileNameField.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent event) {
                }
            });
            Button containerBrowseButton = new Button(containerGroup, 8);
            containerBrowseButton.setText(Diagram_Messages.BUTTON_Browse);
            containerBrowseButton.setFont(parent.getFont());
            containerBrowseButton.setLayoutData((Object)new GridData(256));
            final DirectoryDialog dialog = new DirectoryDialog(parent.getShell(), 8192);
            containerBrowseButton.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent event) {
                    DirectorySelectionDialog.this.fileName = dialog.open();
                    DirectorySelectionDialog.this.fileNameField.setText(DirectorySelectionDialog.this.fileName);
                }

                public void widgetDefaultSelected(SelectionEvent event) {
                    DirectorySelectionDialog.this.fileName = dialog.open();
                    DirectorySelectionDialog.this.fileNameField.setText(DirectorySelectionDialog.this.fileName);
                }
            });
            Group optionsGroup = new Group(containerGroup, 0);
            layout = new GridLayout();
            optionsGroup.setLayout((Layout)layout);
            optionsGroup.setLayoutData((Object)new GridData(768));
            optionsGroup.setFont(parent.getFont());
            optionsGroup.setText(Diagram_Messages.GROUP_ImageFormat);
            this.pngRadioButton = new Button((Composite)optionsGroup, 16);
            this.pngRadioButton.setText("PNG");
            this.pngRadioButton.setSelection(true);
            this.pngRadioButton.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                }

                public void widgetSelected(SelectionEvent e) {
                    DirectorySelectionDialog.this.imageFormat = "png";
                }
            });
            this.jpgRadioButton = new Button((Composite)optionsGroup, 16);
            this.jpgRadioButton.setText("JPEG");
            this.jpgRadioButton.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                }

                public void widgetSelected(SelectionEvent e) {
                    DirectorySelectionDialog.this.imageFormat = "jpeg";
                }
            });
            this.gifRadioButton = new Button((Composite)optionsGroup, 16);
            this.gifRadioButton.setText("GIF");
            this.gifRadioButton.setEnabled(false);
            this.gifRadioButton.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                }

                public void widgetSelected(SelectionEvent e) {
                    DirectorySelectionDialog.this.imageFormat = "gif";
                }
            });
            return super.createDialogArea(parent);
        }

        protected void okPressed() {
            this.fileName = this.fileNameField.getText();
            super.okPressed();
        }

        public String getFileName() {
            return this.fileName;
        }

        public void setFileName(String fileName) {
            this.fileName = fileName;
        }

        public String getImageFormat() {
            return this.imageFormat;
        }

        public String getFilterPath() {
            return this.filterPath;
        }

        public void setFilterPath(String filterPath) {
            this.filterPath = filterPath;
        }
    }

    private class FileSelectionDialog
    extends Dialog {
        private String fileName;
        private String[] filterExtensions;
        private Button pngRadioButton;
        private Button jpgRadioButton;
        private Button gifRadioButton;
        private String imageFormat;
        private Text fileNameField;

        public String[] getFilterExtensions() {
            return this.filterExtensions;
        }

        public void setFilterExtensions(String[] filterExtensions) {
            this.filterExtensions = filterExtensions;
        }

        public FileSelectionDialog(Shell shell) {
            super(shell);
            this.imageFormat = "png";
        }

        protected void configureShell(Shell shell) {
            super.configureShell(shell);
            shell.setText(Diagram_Messages.TITLE_SelectFileAndImageFormat);
        }

        protected Control createDialogArea(Composite parent) {
            Composite containerGroup = new Composite(parent, 0);
            GridLayout layout = new GridLayout();
            layout.numColumns = 3;
            containerGroup.setLayout((Layout)layout);
            containerGroup.setLayoutData((Object)new GridData(768));
            containerGroup.setFont(parent.getFont());
            Label label = new Label(containerGroup, 0);
            label.setText(Diagram_Messages.LABEL_SelectFile);
            label.setFont(parent.getFont());
            this.fileNameField = new Text(containerGroup, 2052);
            GridData data = new GridData(768);
            data.widthHint = 250;
            this.fileNameField.setLayoutData((Object)data);
            this.fileNameField.setFont(parent.getFont());
            this.fileNameField.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent event) {
                }
            });
            Button containerBrowseButton = new Button(containerGroup, 8);
            containerBrowseButton.setText(Diagram_Messages.BUTTON_Browse);
            containerBrowseButton.setFont(parent.getFont());
            containerBrowseButton.setLayoutData((Object)new GridData(256));
            final FileDialog dialog = new FileDialog(parent.getShell(), 8192);
            dialog.setFileName(this.fileName);
            dialog.setFilterExtensions(this.filterExtensions);
            containerBrowseButton.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent event) {
                    dialog.setFilterExtensions(FileSelectionDialog.this.filterExtensions);
                    FileSelectionDialog.this.fileName = dialog.open();
                    if (FileSelectionDialog.this.fileName != null && new File(FileSelectionDialog.this.fileName).exists() && !MessageDialog.openQuestion((Shell)Display.getCurrent().getActiveShell(), (String)Diagram_Messages.Title_FileExists, (String)Diagram_Messages.MSG_FileExists)) {
                        FileSelectionDialog.this.fileName = null;
                    }
                    FileSelectionDialog.this.fileNameField.setText(FileSelectionDialog.this.fileName != null ? FileSelectionDialog.this.fileName : "");
                }

                public void widgetDefaultSelected(SelectionEvent event) {
                    FileSelectionDialog.this.fileName = dialog.open();
                    FileSelectionDialog.this.fileNameField.setText(FileSelectionDialog.this.fileName != null ? FileSelectionDialog.this.fileName : "");
                }
            });
            Group optionsGroup = new Group(containerGroup, 0);
            layout = new GridLayout();
            optionsGroup.setLayout((Layout)layout);
            optionsGroup.setLayoutData((Object)new GridData(768));
            optionsGroup.setFont(parent.getFont());
            optionsGroup.setText(Diagram_Messages.GROUP_ImageFormat);
            this.pngRadioButton = new Button((Composite)optionsGroup, 16);
            this.pngRadioButton.setText("PNG");
            this.pngRadioButton.setSelection(true);
            this.pngRadioButton.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                }

                public void widgetSelected(SelectionEvent e) {
                    FileSelectionDialog.this.imageFormat = "png";
                    FileSelectionDialog.this.filterExtensions = new String[]{"*.png", "*.jpg", "*.gif", "*.*"};
                    FileSelectionDialog.this.updateFileExtension();
                }
            });
            this.jpgRadioButton = new Button((Composite)optionsGroup, 16);
            this.jpgRadioButton.setText("JPEG");
            this.jpgRadioButton.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                }

                public void widgetSelected(SelectionEvent e) {
                    FileSelectionDialog.this.imageFormat = "jpeg";
                    FileSelectionDialog.this.filterExtensions = new String[]{"*.jpg", "*.png", "*.gif", "*.*"};
                    FileSelectionDialog.this.updateFileExtension();
                }
            });
            this.gifRadioButton = new Button((Composite)optionsGroup, 16);
            this.gifRadioButton.setText("GIF");
            this.gifRadioButton.setEnabled(false);
            this.gifRadioButton.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                }

                public void widgetSelected(SelectionEvent e) {
                    FileSelectionDialog.this.imageFormat = "gif";
                    FileSelectionDialog.this.filterExtensions = new String[]{"*.gif", "*.jpg", "*.png", "*.*"};
                    FileSelectionDialog.this.updateFileExtension();
                }
            });
            return super.createDialogArea(parent);
        }

        public String getFileName() {
            return this.fileName;
        }

        public void setFileName(String fileName) {
            this.fileName = fileName;
        }

        public String getImageFormat() {
            return this.imageFormat;
        }

        protected void okPressed() {
            this.fileName = this.fileNameField.getText();
            if (new File(this.fileName).isAbsolute()) {
                super.okPressed();
            } else {
                MessageDialog.openInformation((Shell)this.getShell(), (String)Diagram_Messages.TITLE_InvalidDir, (String)Diagram_Messages.MSG_InvalidDir);
            }
        }

        private void updateFileExtension() {
            String fileName = this.fileNameField.getText();
            if (!(StringUtils.isEmpty((String)fileName) || new File(fileName).isDirectory() || fileName.endsWith(this.imageFormat))) {
                fileName = String.valueOf(fileName.substring(0, fileName.lastIndexOf(".") + 1)) + this.imageFormat.toLowerCase();
                this.fileNameField.setText(fileName);
            }
        }
    }
}

