/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.editors.parts.diagram.actions;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.ui.actions.SelectionAction;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.modeling.core.Diagram_Messages;
import org.eclipse.stardust.modeling.core.editors.WorkflowModelEditor;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWizard;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.wizards.IWizardDescriptor;
import org.eclipse.ui.wizards.IWizardRegistry;

public class ImportModelElementsAction
extends SelectionAction {
    private static final String IMPORT_MODEL_ELEMENTS_WIZARD = "org.eclipse.stardust.modeling.modelimport.ImportModelElementsWizard";

    public ImportModelElementsAction(WorkflowModelEditor editor) {
        super((IWorkbenchPart)editor);
        this.setId("org.eclipse.stardust.modeling.modelimport.modelElements");
        this.setText(Diagram_Messages.TXT_IMPORT_MD_ELEMENT);
    }

    protected boolean calculateEnabled() {
        if (this.getSelectedObjects().size() == 1 && this.getModel() != null) {
            IWizardRegistry registry = PlatformUI.getWorkbench().getImportWizardRegistry();
            IWizardDescriptor descriptor = registry.findWizard(IMPORT_MODEL_ELEMENTS_WIZARD);
            return descriptor != null;
        }
        return false;
    }

    public void run() {
        IWizardRegistry registry = PlatformUI.getWorkbench().getImportWizardRegistry();
        IWizardDescriptor descriptor = registry.findWizard(IMPORT_MODEL_ELEMENTS_WIZARD);
        try {
            IWorkbenchWizard wizard = descriptor.createWizard();
            wizard.init(PlatformUI.getWorkbench(), (IStructuredSelection)new StructuredSelection((Object)this.getWorkbenchPart()));
            WizardDialog dialog = new WizardDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (IWizard)wizard);
            dialog.setBlockOnOpen(true);
            dialog.open();
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    private ModelType getModel() {
        Object selection = this.getSelectedObjects().get(0);
        if (!(selection instanceof EditPart)) {
            return null;
        }
        Object element = ((EditPart)selection).getModel();
        return (ModelType)(element instanceof ModelType ? element : null);
    }
}

