/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.editors.parts.diagram.actions;

import java.net.URI;
import java.util.List;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.stardust.common.error.InternalException;
import org.eclipse.stardust.model.xpdl.carnot.ActivityType;
import org.eclipse.stardust.model.xpdl.carnot.CarnotWorkflowModelPackage;
import org.eclipse.stardust.model.xpdl.carnot.DiagramType;
import org.eclipse.stardust.model.xpdl.carnot.IModelElementNodeSymbol;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.model.xpdl.carnot.ProcessDefinitionType;
import org.eclipse.stardust.model.xpdl.carnot.util.ActivityUtil;
import org.eclipse.stardust.model.xpdl.carnot.util.ModelUtils;
import org.eclipse.stardust.modeling.common.platform.utils.WorkspaceUtils;
import org.eclipse.stardust.modeling.common.ui.jface.utils.FormBuilder;
import org.eclipse.stardust.modeling.core.Diagram_Messages;
import org.eclipse.stardust.modeling.core.editors.WorkflowModelEditor;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.DiagramEditPart;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.actions.UpdateDiagramAction;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;

public class OpenDiagramAction
extends UpdateDiagramAction {
    public static final int DIAGRAM = 0;
    public static final int DEFAULT_DIAGRAM = 1;
    public static final int DEFAULT_SUBPROCESS_DIAGRAM = 2;
    private int kind;

    public OpenDiagramAction(WorkflowModelEditor editor, int kind) {
        super(editor);
        this.kind = kind;
        this.initUI();
    }

    @Override
    protected boolean calculateEnabled() {
        return this.getSelectedObjects().size() == 1 && this.getDiagram() != null && !((WorkflowModelEditor)this.getWorkbenchPart()).isActiveDiagram(this.getDiagram());
    }

    @Override
    public void run() {
        block12: {
            try {
                ModelType containingModel;
                ModelType model;
                DiagramType diagram = this.getDiagram();
                Command command = this.createUpdateDiagramCommand(diagram);
                if (command.canExecute()) {
                    MessageDialog dialog = new MessageDialog(this.getWorkbenchPart().getSite().getShell(), Diagram_Messages.MSG_UpdateDiagram, null, String.valueOf(Diagram_Messages.MSG_OpenDiagramAction1_Diagram) + diagram.getName() + Diagram_Messages.MSG_OpenDiagramAction2_isInconsistent + Diagram_Messages.MSG_OpenDiagramAction3_WantToUpdate, 3, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL, IDialogConstants.CANCEL_LABEL}, 0);
                    switch (dialog.open()) {
                        case 0: {
                            this.execute(command);
                            break;
                        }
                        case 1: {
                            break;
                        }
                        default: {
                            return;
                        }
                    }
                }
                if (!(model = (ModelType)((WorkflowModelEditor)this.getWorkbenchPart()).getModel()).equals(containingModel = ModelUtils.findContainingModel((EObject)diagram))) {
                    WorkflowModelEditor editor;
                    IFile file;
                    Dialog dialog = new Dialog(Display.getDefault().getActiveShell()){

                        protected Control createDialogArea(Composite parent) {
                            Composite panel = (Composite)super.createDialogArea(parent);
                            FormBuilder.createLabel((Composite)panel, (String)Diagram_Messages.LB_OPEN_REFERENCED_MODEL);
                            return panel;
                        }

                        protected void configureShell(Shell shell) {
                            super.configureShell(shell);
                            shell.setText(Diagram_Messages.TXT_ShowSubprocessDiagram);
                        }
                    };
                    if (dialog.open() != 0) break block12;
                    Path path = new Path(WorkspaceUtils.getLocation((ModelType)containingModel));
                    IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
                    IFile iFile = file = path.isAbsolute() ? root.getFileForLocation((IPath)path) : root.getFile((IPath)path);
                    if (file == null) {
                        try {
                            file = EFS.getStore((URI)path.toFile().toURI());
                        }
                        catch (CoreException e) {
                            e.printStackTrace();
                        }
                    }
                    if (file != null && (editor = this.getEditor((IAdaptable)file)) != null) {
                        ProcessDefinitionType containingProcess = ModelUtils.findContainingProcess((EObject)diagram);
                        ModelType diagramModel = (ModelType)editor.getModel();
                        ProcessDefinitionType targetProcess = (ProcessDefinitionType)ModelUtils.findElementById((EObject)diagramModel, (EStructuralFeature)CarnotWorkflowModelPackage.eINSTANCE.getModelType_ProcessDefinition(), (String)containingProcess.getId());
                        DiagramType targetDiagram = (DiagramType)ModelUtils.findElementByOid((List)targetProcess.getDiagram(), (long)diagram.getElementOid());
                        editor.showDiagramPage(targetDiagram);
                    }
                    break block12;
                }
                ((WorkflowModelEditor)this.getWorkbenchPart()).showDiagramPage(diagram);
            }
            catch (PartInitException e) {
                e.printStackTrace();
            }
        }
    }

    private DiagramType getDiagram() {
        EList diagrams;
        ProcessDefinitionType process;
        ActivityType activity;
        ProcessDefinitionType process2;
        ModelType model;
        EList diagrams2;
        Object selection = this.getSelectedObjects().get(0);
        if (!(selection instanceof EditPart) || selection instanceof DiagramEditPart) {
            return null;
        }
        Object element = ((EditPart)selection).getModel();
        if (element instanceof IModelElementNodeSymbol) {
            element = ((IModelElementNodeSymbol)element).getModelElement();
        }
        if (element instanceof DiagramType && this.kind == 0) {
            return (DiagramType)element;
        }
        if (element instanceof ModelType && this.kind == 1 && (diagrams2 = (model = (ModelType)element).getDiagram()).size() > 0) {
            return (DiagramType)diagrams2.get(0);
        }
        if (element instanceof ProcessDefinitionType && this.kind == 1 && (diagrams2 = (process2 = (ProcessDefinitionType)element).getDiagram()).size() > 0) {
            return (DiagramType)diagrams2.get(0);
        }
        if (element instanceof ActivityType && this.kind == 2 && (activity = (ActivityType)element) != null && ActivityUtil.isSubprocessActivity((ActivityType)activity) && (process = activity.getImplementationProcess()) != null && (diagrams = process.getDiagram()).size() > 0) {
            return (DiagramType)diagrams.get(0);
        }
        return null;
    }

    @Override
    protected void initUI() {
        super.init();
        switch (this.kind) {
            case 0: {
                this.setId("org.eclipse.stardust.modeling.core.open");
                this.setText(Diagram_Messages.TXT_ShowDiagram);
                break;
            }
            case 1: {
                this.setId("org.eclipse.stardust.modeling.core.process.open");
                this.setText(Diagram_Messages.TXT_ShowDefaultDiagram);
                break;
            }
            case 2: {
                this.setId("org.eclipse.stardust.modeling.core.subprocess.open");
                this.setText(Diagram_Messages.TXT_ShowSubprocessDiagram);
            }
        }
    }

    private WorkflowModelEditor getEditor(IAdaptable file) {
        IWorkbench workbench = PlatformUI.getWorkbench();
        if (file instanceof IFile && !((IFile)file).exists()) {
            MessageBox messageBox = new MessageBox(Display.getDefault().getActiveShell(), 40);
            messageBox.setText(Diagram_Messages.TXT_ShowSubprocessDiagram);
            messageBox.setMessage(Diagram_Messages.MSG_ProviderFileNotExists);
            messageBox.open();
            return null;
        }
        ModelLoader loader = new ModelLoader(workbench, file, true);
        workbench.getDisplay().syncExec((Runnable)loader);
        PartInitException x = loader.getException();
        if (x != null) {
            throw new InternalException("");
        }
        return loader.getEditor();
    }

    private static final class ModelLoader
    implements Runnable {
        private final IWorkbench workbench;
        private IAdaptable file;
        private boolean activate;
        private PartInitException exception;
        private WorkflowModelEditor editor;

        private ModelLoader(IWorkbench workbench, IAdaptable file, boolean activate) {
            this.workbench = workbench;
            this.file = file;
            this.activate = activate;
        }

        @Override
        public void run() {
            this.editor = null;
            IWorkbenchWindow wbw = this.workbench.getActiveWorkbenchWindow();
            IWorkbenchPage wbp = wbw.getActivePage();
            try {
                IEditorPart part = null;
                if (this.file instanceof IFile) {
                    part = IDE.openEditor((IWorkbenchPage)wbp, (IFile)((IFile)this.file), (boolean)this.activate);
                } else if (this.file instanceof IFileStore) {
                    part = IDE.openEditorOnFileStore((IWorkbenchPage)wbp, (IFileStore)((IFileStore)this.file));
                }
                if (part instanceof WorkflowModelEditor) {
                    this.editor = (WorkflowModelEditor)part;
                }
            }
            catch (PartInitException x) {
                this.exception = x;
            }
        }

        public PartInitException getException() {
            return this.exception;
        }

        public WorkflowModelEditor getEditor() {
            return this.editor;
        }
    }
}

