/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.editors.parts.diagram.actions;

import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.editparts.AbstractEditPart;
import org.eclipse.gef.ui.actions.SelectionAction;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.NewSearchUI;
import org.eclipse.stardust.model.xpdl.carnot.DataPathType;
import org.eclipse.stardust.model.xpdl.carnot.IConnectionSymbol;
import org.eclipse.stardust.model.xpdl.carnot.IIdentifiableModelElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelElementNodeSymbol;
import org.eclipse.stardust.model.xpdl.carnot.TransitionConnectionType;
import org.eclipse.stardust.model.xpdl.carnot.TriggerType;
import org.eclipse.stardust.model.xpdl.xpdl2.ExternalPackage;
import org.eclipse.stardust.model.xpdl.xpdl2.TypeDeclarationType;
import org.eclipse.stardust.modeling.core.Diagram_Messages;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.AbstractConnectionSymbolEditPart;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.AbstractModelElementNodeSymbolEditPart;
import org.eclipse.stardust.modeling.core.editors.parts.tree.AbstractEObjectTreeEditPart;
import org.eclipse.stardust.modeling.core.editors.parts.tree.ChildCategoryNode;
import org.eclipse.stardust.modeling.core.editors.parts.tree.IdentifiableModelElementTreeEditPart;
import org.eclipse.stardust.modeling.core.search.ElementReferenceSearcher;
import org.eclipse.stardust.modeling.core.search.ReferenceSearchQuery;
import org.eclipse.stardust.modeling.core.search.ReferencesSearchResult;
import org.eclipse.ui.IWorkbenchPart;

public class ReferencesSearchAction
extends SelectionAction {
    public ReferencesSearchAction(IWorkbenchPart part) {
        super(part);
        this.setId("org.eclipse.stardust.modeling.core.referencesSearch");
        this.setText(Diagram_Messages.LB_EDITOR_References);
    }

    protected boolean calculateEnabled() {
        return this.getModelElement() != null;
    }

    private EObject getModelElement() {
        EObject modelElement = null;
        List selection = this.getSelectedObjects();
        if (selection == null || selection.isEmpty() || selection.size() != 1) {
            return modelElement;
        }
        if (!(selection.get(0) instanceof AbstractEditPart)) {
            return modelElement;
        }
        AbstractEditPart editPart = (AbstractEditPart)selection.get(0);
        if (editPart instanceof IdentifiableModelElementTreeEditPart) {
            modelElement = (EObject)editPart.getModel();
        } else if (editPart instanceof AbstractConnectionSymbolEditPart) {
            IConnectionSymbol connectionSymbol = (IConnectionSymbol)((AbstractConnectionSymbolEditPart)editPart).getModel();
            if (connectionSymbol instanceof TransitionConnectionType) {
                modelElement = ((TransitionConnectionType)connectionSymbol).getTransition();
            }
        } else if (editPart instanceof AbstractModelElementNodeSymbolEditPart) {
            modelElement = ((IModelElementNodeSymbol)((AbstractModelElementNodeSymbolEditPart)editPart).getModel()).getModelElement();
        } else if (editPart instanceof AbstractEObjectTreeEditPart) {
            Object data = ((AbstractEObjectTreeEditPart)editPart).getModel();
            if (data instanceof ChildCategoryNode.Spec) {
                return null;
            }
            modelElement = (EObject)((AbstractEObjectTreeEditPart)editPart).getModel();
            if (modelElement instanceof ExternalPackage) {
                return modelElement;
            }
            if (!(modelElement instanceof TypeDeclarationType)) {
                modelElement = null;
            }
        }
        if (modelElement instanceof DataPathType) {
            return null;
        }
        if (modelElement instanceof TriggerType) {
            return null;
        }
        return modelElement;
    }

    public void run() {
        final EObject modelElement = this.getModelElement();
        NewSearchUI.activateSearchResultView();
        NewSearchUI.runQueryInBackground((ISearchQuery)new ReferenceSearchQuery(){

            @Override
            public IStatus run(IProgressMonitor monitor) throws OperationCanceledException {
                super.run(monitor);
                ElementReferenceSearcher searcher = new ElementReferenceSearcher();
                Map matchedElements = searcher.search(modelElement);
                ((ReferencesSearchResult)this.getSearchResult()).setLabel(this.getLabel());
                ((ReferencesSearchResult)this.getSearchResult()).getMatchedElements().putAll(matchedElements);
                return Status.OK_STATUS;
            }

            @Override
            public String getLabel() {
                if (modelElement instanceof IIdentifiableModelElement) {
                    return ((IIdentifiableModelElement)modelElement).getId();
                }
                if (modelElement instanceof TypeDeclarationType) {
                    return ((TypeDeclarationType)modelElement).getId();
                }
                if (modelElement instanceof ExternalPackage) {
                    return ((ExternalPackage)modelElement).getId();
                }
                return "";
            }
        });
    }
}

