/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.editors.parts.diagram.actions;

import org.eclipse.gef.EditPart;
import org.eclipse.gef.ui.actions.SelectionAction;
import org.eclipse.stardust.engine.core.model.beans.QNameUtil;
import org.eclipse.stardust.model.xpdl.xpdl2.ExternalReferenceType;
import org.eclipse.stardust.model.xpdl.xpdl2.TypeDeclarationType;
import org.eclipse.stardust.model.xpdl.xpdl2.XpdlTypeType;
import org.eclipse.stardust.model.xpdl.xpdl2.util.TypeDeclarationUtils;
import org.eclipse.stardust.modeling.core.Diagram_Messages;
import org.eclipse.ui.IWorkbenchPart;

public class ReloadSchemaAction
extends SelectionAction {
    public ReloadSchemaAction(IWorkbenchPart part) {
        super(part);
        this.setId("org.eclipse.stardust.modeling.core.reloadSchema");
        this.setText(Diagram_Messages.LB_RELOAD_SCHEMA);
    }

    protected boolean calculateEnabled() {
        return this.getKeyForSchemaCache() != null;
    }

    private TypeDeclarationType getTypeDeclaration() {
        Object model;
        Object selection;
        if (this.getSelectedObjects() != null && this.getSelectedObjects().size() == 1 && (selection = this.getSelectedObjects().get(0)) instanceof EditPart && (model = ((EditPart)selection).getModel()) instanceof TypeDeclarationType) {
            return (TypeDeclarationType)model;
        }
        return null;
    }

    private String getKeyForSchemaCache() {
        String location;
        XpdlTypeType type;
        TypeDeclarationType typeDeclaration = this.getTypeDeclaration();
        if (typeDeclaration != null && (type = typeDeclaration.getDataType()) instanceof ExternalReferenceType && !(location = ((ExternalReferenceType)type).getLocation()).startsWith("urn:internal:") && location.toLowerCase().startsWith("http://")) {
            String namespaceURI = QNameUtil.parseNamespaceURI((String)((ExternalReferenceType)type).getXref());
            String key = String.valueOf('{') + namespaceURI + '}' + location;
            return key;
        }
        return null;
    }

    public void run() {
        String keyForSchemaCache = this.getKeyForSchemaCache();
        TypeDeclarationUtils.clearSchemaCache((String)keyForSchemaCache);
    }
}

