/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.editors.parts.diagram.actions;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.ui.actions.SelectionAction;
import org.eclipse.stardust.modeling.core.DiagramPlugin;
import org.eclipse.stardust.modeling.core.editors.WorkflowModelEditor;
import org.eclipse.stardust.modeling.repository.common.Connection;
import org.eclipse.stardust.modeling.repository.common.SearchConnectionHandler;
import org.eclipse.ui.IWorkbenchPart;

public class SearchConnectionAction
extends SelectionAction {
    private IConfigurationElement config;
    private SearchConnectionHandler handler;
    private Connection connection;

    public SearchConnectionAction(IConfigurationElement config, WorkflowModelEditor part) {
        super((IWorkbenchPart)part);
        this.config = config;
        this.setId("org.eclipse.stardust.modeling.repository.common.search" + config.getAttribute("id"));
        this.setText(config.getAttribute("name"));
        this.setImageDescriptor(DiagramPlugin.getImageDescriptor(config));
    }

    protected boolean calculateEnabled() {
        return this.getSelectedObjects().size() == 1 && this.supportsSearch();
    }

    public boolean supportsSearch() {
        Object model;
        Object entry = this.getSelectedObjects().get(0);
        if (entry instanceof EditPart && (model = ((EditPart)entry).getModel()) instanceof Connection) {
            String type = ((Connection)model).getType();
            if (this.config.getAttribute("id").equals(type) && this.supportSearch()) {
                this.connection = (Connection)model;
                return true;
            }
        }
        return false;
    }

    private boolean supportSearch() {
        try {
            this.handler = (SearchConnectionHandler)this.config.createExecutableExtension("handler");
            if (this.handler.supportsSearch()) {
                return true;
            }
        }
        catch (CoreException coreException) {}
        return false;
    }

    public void run() {
        this.handler.performSearch(this.connection);
    }
}

