/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.editors.parts.diagram.actions;

import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.draw2d.geometry.PrecisionRectangle;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.SnapToHelper;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.requests.AlignmentRequest;
import org.eclipse.gef.ui.actions.SelectionAction;
import org.eclipse.stardust.model.xpdl.carnot.INodeSymbol;
import org.eclipse.stardust.modeling.core.Diagram_Messages;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.AbstractNodeSymbolEditPart;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.commands.MoveNodeSymbolCommand;
import org.eclipse.ui.IWorkbenchPart;

public class SnapToGridAction
extends SelectionAction {
    private CompoundCommand command;

    public SnapToGridAction(IWorkbenchPart part) {
        super(part);
        this.setId("org.eclipse.stardust.modeling.core.snapToGrid");
        this.setText(Diagram_Messages.LB_SnapToGrid);
    }

    protected boolean calculateEnabled() {
        return this.isEditPartSelected() && this.isSnapToGridEnabled() && this.canExecute();
    }

    private boolean canExecute() {
        this.command = new CompoundCommand();
        this.createSnapToGridCmd();
        boolean isEnabled = this.command.canExecute();
        return isEnabled;
    }

    private boolean isEditPartSelected() {
        return this.getSelectedObjects() != null && this.getSelectedObjects().size() > 0 && this.isNodeSymbolEditPart();
    }

    private boolean isSnapToGridEnabled() {
        if (((EditPart)this.getSelectedObjects().get(0)).getParent() == null) {
            return false;
        }
        return Boolean.TRUE.equals(((EditPart)this.getSelectedObjects().get(0)).getViewer().getProperty("SnapToGrid.isEnabled")) && (Boolean.FALSE.equals(((EditPart)this.getSelectedObjects().get(0)).getViewer().getProperty("SnapToGeometry.isEnabled")) || ((EditPart)this.getSelectedObjects().get(0)).getViewer().getProperty("SnapToGeometry.isEnabled") == null);
    }

    private boolean isNodeSymbolEditPart() {
        for (Object part : this.getSelectedObjects()) {
            if (part instanceof AbstractNodeSymbolEditPart) continue;
            return false;
        }
        return true;
    }

    public void run() {
        this.execute((Command)this.command);
    }

    private void createSnapToGridCmd() {
        List editParts = this.getSelectedObjects();
        for (AbstractNodeSymbolEditPart part : editParts) {
            INodeSymbol cfr_ignored_0 = (INodeSymbol)part.getModel();
            IFigure figure = part.getFigure();
            PrecisionRectangle rect = new PrecisionRectangle(figure.getBounds());
            figure.translateToAbsolute((Translatable)rect);
            PrecisionRectangle baseRect = rect.getPreciseCopy();
            PrecisionPoint preciseDelta = new PrecisionPoint(0, 0);
            SnapToHelper snapToHelper = null;
            if (part.getParent() != null) {
                snapToHelper = (SnapToHelper)part.getParent().getAdapter(SnapToHelper.class);
            }
            if (snapToHelper == null) continue;
            snapToHelper.snapPoint((Request)new AlignmentRequest(), 192, new PrecisionRectangle[]{baseRect}, preciseDelta);
            MoveNodeSymbolCommand moveCommand = new MoveNodeSymbolCommand();
            moveCommand.setPart((INodeSymbol)part.getModel());
            Point oldLocation = new PrecisionRectangle(new Rectangle(new Long(((INodeSymbol)part.getModel()).getXPos()).intValue(), new Long(((INodeSymbol)part.getModel()).getYPos()).intValue(), ((INodeSymbol)part.getModel()).getWidth(), ((INodeSymbol)part.getModel()).getHeight())).getLocation();
            Point newLocation = preciseDelta.getTranslated(oldLocation);
            moveCommand.setLocation(newLocation);
            if (newLocation.equals((Object)oldLocation)) continue;
            this.command.add((Command)moveCommand);
        }
    }
}

