/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.editors.parts.diagram.actions;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gef.ui.actions.SelectionAction;
import org.eclipse.stardust.model.xpdl.carnot.CarnotWorkflowModelPackage;
import org.eclipse.stardust.model.xpdl.carnot.GroupSymbolType;
import org.eclipse.stardust.model.xpdl.carnot.IConnectionSymbol;
import org.eclipse.stardust.model.xpdl.carnot.INodeSymbol;
import org.eclipse.stardust.model.xpdl.carnot.ISymbolContainer;
import org.eclipse.stardust.modeling.core.Diagram_Messages;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.SymbolGroupEditPart;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.commands.DeleteValueCmd;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.commands.SetValueCmd;
import org.eclipse.ui.IWorkbenchPart;

public class UngroupSymbolsAction
extends SelectionAction {
    public UngroupSymbolsAction(IWorkbenchPart part) {
        super(part);
        this.setId("org.eclipse.stardust.modeling.core.ungroupSymbols");
        this.setText(Diagram_Messages.UNGROUP_SYMBOLS_LABEL);
    }

    protected boolean calculateEnabled() {
        Command cmd = this.createUngroupSymbolsCommand();
        return cmd != null ? cmd.canExecute() : false;
    }

    public void run() {
        this.execute(this.createUngroupSymbolsCommand());
    }

    private Command createUngroupSymbolsCommand() {
        CompoundCommand result = new CompoundCommand();
        if (1 == this.getSelectedObjects().size() && this.getSelectedObjects().get(0) instanceof SymbolGroupEditPart) {
            GroupSymbolType group = (GroupSymbolType)((SymbolGroupEditPart)this.getSelectedObjects().get(0)).getModel();
            if (group.eContainer() instanceof ISymbolContainer) {
                CompoundCommand cmdAddToDiagram = new CompoundCommand();
                FeatureMap.ValueListIterator i = group.getNodes().valueListIterator();
                while (i.hasNext()) {
                    INodeSymbol node = (INodeSymbol)i.next();
                    if (node.eContainmentFeature() != null) {
                        result.add((Command)new DeleteValueCmd((EObject)group, node, (EStructuralFeature)node.eContainmentFeature()));
                        cmdAddToDiagram.add((Command)new SetValueCmd((EObject)node, (EStructuralFeature)CarnotWorkflowModelPackage.eINSTANCE.getINodeSymbol_XPos(), (Object)new Long(node.getXPos() + group.getXPos())));
                        cmdAddToDiagram.add((Command)new SetValueCmd((EObject)node, (EStructuralFeature)CarnotWorkflowModelPackage.eINSTANCE.getINodeSymbol_YPos(), (Object)new Long(node.getYPos() + group.getYPos())));
                        cmdAddToDiagram.add((Command)new SetValueCmd(group.eContainer(), (EStructuralFeature)node.eContainmentFeature(), (Object)node));
                        continue;
                    }
                    result.add((Command)UnexecutableCommand.INSTANCE);
                }
                i = group.getConnections().valueListIterator();
                while (i.hasNext()) {
                    IConnectionSymbol connection = (IConnectionSymbol)i.next();
                    if (connection.eContainmentFeature() != null) {
                        result.add((Command)new DeleteValueCmd((EObject)group, connection, (EStructuralFeature)connection.eContainmentFeature()));
                        result.add((Command)new SetValueCmd(group.eContainer(), (EStructuralFeature)connection.eContainmentFeature(), (Object)connection));
                        continue;
                    }
                    result.add((Command)UnexecutableCommand.INSTANCE);
                }
                result.add((Command)new DeleteValueCmd(group.eContainer(), group, (EStructuralFeature)CarnotWorkflowModelPackage.eINSTANCE.getISymbolContainer_GroupSymbol()));
                result.add((Command)cmdAddToDiagram);
            } else {
                result.add((Command)UnexecutableCommand.INSTANCE);
            }
        } else {
            result.add((Command)UnexecutableCommand.INSTANCE);
        }
        return result.unwrap();
    }
}

