/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.editors.parts.diagram.actions;

import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gef.ui.actions.SelectionAction;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.stardust.modeling.core.Diagram_Messages;
import org.eclipse.stardust.modeling.core.editors.WorkflowModelEditor;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.actions.UpdateProcessDiagramAction;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.actions.UpgradeModelAction;
import org.eclipse.stardust.modeling.core.editors.parts.tree.ModelTreeEditPart;
import org.eclipse.ui.IWorkbenchPart;

public class UpgradeModelAndDiagramAction
extends SelectionAction {
    private WorkflowModelEditor editor;

    public UpgradeModelAndDiagramAction(WorkflowModelEditor editor) {
        super((IWorkbenchPart)editor);
        this.editor = editor;
        this.setId("org.eclipse.stardust.model.xpdl.upgradeModelDiagram");
        this.setText(Diagram_Messages.LB_UpgradeModel);
    }

    protected boolean calculateEnabled() {
        UnexecutableCommand cmd = UnexecutableCommand.INSTANCE;
        Object obj = this.getSelection();
        if (obj instanceof IStructuredSelection && (obj = ((IStructuredSelection)obj).getFirstElement()) instanceof ModelTreeEditPart) {
            cmd = this.createUpgradeModelAndDiagramCmd();
        }
        return cmd.canExecute();
    }

    public void run() {
        this.execute(this.createUpgradeModelAndDiagramCmd());
        this.editor.refreshDiagramPages();
    }

    public Command createUpgradeModelAndDiagramCmd() {
        CompoundCommand cmd = new CompoundCommand();
        cmd.add(this.createUpdateModelCmd());
        cmd.add(this.createUpdateDiagramCmd());
        return cmd.unwrap();
    }

    private Command createUpdateModelCmd() {
        Command cmd = new UpgradeModelAction(this.editor).createUpdateModelCmd();
        return cmd instanceof UnexecutableCommand ? null : cmd;
    }

    private Command createUpdateDiagramCmd() {
        Command cmd = new UpdateProcessDiagramAction(this.editor).createUpdateDiagramCmd();
        return cmd instanceof UnexecutableCommand ? null : cmd;
    }
}

