/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.editors.parts.diagram.commands;

import java.util.ArrayList;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.draw2d.geometry.PrecisionRectangle;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.SnapToHelper;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.stardust.model.xpdl.carnot.INodeSymbol;
import org.eclipse.stardust.modeling.core.Diagram_Messages;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.AbstractNodeSymbolEditPart;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.LaneEditPart;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.commands.MoveNodeSymbolCommand;
import org.eclipse.swt.widgets.Shell;

public class ChangeConstraintCommand
extends MoveNodeSymbolCommand {
    private CompoundCommand cmd = new CompoundCommand();
    private EditPart target;
    private EditPart host;
    private boolean snapToGrid = true;
    private boolean isColliding = false;

    @Override
    public void execute() {
        if (this.getHost().equals(this.target.getParent())) {
            Shell shell;
            boolean result;
            if (this.isColliding && !(result = MessageDialog.openQuestion((Shell)(shell = ((EditPart)this.getHost()).getViewer().getControl().getShell()), (String)Diagram_Messages.MSG_DIA_MOVE_SYMBOLS, (String)Diagram_Messages.MSG_DIA_THIS_ACTION_WILL_CAUSE_OVERLAPPING_OF_SYMBOLS_DO_YOU_WANT_TO_CONTINUE))) {
                return;
            }
            int oldPosX = new Long(((INodeSymbol)this.target.getModel()).getXPos()).intValue();
            int oldPosY = new Long(((INodeSymbol)this.target.getModel()).getYPos()).intValue();
            super.execute();
            if (this.target instanceof LaneEditPart && this.snapToGrid) {
                this.createLaneSnapToGridCmd(oldPosX, oldPosY);
            }
        }
    }

    private Object getHost() {
        return this.host;
    }

    @Override
    public void redo() {
        this.cmd.redo();
        super.redo();
    }

    @Override
    public void undo() {
        this.cmd.undo();
        super.undo();
    }

    private void createLaneSnapToGridCmd(int oldPosX, int oldPosY) {
        int newPosX = new Long(((LaneEditPart)this.target).getLaneModel().getXPos()).intValue();
        int newPosY = new Long(((LaneEditPart)this.target).getLaneModel().getYPos()).intValue();
        for (AbstractNodeSymbolEditPart editPart : this.target.getChildren()) {
            int symbolX = new Long(((INodeSymbol)editPart.getModel()).getXPos()).intValue();
            int symbolY = new Long(((INodeSymbol)editPart.getModel()).getYPos()).intValue();
            PrecisionRectangle rect = new PrecisionRectangle(editPart.getFigure().getBounds());
            editPart.getFigure().translateToAbsolute((Translatable)rect);
            PrecisionRectangle newRect = new PrecisionRectangle(new Rectangle(new Point(rect.x - (oldPosX - newPosX), rect.y - (oldPosY - newPosY)), rect.getSize()));
            PrecisionRectangle baseRect = newRect.getPreciseCopy();
            PrecisionPoint preciseDelta = new PrecisionPoint(0, 0);
            SnapToHelper snapToHelper = (SnapToHelper)this.target.getAdapter(SnapToHelper.class);
            Point translated = null;
            if (snapToHelper != null) {
                ChangeBoundsRequest fakeRequest = new ChangeBoundsRequest();
                fakeRequest.setLocation(new Point(symbolX, symbolY));
                Point moveDelta = new Point(0, 0);
                fakeRequest.setMoveDelta(moveDelta);
                fakeRequest.setType((Object)"resize");
                fakeRequest.setEditParts(new ArrayList());
                snapToHelper.snapPoint((Request)fakeRequest, 192, new PrecisionRectangle[]{baseRect}, preciseDelta);
                translated = preciseDelta.getTranslated(new Point(symbolX, symbolY));
            }
            if (translated == null) continue;
            MoveNodeSymbolCommand moveCommand = new MoveNodeSymbolCommand();
            moveCommand.setPart((INodeSymbol)editPart.getModel());
            moveCommand.setLocation(translated);
            this.cmd.add((Command)moveCommand);
        }
        this.target.getViewer().getEditDomain().getCommandStack().execute((Command)this.cmd);
    }

    public void setColliding(boolean isColliding) {
        this.isColliding = isColliding;
    }

    public void setTarget(EditPart target) {
        this.target = target;
    }

    public void setHost(EditPart host) {
        this.host = host;
    }

    public void setSnapToGrid(boolean set) {
        this.snapToGrid = set;
    }
}

