/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.editors.parts.diagram.commands;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.stardust.model.xpdl.carnot.CarnotWorkflowModelPackage;
import org.eclipse.stardust.model.xpdl.carnot.DiagramType;
import org.eclipse.stardust.model.xpdl.carnot.IGraphicalObject;
import org.eclipse.stardust.model.xpdl.carnot.ISymbolContainer;
import org.eclipse.stardust.model.xpdl.carnot.LaneSymbol;
import org.eclipse.stardust.model.xpdl.carnot.PoolSymbol;
import org.eclipse.stardust.model.xpdl.xpdl2.XpdlPackage;
import org.eclipse.stardust.modeling.core.Diagram_Messages;

public class CommandUtils {
    public static ContainmentState backupContainment(Object item, List container) {
        ContainmentState descriptor = new ContainmentState(item, container, container.indexOf(item));
        return descriptor;
    }

    public static ContainmentState backupContainment(EObject item) {
        ContainmentState descriptor = null;
        if (item != null && item.eContainer() != null) {
            EReference eFtrContainment = item.eContainmentFeature();
            Object containment = item.eContainer().eGet((EStructuralFeature)eFtrContainment);
            if (containment instanceof List) {
                descriptor = new ContainmentState(item, (List)containment, ((List)containment).indexOf(item));
            } else if (containment instanceof EObject) {
                descriptor = null;
            }
        }
        return descriptor;
    }

    public static void undoContainment(ContainmentState state) {
        if (state != null) {
            state.container.remove(state.item);
        }
    }

    public static void redoContainment(ContainmentState state) {
        if (state != null && state.position != -1) {
            if (state.position < state.container.size()) {
                state.container.add(state.position, state.item);
            } else {
                state.container.add(state.item);
            }
        }
    }

    public static EStructuralFeature findContainmentFeature(List containingFeatures, IGraphicalObject symbol) {
        EStructuralFeature result = null;
        for (EStructuralFeature feature : containingFeatures) {
            if (!feature.getEType().isInstance((Object)symbol)) continue;
            if (result != null) {
                throw new RuntimeException(String.valueOf(Diagram_Messages.EX_RUNTIME_FoundMultipleFeatures) + symbol + ": " + result + " vs. " + feature + ".");
            }
            result = feature;
        }
        return result;
    }

    public static EStructuralFeature findContainmentFeature(List containingFeatures, EClass eClass) {
        EStructuralFeature result = null;
        for (EStructuralFeature feature : containingFeatures) {
            if (feature.isTransient() && !feature.getEContainingClass().equals(CarnotWorkflowModelPackage.eINSTANCE.getISymbolContainer()) && !feature.getEContainingClass().equals(XpdlPackage.eINSTANCE.getTypeDeclarationsType()) || !feature.getEType().equals(eClass)) continue;
            if (result != null) {
                return null;
            }
            result = feature;
        }
        return result;
    }

    public static DiagramType getDiagram(ISymbolContainer symbolContainer) {
        DiagramType diagram = null;
        if (symbolContainer instanceof DiagramType) {
            diagram = (DiagramType)symbolContainer;
        } else {
            PoolSymbol pool = null;
            if (symbolContainer instanceof PoolSymbol) {
                pool = (PoolSymbol)symbolContainer;
            } else if (symbolContainer instanceof LaneSymbol) {
                pool = ((LaneSymbol)symbolContainer).getParentPool();
            }
            if (pool != null) {
                diagram = pool.getDiagram();
            }
        }
        return diagram;
    }

    public static List getSymbols(ISymbolContainer symbolContainer, EClass eClass) {
        ArrayList list = new ArrayList();
        ISymbolContainer top = symbolContainer instanceof LaneSymbol ? ((LaneSymbol)symbolContainer).getParentPool() : symbolContainer;
        CommandUtils.addElements(list, top, eClass);
        return list;
    }

    private static void addElements(ArrayList list, ISymbolContainer symbolContainer, EClass eClass) {
        EStructuralFeature feature = CommandUtils.findContainmentFeature(symbolContainer.getNodeContainingFeatures(), eClass);
        if (feature != null) {
            List elements = (List)symbolContainer.eGet(feature);
            list.addAll(elements);
            List children = Collections.EMPTY_LIST;
            if (symbolContainer instanceof DiagramType) {
                children = ((DiagramType)symbolContainer).getPoolSymbols();
            } else if (symbolContainer instanceof PoolSymbol) {
                children = ((PoolSymbol)symbolContainer).getLanes();
            }
            Iterator i = children.iterator();
            while (i.hasNext()) {
                CommandUtils.addElements(list, (ISymbolContainer)i.next(), eClass);
            }
        }
    }

    public static class ContainmentState {
        private Object item;
        private List container;
        private int position;

        public ContainmentState(Object item, List container, int position) {
            this.item = item;
            this.container = container;
            this.position = position;
        }
    }
}

