/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.editors.parts.diagram.commands;

import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.stardust.model.xpdl.xpdl2.TypeDeclarationType;
import org.eclipse.stardust.model.xpdl.xpdl2.XpdlFactory;
import org.eclipse.stardust.modeling.common.ui.IdFactory;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.commands.CommandUtils;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.commands.ContainedElementCommand;

public class CreateXpdlElementCommand
extends ContainedElementCommand {
    private EClass eClass;
    private IdFactory idFactory;
    private EObject xpdlElement;

    public CreateXpdlElementCommand(int parentLevel, IdFactory idFactory, EClass eClass) {
        super(parentLevel);
        this.idFactory = idFactory;
        this.eClass = eClass;
    }

    public void execute() {
        this.xpdlElement = this.createXpdlElement();
        this.redo();
    }

    public boolean canExecute() {
        return this.getContainingFeature() != null;
    }

    public IdFactory getIdFactory() {
        return this.idFactory;
    }

    public EObject getXpdlElement() {
        return this.xpdlElement;
    }

    public EClass getEClass() {
        return this.eClass;
    }

    protected EObject createXpdlElement() {
        XpdlFactory factory = XpdlFactory.eINSTANCE;
        EObject xpdlElement = factory.create(this.eClass);
        if (xpdlElement instanceof TypeDeclarationType && this.idFactory != null) {
            List list = (List)this.getContainer().eGet(this.getContainingFeature());
            this.idFactory.computeNames(list);
            ((TypeDeclarationType)xpdlElement).setId(this.idFactory.getId());
            ((TypeDeclarationType)xpdlElement).setName(this.idFactory.getName());
        }
        return xpdlElement;
    }

    public void redo() {
        if (this.xpdlElement != null) {
            EList list = (EList)this.getContainer().eGet(this.getContainingFeature());
            list.add((Object)this.xpdlElement);
        }
    }

    public void undo() {
        if (this.xpdlElement != null) {
            EList list = (EList)this.getContainer().eGet(this.getContainingFeature());
            list.remove((Object)this.xpdlElement);
        }
    }

    @Override
    public void dispose() {
        this.xpdlElement = null;
        super.dispose();
    }

    public EStructuralFeature getContainingFeature() {
        return this.getContainer() == null ? null : CommandUtils.findContainmentFeature(this.getContainingFeatureList(), this.eClass);
    }

    protected List getContainingFeatureList() {
        return this.getContainer().eClass().getEStructuralFeatures();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CreateXpdlElementCommand)) {
            return false;
        }
        CreateXpdlElementCommand createXpdlElementCommand = (CreateXpdlElementCommand)o;
        if (!this.eClass.equals(createXpdlElementCommand.eClass)) {
            return false;
        }
        return this.idFactory.equals((Object)createXpdlElementCommand.idFactory);
    }

    public int hashCode() {
        int result = this.eClass.hashCode();
        result = 29 * result + this.idFactory.hashCode();
        return result;
    }
}

