/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.editors.parts.diagram.commands;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.stardust.model.xpdl.carnot.GenericLinkConnectionType;
import org.eclipse.stardust.model.xpdl.carnot.IConnectionSymbol;
import org.eclipse.stardust.model.xpdl.carnot.IGraphicalObject;
import org.eclipse.stardust.model.xpdl.carnot.IIdentifiableModelElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelElementNodeSymbol;
import org.eclipse.stardust.model.xpdl.carnot.INodeSymbol;
import org.eclipse.stardust.model.xpdl.carnot.LaneSymbol;
import org.eclipse.stardust.model.xpdl.carnot.PoolSymbol;
import org.eclipse.stardust.model.xpdl.carnot.RefersToConnectionType;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.commands.CommandUtils;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.commands.DeleteConnectionSymbolCmd;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.commands.DeleteGraphicalObjectCmd;

public class DeleteNodeSymbolCmd
extends DeleteGraphicalObjectCmd {
    private CompoundCommand connectionCommands;
    private List laneContainmentsBackup;
    private IIdentifiableModelElement nodeModelBackup;

    public DeleteNodeSymbolCmd(INodeSymbol symbol) {
        super((IGraphicalObject)symbol);
    }

    @Override
    public void execute() {
        this.createBackup();
        this.connectionCommands.execute();
        Iterator i = this.laneContainmentsBackup.iterator();
        while (i.hasNext()) {
            CommandUtils.undoContainment((CommandUtils.ContainmentState)i.next());
        }
        if (this.getCastedModel() instanceof IModelElementNodeSymbol) {
            ((IModelElementNodeSymbol)this.getCastedModel()).setModelElement(null);
        }
        super.execute();
    }

    @Override
    public void redo() {
        this.connectionCommands.redo();
        Iterator i = this.laneContainmentsBackup.iterator();
        while (i.hasNext()) {
            CommandUtils.undoContainment((CommandUtils.ContainmentState)i.next());
        }
        if (this.getCastedModel() instanceof IModelElementNodeSymbol) {
            ((IModelElementNodeSymbol)this.getCastedModel()).setModelElement(null);
        }
        super.redo();
    }

    @Override
    public void undo() {
        if (this.getCastedModel() instanceof IModelElementNodeSymbol && this.nodeModelBackup != null) {
            ((IModelElementNodeSymbol)this.getCastedModel()).setModelElement(this.nodeModelBackup);
        }
        super.undo();
        Iterator i = this.laneContainmentsBackup.iterator();
        while (i.hasNext()) {
            CommandUtils.redoContainment((CommandUtils.ContainmentState)i.next());
        }
        this.laneContainmentsBackup.clear();
        this.connectionCommands.undo();
    }

    private void createBackup() {
        this.connectionCommands = new CompoundCommand();
        HashSet connectionSet = new HashSet();
        if (!(this.getCastedModel() instanceof PoolSymbol) && !(this.getCastedModel() instanceof LaneSymbol)) {
            Iterator j;
            Object conValue;
            for (EReference conFtr : this.getCastedModel().getInConnectionFeatures()) {
                conValue = this.getCastedModel().eGet((EStructuralFeature)conFtr);
                if (conValue instanceof EList) {
                    j = ((EList)conValue).iterator();
                    while (j.hasNext()) {
                        this.addConnectionDeleteCmd(connectionSet, (IConnectionSymbol)j.next());
                    }
                    continue;
                }
                if (conValue == null) continue;
                this.addConnectionDeleteCmd(connectionSet, (IConnectionSymbol)conValue);
            }
            for (EReference conFtr : this.getCastedModel().getOutConnectionFeatures()) {
                conValue = this.getCastedModel().eGet((EStructuralFeature)conFtr);
                if (conValue instanceof EList) {
                    j = ((EList)conValue).iterator();
                    while (j.hasNext()) {
                        this.addConnectionDeleteCmd(connectionSet, (IConnectionSymbol)j.next());
                    }
                    continue;
                }
                if (conValue == null) continue;
                this.addConnectionDeleteCmd(connectionSet, (IConnectionSymbol)conValue);
            }
        }
        for (RefersToConnectionType refersToConn : this.getCastedModel().getReferingToConnections()) {
            this.addConnectionDeleteCmd(connectionSet, (IConnectionSymbol)refersToConn);
        }
        for (GenericLinkConnectionType linkConn : this.getCastedModel().getInLinks()) {
            this.addConnectionDeleteCmd(connectionSet, (IConnectionSymbol)linkConn);
        }
        for (GenericLinkConnectionType linkConn : this.getCastedModel().getOutLinks()) {
            this.addConnectionDeleteCmd(connectionSet, (IConnectionSymbol)linkConn);
        }
        this.laneContainmentsBackup = Collections.EMPTY_LIST;
        if (this.getCastedModel() instanceof IModelElementNodeSymbol) {
            this.nodeModelBackup = ((IModelElementNodeSymbol)this.getCastedModel()).getModelElement();
        }
    }

    private INodeSymbol getCastedModel() {
        return (INodeSymbol)this.getTarget();
    }

    private void addConnectionDeleteCmd(Set connectionSet, IConnectionSymbol connection) {
        if (!connectionSet.contains(connection)) {
            this.connectionCommands.add((Command)new DeleteConnectionSymbolCmd(connection));
            connectionSet.add(connection);
        }
    }
}

