/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.editors.parts.diagram.commands;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.stardust.model.xpdl.carnot.AbstractEventSymbol;
import org.eclipse.stardust.model.xpdl.carnot.ActivitySymbolType;
import org.eclipse.stardust.model.xpdl.carnot.AttributeType;
import org.eclipse.stardust.model.xpdl.carnot.CarnotWorkflowModelPackage;
import org.eclipse.stardust.model.xpdl.carnot.EndEventSymbol;
import org.eclipse.stardust.model.xpdl.carnot.GatewaySymbol;
import org.eclipse.stardust.model.xpdl.carnot.GroupSymbolType;
import org.eclipse.stardust.model.xpdl.carnot.IConnectionSymbol;
import org.eclipse.stardust.model.xpdl.carnot.IExtensibleElement;
import org.eclipse.stardust.model.xpdl.carnot.IGraphicalObject;
import org.eclipse.stardust.model.xpdl.carnot.INodeSymbol;
import org.eclipse.stardust.model.xpdl.carnot.ISymbolContainer;
import org.eclipse.stardust.model.xpdl.carnot.LaneSymbol;
import org.eclipse.stardust.model.xpdl.carnot.PoolSymbol;
import org.eclipse.stardust.model.xpdl.carnot.ProcessDefinitionType;
import org.eclipse.stardust.model.xpdl.carnot.PublicInterfaceSymbol;
import org.eclipse.stardust.model.xpdl.carnot.StartEventSymbol;
import org.eclipse.stardust.model.xpdl.carnot.TransitionConnectionType;
import org.eclipse.stardust.model.xpdl.carnot.util.AttributeUtil;
import org.eclipse.stardust.model.xpdl.carnot.util.ModelUtils;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.commands.DeleteConnectionSymbolCmd;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.commands.DeleteNodeSymbolCmd;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.commands.DeleteValueCmd;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.commands.SetValueCmd;

public class DeleteSymbolCommandFactory {
    public static Command createDeleteSymbolCommand(INodeSymbol symbol) {
        AbstractEventSymbol eventSymbol;
        CompoundCommand cmd = new CompoundCommand();
        if (symbol instanceof PublicInterfaceSymbol) {
            ProcessDefinitionType pdt = ModelUtils.findContainingProcess((EObject)symbol);
            SetValueCmd command = new SetValueCmd((EObject)pdt, (EStructuralFeature)CarnotWorkflowModelPackage.eINSTANCE.getProcessDefinitionType_FormalParameters(), null);
            cmd.add((Command)command);
            command = new SetValueCmd((EObject)pdt, (EStructuralFeature)CarnotWorkflowModelPackage.eINSTANCE.getProcessDefinitionType_FormalParameterMappings(), null);
            cmd.add((Command)command);
        }
        if (symbol instanceof StartEventSymbol && (eventSymbol = (AbstractEventSymbol)symbol).getModelElement() == null) {
            DeleteSymbolCommandFactory.removeEventAttr(cmd, "carnot:engine:controlflow.startActivity", eventSymbol.getOutTransitions().iterator());
        }
        if (symbol instanceof EndEventSymbol) {
            eventSymbol = (AbstractEventSymbol)symbol;
            DeleteSymbolCommandFactory.removeEventAttr(cmd, "carnot:engine:controlflow.endActivity", eventSymbol.getInTransitions().iterator());
        }
        if (symbol instanceof ActivitySymbolType) {
            ActivitySymbolType activitySymbol = (ActivitySymbolType)symbol;
            if (activitySymbol.getActivity() != null) {
                if (activitySymbol.getActivity().getJoin().getValue() != 0) {
                    for (TransitionConnectionType transitionConnection : activitySymbol.getInTransitions()) {
                        if (!(transitionConnection.getSourceNode() instanceof GatewaySymbol)) continue;
                        cmd.add((Command)new DeleteNodeSymbolCmd(transitionConnection.getSourceNode()));
                    }
                }
                if (activitySymbol.getActivity().getSplit().getValue() != 0) {
                    for (TransitionConnectionType transitionConnection : activitySymbol.getOutTransitions()) {
                        if (!(transitionConnection.getTargetNode() instanceof GatewaySymbol)) continue;
                        cmd.add((Command)new DeleteNodeSymbolCmd(transitionConnection.getTargetNode()));
                    }
                }
            }
        } else if (symbol instanceof GroupSymbolType) {
            GroupSymbolType groupSymbol = (GroupSymbolType)symbol;
            FeatureMap.ValueListIterator iter = groupSymbol.getNodes().valueListIterator();
            while (iter.hasNext()) {
                Object obj = iter.next();
                ArrayList connectionFeatures = new ArrayList();
                connectionFeatures.addAll(((INodeSymbol)obj).getInConnectionFeatures());
                connectionFeatures.addAll(((INodeSymbol)obj).getOutConnectionFeatures());
                for (EStructuralFeature feature : connectionFeatures) {
                    Object object = ((INodeSymbol)obj).eGet(feature);
                    if (object == null) continue;
                    if (feature.isMany()) {
                        Iterator iter2 = ((List)((IGraphicalObject)obj).eGet(feature)).iterator();
                        while (iter2.hasNext()) {
                            cmd.add((Command)new DeleteConnectionSymbolCmd((IConnectionSymbol)iter2.next()));
                        }
                        continue;
                    }
                    if (!(((IGraphicalObject)obj).eGet(feature) instanceof IConnectionSymbol)) continue;
                    cmd.add((Command)new DeleteConnectionSymbolCmd((IConnectionSymbol)((IGraphicalObject)obj).eGet(feature)));
                }
                cmd.add((Command)new DeleteNodeSymbolCmd((INodeSymbol)obj));
            }
        } else if (symbol instanceof LaneSymbol || symbol instanceof PoolSymbol) {
            DeleteSymbolCommandFactory.moveSymbolsToParentContainerCmd(symbol, cmd);
        }
        cmd.add((Command)new DeleteNodeSymbolCmd(symbol));
        return cmd;
    }

    private static void moveSymbolsToParentContainerCmd(INodeSymbol symbol, CompoundCommand cmd) {
        if (symbol instanceof ISymbolContainer && symbol.eContainer() instanceof ISymbolContainer) {
            CompoundCommand cmdAddToDiagram = new CompoundCommand();
            FeatureMap.ValueListIterator i = ((ISymbolContainer)symbol).getNodes().valueListIterator();
            while (i.hasNext()) {
                INodeSymbol node = (INodeSymbol)i.next();
                if (node.eContainmentFeature() == null) continue;
                cmd.add((Command)new DeleteValueCmd((EObject)symbol, node, (EStructuralFeature)node.eContainmentFeature()));
                cmdAddToDiagram.add((Command)new SetValueCmd((EObject)node, (EStructuralFeature)CarnotWorkflowModelPackage.eINSTANCE.getINodeSymbol_XPos(), (Object)new Long(node.getXPos() + symbol.getXPos())));
                cmdAddToDiagram.add((Command)new SetValueCmd((EObject)node, (EStructuralFeature)CarnotWorkflowModelPackage.eINSTANCE.getINodeSymbol_YPos(), (Object)new Long(node.getYPos() + symbol.getYPos() / 2L)));
                cmdAddToDiagram.add((Command)new SetValueCmd(symbol.eContainer(), (EStructuralFeature)node.eContainmentFeature(), (Object)node));
            }
            i = ((ISymbolContainer)symbol).getConnections().valueListIterator();
            while (i.hasNext()) {
                IConnectionSymbol connection = (IConnectionSymbol)i.next();
                if (connection.eContainmentFeature() != null) {
                    cmd.add((Command)new DeleteValueCmd((EObject)symbol, connection, (EStructuralFeature)connection.eContainmentFeature()));
                    cmd.add((Command)new SetValueCmd(symbol.eContainer(), (EStructuralFeature)connection.eContainmentFeature(), (Object)connection));
                    continue;
                }
                cmd.add((Command)UnexecutableCommand.INSTANCE);
            }
            cmd.add((Command)cmdAddToDiagram);
        }
    }

    private static void removeEventAttr(CompoundCommand cmd, String attrName, Iterator iterator) {
        Iterator iter = iterator;
        while (iter.hasNext()) {
            TransitionConnectionType transition = (TransitionConnectionType)iter.next();
            AttributeType attribute = AttributeUtil.getAttribute((IExtensibleElement)((ActivitySymbolType)(transition.getSourceActivitySymbol() instanceof ActivitySymbolType ? transition.getSourceActivitySymbol() : transition.getTargetActivitySymbol())).getModelElement(), (String)attrName);
            if (attribute == null) continue;
            cmd.add((Command)new DeleteValueCmd(attribute.eContainer(), attribute, attribute.eContainingFeature()));
        }
    }
}

