/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.editors.parts.diagram.commands;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gef.commands.Command;
import org.eclipse.stardust.model.xpdl.carnot.IGraphicalObject;
import org.eclipse.stardust.model.xpdl.carnot.ISymbolContainer;
import org.eclipse.stardust.modeling.core.Diagram_Messages;

public class OrphanSymbolCommand
extends Command {
    private ISymbolContainer symbolContainer;
    private IGraphicalObject symbol;
    private EStructuralFeature symbolContainmentFeature;
    private Long symbolElementOidBackup;

    public void setContainer(ISymbolContainer container) {
        this.symbolContainer = container;
    }

    public void setSymbolSymbol(IGraphicalObject symbol, EStructuralFeature containmentFeature) {
        this.symbol = symbol;
        this.symbolContainmentFeature = containmentFeature;
    }

    public void execute() {
        this.symbolElementOidBackup = this.symbol.isSetElementOid() ? new Long(this.symbol.getElementOid()) : null;
        this.redo();
    }

    public void redo() {
        if (this.symbol != null) {
            if (this.symbolContainer == null || this.symbolContainmentFeature == null) {
                throw new RuntimeException(String.valueOf(Diagram_Messages.EX_MissingNodeSymbolContainer) + this.symbol);
            }
            EList symbolContainment = (EList)this.symbolContainer.eGet(this.symbolContainmentFeature);
            symbolContainment.remove((Object)this.symbol);
        }
    }

    public void undo() {
        if (this.symbol != null) {
            if (this.symbolContainer == null || this.symbolContainmentFeature == null) {
                throw new RuntimeException(String.valueOf(Diagram_Messages.EX_MissingNodeSymbolContainer) + this.symbol);
            }
            EList symbolContainment = (EList)this.symbolContainer.eGet(this.symbolContainmentFeature);
            if (!this.symbol.isSetElementOid()) {
                this.symbol.unsetElementOid();
            }
            symbolContainment.add((Object)this.symbol);
        }
    }
}

