/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.editors.parts.diagram.commands;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.stardust.common.CollectionUtils;
import org.eclipse.stardust.model.xpdl.carnot.ActivitySymbolType;
import org.eclipse.stardust.model.xpdl.carnot.ActivityType;
import org.eclipse.stardust.model.xpdl.carnot.ApplicationSymbolType;
import org.eclipse.stardust.model.xpdl.carnot.ApplicationType;
import org.eclipse.stardust.model.xpdl.carnot.CarnotWorkflowModelPackage;
import org.eclipse.stardust.model.xpdl.carnot.ConditionalPerformerSymbolType;
import org.eclipse.stardust.model.xpdl.carnot.ConditionalPerformerType;
import org.eclipse.stardust.model.xpdl.carnot.DataMappingType;
import org.eclipse.stardust.model.xpdl.carnot.DataSymbolType;
import org.eclipse.stardust.model.xpdl.carnot.DataType;
import org.eclipse.stardust.model.xpdl.carnot.DiagramType;
import org.eclipse.stardust.model.xpdl.carnot.FlowControlType;
import org.eclipse.stardust.model.xpdl.carnot.GatewaySymbol;
import org.eclipse.stardust.model.xpdl.carnot.IConnectionSymbol;
import org.eclipse.stardust.model.xpdl.carnot.IExtensibleElement;
import org.eclipse.stardust.model.xpdl.carnot.IFlowObjectSymbol;
import org.eclipse.stardust.model.xpdl.carnot.IGraphicalObject;
import org.eclipse.stardust.model.xpdl.carnot.IIdentifiableModelElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelElementNodeSymbol;
import org.eclipse.stardust.model.xpdl.carnot.IModelParticipant;
import org.eclipse.stardust.model.xpdl.carnot.INodeSymbol;
import org.eclipse.stardust.model.xpdl.carnot.ISymbolContainer;
import org.eclipse.stardust.model.xpdl.carnot.JoinSplitType;
import org.eclipse.stardust.model.xpdl.carnot.LaneSymbol;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.model.xpdl.carnot.OrganizationSymbolType;
import org.eclipse.stardust.model.xpdl.carnot.OrganizationType;
import org.eclipse.stardust.model.xpdl.carnot.ParticipantType;
import org.eclipse.stardust.model.xpdl.carnot.PoolSymbol;
import org.eclipse.stardust.model.xpdl.carnot.ProcessDefinitionType;
import org.eclipse.stardust.model.xpdl.carnot.RoleSymbolType;
import org.eclipse.stardust.model.xpdl.carnot.RoleType;
import org.eclipse.stardust.model.xpdl.carnot.StartEventSymbol;
import org.eclipse.stardust.model.xpdl.carnot.TransitionConnectionType;
import org.eclipse.stardust.model.xpdl.carnot.TransitionType;
import org.eclipse.stardust.model.xpdl.carnot.TriggerType;
import org.eclipse.stardust.model.xpdl.carnot.util.ActivityUtil;
import org.eclipse.stardust.model.xpdl.carnot.util.AttributeUtil;
import org.eclipse.stardust.model.xpdl.carnot.util.DiagramUtil;
import org.eclipse.stardust.model.xpdl.carnot.util.ModelUtils;
import org.eclipse.stardust.modeling.common.ui.IdFactory;
import org.eclipse.stardust.modeling.core.Diagram_Messages;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.commands.CreateConnectionSymbolCommand;
import org.eclipse.stardust.modeling.core.ui.StringUtils;

public class ReloadConnectionCommandFactory {
    private static final CarnotWorkflowModelPackage PKG = CarnotWorkflowModelPackage.eINSTANCE;
    public static final ReloadConnectionCommandFactory INSTANCE = new ReloadConnectionCommandFactory();

    public Command createReloadConnectionCmd(INodeSymbol symbol) {
        ConditionalPerformerSymbolType conditionalPerformerSymbol;
        ConditionalPerformerType conditionalPerformer;
        RoleSymbolType roleSymbol;
        RoleType role;
        OrganizationSymbolType organizationSymbol;
        OrganizationType organization;
        ApplicationSymbolType applicationSymbol;
        ApplicationType application;
        DataSymbolType dataSymbol;
        DataType data;
        ProcessDefinitionType process;
        StartEventSymbol eventSymbol;
        TriggerType trigger;
        ActivitySymbolType activitySymbol;
        ActivityType activity;
        ActivityType activity2;
        GatewaySymbol gateway;
        ActivitySymbolType activitySymbol2;
        CompoundCommand command = new CompoundCommand();
        if (symbol instanceof GatewaySymbol && (activitySymbol2 = (gateway = (GatewaySymbol)symbol).getActivitySymbol()) != null && (activity2 = (ActivityType)activitySymbol2.getModelElement()) != null) {
            command.setLabel(String.valueOf(gateway.getFlowKind().getName()) + Diagram_Messages.LB_GatewayOfActivity + activity2.getId() + ')');
            this.reloadTransitions(command, activity2, activitySymbol2, gateway);
        }
        if (symbol instanceof ActivitySymbolType && (activity = (ActivityType)(activitySymbol = (ActivitySymbolType)symbol).getModelElement()) != null) {
            this.setCommandLabels(command, (IIdentifiableModelElement)activity, Diagram_Messages.LB_CMD_Activity);
            this.reloadTransitions(command, activity, activitySymbol, null);
            this.reloadConnections(command, (IModelElementNodeSymbol)activitySymbol, false, this.getDataSet(activity), (EStructuralFeature)PKG.getISymbolContainer_DataSymbol(), (EStructuralFeature)PKG.getISymbolContainer_ActivitySymbol(), (EStructuralFeature)PKG.getISymbolContainer_DataMappingConnection(), Diagram_Messages.CONN_NAME_DataMapping, PKG.getDataMappingConnectionType());
            if (ActivityUtil.isApplicationActivity((ActivityType)activity) && activity.getApplication() != null) {
                this.reloadConnections(command, (IModelElementNodeSymbol)activitySymbol, false, Collections.singleton(activity.getApplication()), (EStructuralFeature)PKG.getISymbolContainer_ApplicationSymbol(), (EStructuralFeature)PKG.getISymbolContainer_ActivitySymbol(), (EStructuralFeature)PKG.getISymbolContainer_ExecutedByConnection(), Diagram_Messages.CONN_NAME_ExecutedBy, PKG.getExecutedByConnectionType());
            }
            if (ActivityUtil.isInteractive((ActivityType)activity) && activity.getPerformer() != null) {
                this.reloadConnections(command, (IModelElementNodeSymbol)activitySymbol, false, Collections.singleton(activity.getPerformer()), this.getPerformerSymbolFeature(activity), (EStructuralFeature)PKG.getISymbolContainer_ActivitySymbol(), (EStructuralFeature)PKG.getISymbolContainer_PerformsConnection(), Diagram_Messages.CONN_NAME_Performs, PKG.getPerformsConnectionType());
            }
        }
        if (symbol instanceof StartEventSymbol && (trigger = (eventSymbol = (StartEventSymbol)symbol).getTrigger()) != null) {
            IModelParticipant participant;
            this.setCommandLabels(command, (IIdentifiableModelElement)trigger, Diagram_Messages.LB_CMD_Trigger);
            process = ModelUtils.findContainingProcess((EObject)eventSymbol);
            if (process != null && ((participant = this.getTriggerParticipant(trigger)) instanceof RoleType || participant instanceof OrganizationType)) {
                this.reloadConnections(command, (IModelElementNodeSymbol)eventSymbol, false, Collections.singleton(participant), (EStructuralFeature)(participant instanceof RoleType ? PKG.getISymbolContainer_RoleSymbol() : PKG.getISymbolContainer_OrganizationSymbol()), (EStructuralFeature)PKG.getISymbolContainer_StartEventSymbols(), (EStructuralFeature)PKG.getISymbolContainer_TriggersConnection(), Diagram_Messages.CONN_NAME_Triggers, PKG.getTriggersConnectionType());
            }
        }
        if (symbol instanceof DataSymbolType && (data = (DataType)(dataSymbol = (DataSymbolType)symbol).getModelElement()) != null) {
            this.setCommandLabels(command, (IIdentifiableModelElement)data, Diagram_Messages.LB_CMD_Data);
            process = ModelUtils.findContainingProcess((EObject)dataSymbol);
            if (process != null) {
                this.reloadConnections(command, (IModelElementNodeSymbol)dataSymbol, true, this.getDataActivitySet(process, data), (EStructuralFeature)PKG.getISymbolContainer_DataSymbol(), (EStructuralFeature)PKG.getISymbolContainer_ActivitySymbol(), (EStructuralFeature)PKG.getISymbolContainer_DataMappingConnection(), Diagram_Messages.CONN_NAME_DataMapping, PKG.getDataMappingConnectionType());
            }
        }
        if (symbol instanceof ApplicationSymbolType && (application = (ApplicationType)(applicationSymbol = (ApplicationSymbolType)symbol).getModelElement()) != null) {
            this.setCommandLabels(command, (IIdentifiableModelElement)application, Diagram_Messages.LB_CMD_Application);
            process = ModelUtils.findContainingProcess((EObject)applicationSymbol);
            if (process != null) {
                this.reloadConnections(command, (IModelElementNodeSymbol)applicationSymbol, true, this.getApplicationActivitySet(process, application), (EStructuralFeature)PKG.getISymbolContainer_ApplicationSymbol(), (EStructuralFeature)PKG.getISymbolContainer_ActivitySymbol(), (EStructuralFeature)PKG.getISymbolContainer_ExecutedByConnection(), Diagram_Messages.CONN_NAME_ExecutedBy, PKG.getExecutedByConnectionType());
            }
        }
        if (symbol instanceof OrganizationSymbolType && (organization = (OrganizationType)(organizationSymbol = (OrganizationSymbolType)symbol).getModelElement()) != null) {
            this.setCommandLabels(command, (IIdentifiableModelElement)organization, Diagram_Messages.LB_CMD_Organization);
            process = ModelUtils.findContainingProcess((EObject)organizationSymbol);
            if (process != null) {
                this.reloadConnections(command, (IModelElementNodeSymbol)organizationSymbol, true, this.getParticipantActivitySet(process, (IModelParticipant)organization), (EStructuralFeature)PKG.getISymbolContainer_OrganizationSymbol(), (EStructuralFeature)PKG.getISymbolContainer_ActivitySymbol(), (EStructuralFeature)PKG.getISymbolContainer_PerformsConnection(), Diagram_Messages.CONN_NAME_Performs, PKG.getPerformsConnectionType());
                this.reloadConnections(command, (IModelElementNodeSymbol)organizationSymbol, true, this.getParticipantTriggerSet(process, (IModelParticipant)organization), (EStructuralFeature)PKG.getISymbolContainer_OrganizationSymbol(), (EStructuralFeature)PKG.getISymbolContainer_StartEventSymbols(), (EStructuralFeature)PKG.getISymbolContainer_TriggersConnection(), Diagram_Messages.CONN_NAME_Triggers, PKG.getTriggersConnectionType());
            }
            Set<IModelParticipant> members = this.getOrganizationMemberSet(organization);
            this.reloadConnections(command, (IModelElementNodeSymbol)organizationSymbol, false, members, (EStructuralFeature)PKG.getISymbolContainer_RoleSymbol(), (EStructuralFeature)PKG.getISymbolContainer_OrganizationSymbol(), (EStructuralFeature)PKG.getISymbolContainer_WorksForConnection(), Diagram_Messages.CONN_NAME_WorksFor, PKG.getWorksForConnectionType());
            if (organization.getTeamLead() != null) {
                this.reloadConnections(command, (IModelElementNodeSymbol)organizationSymbol, false, Collections.singleton(organization.getTeamLead()), (EStructuralFeature)PKG.getISymbolContainer_RoleSymbol(), (EStructuralFeature)PKG.getISymbolContainer_OrganizationSymbol(), (EStructuralFeature)PKG.getISymbolContainer_TeamLeadConnection(), Diagram_Messages.CONN_NAME_TeamLead, PKG.getTeamLeadConnectionType());
            }
            this.reloadConnections(command, (IModelElementNodeSymbol)organizationSymbol, false, members, (EStructuralFeature)PKG.getISymbolContainer_OrganizationSymbol(), (EStructuralFeature)PKG.getISymbolContainer_OrganizationSymbol(), (EStructuralFeature)PKG.getISymbolContainer_PartOfConnection(), Diagram_Messages.CONN_NAME_PartOf, PKG.getPartOfConnectionType());
            ModelType modelType = ModelUtils.findContainingModel((EObject)organizationSymbol);
            if (modelType != null) {
                this.reloadConnections(command, (IModelElementNodeSymbol)organizationSymbol, true, this.getParentOrganizationSet(modelType, (IModelParticipant)organization), (EStructuralFeature)PKG.getISymbolContainer_OrganizationSymbol(), (EStructuralFeature)PKG.getISymbolContainer_OrganizationSymbol(), (EStructuralFeature)PKG.getISymbolContainer_PartOfConnection(), Diagram_Messages.CONN_NAME_PartOf, PKG.getPartOfConnectionType());
            }
        }
        if (symbol instanceof RoleSymbolType && (role = (RoleType)(roleSymbol = (RoleSymbolType)symbol).getModelElement()) != null) {
            ModelType modelType;
            this.setCommandLabels(command, (IIdentifiableModelElement)role, Diagram_Messages.LB_CMD_Role);
            process = ModelUtils.findContainingProcess((EObject)roleSymbol);
            if (process != null) {
                this.reloadConnections(command, (IModelElementNodeSymbol)roleSymbol, true, this.getParticipantActivitySet(process, (IModelParticipant)role), (EStructuralFeature)PKG.getISymbolContainer_RoleSymbol(), (EStructuralFeature)PKG.getISymbolContainer_ActivitySymbol(), (EStructuralFeature)PKG.getISymbolContainer_PerformsConnection(), Diagram_Messages.CONN_NAME_Performs, PKG.getPerformsConnectionType());
                this.reloadConnections(command, (IModelElementNodeSymbol)roleSymbol, true, this.getParticipantTriggerSet(process, (IModelParticipant)role), (EStructuralFeature)PKG.getISymbolContainer_RoleSymbol(), (EStructuralFeature)PKG.getISymbolContainer_StartEventSymbols(), (EStructuralFeature)PKG.getISymbolContainer_TriggersConnection(), Diagram_Messages.CONN_NAME_Triggers, PKG.getTriggersConnectionType());
            }
            if ((modelType = ModelUtils.findContainingModel((EObject)roleSymbol)) != null) {
                this.reloadConnections(command, (IModelElementNodeSymbol)roleSymbol, true, this.getParentOrganizationSet(modelType, (IModelParticipant)role), (EStructuralFeature)PKG.getISymbolContainer_RoleSymbol(), (EStructuralFeature)PKG.getISymbolContainer_OrganizationSymbol(), (EStructuralFeature)PKG.getISymbolContainer_WorksForConnection(), Diagram_Messages.CONN_NAME_WorksFor, PKG.getWorksForConnectionType());
                this.reloadConnections(command, (IModelElementNodeSymbol)roleSymbol, true, new HashSet(role.getTeams()), (EStructuralFeature)PKG.getISymbolContainer_RoleSymbol(), (EStructuralFeature)PKG.getISymbolContainer_OrganizationSymbol(), (EStructuralFeature)PKG.getISymbolContainer_TeamLeadConnection(), Diagram_Messages.CONN_NAME_TeamLead, PKG.getTeamLeadConnectionType());
            }
        }
        if (symbol instanceof ConditionalPerformerSymbolType && (conditionalPerformer = (ConditionalPerformerType)(conditionalPerformerSymbol = (ConditionalPerformerSymbolType)symbol).getModelElement()) != null) {
            this.setCommandLabels(command, (IIdentifiableModelElement)conditionalPerformer, Diagram_Messages.LB_CMD_ConditionalPerformer);
            process = ModelUtils.findContainingProcess((EObject)conditionalPerformerSymbol);
            if (process != null) {
                this.reloadConnections(command, (IModelElementNodeSymbol)conditionalPerformerSymbol, true, this.getParticipantActivitySet(process, (IModelParticipant)conditionalPerformer), (EStructuralFeature)PKG.getISymbolContainer_ConditionalPerformerSymbol(), (EStructuralFeature)PKG.getISymbolContainer_ActivitySymbol(), (EStructuralFeature)PKG.getISymbolContainer_PerformsConnection(), Diagram_Messages.CONN_NAME_Performs, PKG.getPerformsConnectionType());
            }
        }
        return command;
    }

    private Set<TriggerType> getParticipantTriggerSet(ProcessDefinitionType process, IModelParticipant participant) {
        Set participants = CollectionUtils.newSet();
        for (TriggerType trigger : process.getTrigger()) {
            String triggerTypeId = trigger.getType().getId();
            if (!"manual".equals(triggerTypeId) && !"scan".equals(triggerTypeId) || participant != AttributeUtil.getIdentifiable((IExtensibleElement)trigger, (String)"carnot:engine:participant")) continue;
            participants.add(trigger);
        }
        return participants;
    }

    private IModelParticipant getTriggerParticipant(TriggerType trigger) {
        String triggerTypeId = trigger.getType().getId();
        if ("manual".equals(triggerTypeId) || "scan".equals(triggerTypeId)) {
            return (IModelParticipant)AttributeUtil.getIdentifiable((IExtensibleElement)trigger, (String)"carnot:engine:participant");
        }
        return null;
    }

    public Command createReloadConnectionCmd(List<INodeSymbol> symbols) {
        CompoundCommand command = new CompoundCommand();
        for (INodeSymbol symbol : symbols) {
            command.add(this.createReloadConnectionCmd(symbol));
        }
        return command;
    }

    private void setCommandLabels(CompoundCommand command, IIdentifiableModelElement identifiable, String label) {
        command.setLabel(StringUtils.isEmpty(identifiable.getName()) ? String.valueOf(label) + ": " + identifiable.getElementOid() : String.valueOf(identifiable.getName()) + " (" + identifiable.getId() + ')');
    }

    private Set<IModelParticipant> getOrganizationMemberSet(OrganizationType organization) {
        Set set = CollectionUtils.newSet();
        for (ParticipantType participant : organization.getParticipant()) {
            set.add(participant.getParticipant());
        }
        return set;
    }

    private Set<OrganizationType> getParentOrganizationSet(ModelType modelType, IModelParticipant role) {
        Set set = CollectionUtils.newSet();
        for (OrganizationType organization : modelType.getOrganization()) {
            for (ParticipantType participant : organization.getParticipant()) {
                if (!role.equals(participant.getParticipant())) continue;
                set.add(organization);
            }
        }
        return set;
    }

    private EStructuralFeature getPerformerSymbolFeature(ActivityType activity) {
        IModelParticipant performer = activity.getPerformer();
        if (performer instanceof ConditionalPerformerType) {
            return PKG.getISymbolContainer_ConditionalPerformerSymbol();
        }
        if (performer instanceof OrganizationType) {
            return PKG.getISymbolContainer_OrganizationSymbol();
        }
        if (performer instanceof RoleType) {
            return PKG.getISymbolContainer_RoleSymbol();
        }
        return null;
    }

    private void reloadConnections(CompoundCommand command, IModelElementNodeSymbol symbol, boolean outgoing, Set<? extends IIdentifiableModelElement> set, EStructuralFeature sourceFeature, EStructuralFeature targetFeature, EStructuralFeature connectionFeature, String name, EClass connectionEClass) {
        DiagramType diagram = ModelUtils.findContainingDiagram((IGraphicalObject)symbol);
        EObject parentContainer = symbol.eContainer();
        Object symbolContainer = (ISymbolContainer)parentContainer;
        if (parentContainer != null && parentContainer instanceof LaneSymbol) {
            PoolSymbol poolSymbol = DiagramUtil.getDefaultPool((DiagramType)diagram);
            symbolContainer = poolSymbol != null ? poolSymbol : diagram;
        }
        if (symbolContainer != null) {
            for (IIdentifiableModelElement iIdentifiableModelElement : set) {
                IModelElementNodeSymbol sourceSymbol = null;
                IModelElementNodeSymbol targetSymbol = null;
                if (outgoing) {
                    sourceSymbol = symbol;
                    targetSymbol = (IModelElementNodeSymbol)DiagramUtil.getClosestSymbol((INodeSymbol)symbol, (EStructuralFeature)targetFeature, (IModelElement)iIdentifiableModelElement);
                } else {
                    targetSymbol = symbol;
                    sourceSymbol = (IModelElementNodeSymbol)DiagramUtil.getClosestSymbol((INodeSymbol)symbol, (EStructuralFeature)sourceFeature, (IModelElement)iIdentifiableModelElement);
                }
                if (targetSymbol == null || sourceSymbol == null) continue;
                boolean found = false;
                List connection = (List)symbolContainer.eGet(connectionFeature);
                for (IConnectionSymbol type : connection) {
                    if (!targetSymbol.equals(type.getTargetNode()) || !sourceSymbol.equals(type.getSourceNode())) continue;
                    found = true;
                    break;
                }
                if (found || sourceSymbol.equals(targetSymbol)) continue;
                IdFactory idFactory = new IdFactory(name, name, String.valueOf(Long.toString(sourceSymbol.getElementOid())) + ":" + Long.toString(targetSymbol.getElementOid()));
                CreateConnectionSymbolCommand cmd = new CreateConnectionSymbolCommand(idFactory, connectionEClass);
                cmd.setParent((EObject)symbolContainer);
                cmd.setSourceSymbol((INodeSymbol)sourceSymbol);
                cmd.setTargetSymbol((INodeSymbol)targetSymbol);
                cmd.setLabel(String.valueOf(name) + Diagram_Messages.LB_CMD_P1_OfSource + sourceSymbol.getModelElement().getId() + Diagram_Messages.LB_CMD_P2_Target + targetSymbol.getModelElement().getId() + ')');
                command.add((Command)cmd);
            }
        }
    }

    private Set<ActivityType> getParticipantActivitySet(ProcessDefinitionType process, IModelParticipant participant) {
        Set activitySet = CollectionUtils.newSet();
        for (ActivityType activity : process.getActivity()) {
            if (!ActivityUtil.isInteractive((ActivityType)activity) || !participant.equals(activity.getPerformer())) continue;
            activitySet.add(activity);
        }
        return activitySet;
    }

    private Set<ActivityType> getApplicationActivitySet(ProcessDefinitionType process, ApplicationType application) {
        Set activitySet = CollectionUtils.newSet();
        for (ActivityType activity : process.getActivity()) {
            if (!ActivityUtil.isApplicationActivity((ActivityType)activity) || !application.equals(activity.getApplication())) continue;
            activitySet.add(activity);
        }
        return activitySet;
    }

    private Set<DataType> getDataSet(ActivityType activity) {
        Set dataSet = CollectionUtils.newSet();
        for (DataMappingType dataMapping : activity.getDataMapping()) {
            if (dataMapping.getData() == null) continue;
            dataSet.add(dataMapping.getData());
        }
        return dataSet;
    }

    private Set<ActivityType> getDataActivitySet(ProcessDefinitionType process, DataType data) {
        Set activitySet = CollectionUtils.newSet();
        block0: for (ActivityType activity : process.getActivity()) {
            for (DataMappingType dataMapping : activity.getDataMapping()) {
                if (!data.equals(dataMapping.getData())) continue;
                activitySet.add(activity);
                continue block0;
            }
        }
        return activitySet;
    }

    private void reloadTransitions(CompoundCommand command, ActivityType activity, ActivitySymbolType activitySymbol, GatewaySymbol gatewaySymbol) {
        if (gatewaySymbol != null) {
            this.reloadGatewayTransition(command, activitySymbol, gatewaySymbol);
        } else {
            GatewaySymbol gateway;
            if (activity.getSplit() != null && activity.getSplit().getValue() != 0) {
                gateway = this.findGateway(activitySymbol, FlowControlType.SPLIT_LITERAL);
                this.reloadGatewayTransition(command, activitySymbol, gateway);
            }
            if (activity.getJoin() != null && activity.getJoin().getValue() != 0) {
                gateway = this.findGateway(activitySymbol, FlowControlType.JOIN_LITERAL);
                this.reloadGatewayTransition(command, activitySymbol, gateway);
            }
        }
        ProcessDefinitionType process = (ProcessDefinitionType)activity.eContainer();
        if (process == null) {
            return;
        }
        for (TransitionType transition : process.getTransition()) {
            boolean found = false;
            EList connections = null;
            ActivityType sourceActivity = null;
            ActivityType targetActivity = null;
            IFlowObjectSymbol sourceSymbol = null;
            IFlowObjectSymbol targetSymbol = null;
            if (transition.getFrom() != null && transition.getFrom().equals(activity)) {
                sourceActivity = activity;
                sourceSymbol = this.getFlowSymbol(sourceActivity, activitySymbol, true);
                if (sourceSymbol == null || gatewaySymbol != null && gatewaySymbol != sourceSymbol) continue;
                connections = sourceSymbol.getOutTransitions();
            } else {
                if (transition.getTo() == null || !transition.getTo().equals(activity) || (targetSymbol = this.getFlowSymbol(targetActivity = activity, activitySymbol, false)) == null || gatewaySymbol != null && gatewaySymbol != targetSymbol) continue;
                connections = targetSymbol.getInTransitions();
            }
            if (connections != null) {
                for (TransitionConnectionType connection : connections) {
                    if (!transition.equals(connection.getTransition())) continue;
                    found = true;
                    break;
                }
            }
            if (found) continue;
            if (sourceActivity == null) {
                sourceActivity = transition.getFrom();
            }
            if (targetActivity == null) {
                targetActivity = transition.getTo();
            }
            if (sourceSymbol == null) {
                sourceSymbol = this.findClosestFlowObject(targetSymbol, sourceActivity, true);
            }
            if (targetSymbol == null) {
                targetSymbol = this.findClosestFlowObject(sourceSymbol, targetActivity, false);
            }
            if (sourceSymbol == null || targetSymbol == null || sourceSymbol.equals(targetSymbol)) continue;
            IdFactory id = new IdFactory("TransitionConnection", Diagram_Messages.BASENAME_TransitionConnection, (IIdentifiableModelElement)transition);
            DiagramType diagram = ModelUtils.findContainingDiagram((IGraphicalObject)sourceSymbol);
            CreateConnectionSymbolCommand cmd = new CreateConnectionSymbolCommand(id, CarnotWorkflowModelPackage.eINSTANCE.getTransitionConnectionType()){

                @Override
                protected IModelElement createModelElement() {
                    TransitionConnectionType connection = (TransitionConnectionType)super.createModelElement();
                    connection.setTransition((TransitionType)this.getIdFactory().getReferingElement());
                    return connection;
                }
            };
            cmd.setParent((EObject)diagram);
            cmd.setSourceSymbol((INodeSymbol)sourceSymbol);
            cmd.setTargetSymbol((INodeSymbol)targetSymbol);
            cmd.setLabel(String.valueOf(Diagram_Messages.LB_CMD_TransitionOfSource) + sourceActivity.getId() + Diagram_Messages.LB_CMD_P2_Target + targetActivity.getId() + ')');
            command.add((Command)cmd);
        }
    }

    private void reloadGatewayTransition(CompoundCommand command, ActivitySymbolType activitySymbol, GatewaySymbol gatewaySymbol) {
        if (activitySymbol != null && gatewaySymbol != null) {
            boolean outgoing = gatewaySymbol.getFlowKind() == FlowControlType.SPLIT_LITERAL;
            boolean found = false;
            for (TransitionConnectionType connection : outgoing ? gatewaySymbol.getInTransitions() : gatewaySymbol.getOutTransitions()) {
                IFlowObjectSymbol other;
                IFlowObjectSymbol iFlowObjectSymbol = other = outgoing ? connection.getSourceActivitySymbol() : connection.getTargetActivitySymbol();
                if (activitySymbol != other) continue;
                found = true;
                break;
            }
            if (!found) {
                IdFactory id = new IdFactory("TransitionConnection", Diagram_Messages.BASENAME_TransitionConnection);
                DiagramType diagram = ModelUtils.findContainingDiagram((IGraphicalObject)activitySymbol);
                CreateConnectionSymbolCommand cmd = new CreateConnectionSymbolCommand(id, CarnotWorkflowModelPackage.eINSTANCE.getTransitionConnectionType());
                cmd.setParent((EObject)diagram);
                cmd.setSourceAnchorType("center");
                cmd.setTargetAnchorType("center");
                cmd.setSourceSymbol((INodeSymbol)(outgoing ? activitySymbol : gatewaySymbol));
                cmd.setTargetSymbol((INodeSymbol)(outgoing ? gatewaySymbol : activitySymbol));
                cmd.setLabel(String.valueOf(Diagram_Messages.LB_CMD_GatewayConnectionOf) + Diagram_Messages.LB_CMD_P1_source + cmd.getSourceSymbol().getElementOid() + ", " + Diagram_Messages.LB_CMD_P2_target + cmd.getTargetSymbol().getElementOid() + ')');
                command.add((Command)cmd);
            }
        }
    }

    private IFlowObjectSymbol findClosestFlowObject(IFlowObjectSymbol reference, ActivityType activity, boolean outgoing) {
        ActivitySymbolType target = (ActivitySymbolType)DiagramUtil.getClosestSymbol((INodeSymbol)reference, (EStructuralFeature)CarnotWorkflowModelPackage.eINSTANCE.getISymbolContainer_ActivitySymbol(), (IModelElement)activity);
        return this.getFlowSymbol(activity, target, outgoing);
    }

    private IFlowObjectSymbol getFlowSymbol(ActivityType activity, ActivitySymbolType symbol, boolean outgoing) {
        GatewaySymbol gateway = null;
        if (symbol != null) {
            if (outgoing) {
                if (activity.getSplit() != JoinSplitType.NONE_LITERAL) {
                    gateway = this.findGateway(symbol, FlowControlType.SPLIT_LITERAL);
                }
            } else if (activity.getJoin() != JoinSplitType.NONE_LITERAL) {
                gateway = this.findGateway(symbol, FlowControlType.JOIN_LITERAL);
            }
        }
        return gateway == null ? symbol : gateway;
    }

    private GatewaySymbol findGateway(ActivitySymbolType target, FlowControlType flow) {
        DiagramType diagram = ModelUtils.findContainingDiagram((IGraphicalObject)target);
        if (diagram != null) {
            List gateways = DiagramUtil.getSymbols((ISymbolContainer)diagram, (EStructuralFeature)CarnotWorkflowModelPackage.eINSTANCE.getISymbolContainer_GatewaySymbol(), null);
            for (GatewaySymbol gateway : gateways) {
                if (!flow.equals((Object)gateway.getFlowKind()) || gateway.getActivitySymbol() == null || !gateway.getActivitySymbol().equals(target)) continue;
                return gateway;
            }
        }
        return null;
    }
}

