/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.editors.parts.diagram.policies;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.AbsoluteBendpoint;
import org.eclipse.draw2d.Bendpoint;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.Viewport;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.SnapToHelper;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gef.editparts.ScalableFreeformRootEditPart;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.gef.editpolicies.BendpointEditPolicy;
import org.eclipse.gef.handles.BendpointCreationHandle;
import org.eclipse.gef.handles.BendpointHandle;
import org.eclipse.gef.requests.BendpointRequest;
import org.eclipse.stardust.modeling.core.editors.figures.BendpointSelectionMoveHandle;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.AbstractConnectionSymbolEditPart;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.commands.ConnectionBendpointsCommand;

public class ConnectionBendpointEditPolicy
extends BendpointEditPolicy {
    int handleSize = 0;
    private List bendpointHandles = new ArrayList();

    protected Command getCreateBendpointCommand(BendpointRequest request) {
        this.handleSize = this.handleSize == 0 ? this.handles.size() : this.handleSize;
        Object result = UnexecutableCommand.INSTANCE;
        if (request.getSource() instanceof AbstractConnectionSymbolEditPart) {
            AbstractConnectionSymbolEditPart connection = (AbstractConnectionSymbolEditPart)request.getSource();
            if (this.handleSize + 1 < this.handles.size()) {
                this.bendpointHandles.add(request.getIndex(), new BendpointSelectionMoveHandle((ConnectionEditPart)this.getHost(), request.getIndex(), request.getIndex() + 1));
            }
            if (this.handleSize < this.handles.size()) {
                ++this.handleSize;
            }
            result = ConnectionBendpointsCommand.insertBendpoint(connection.getConnectionSymbolModel(), this.computeLocation(request), request.getIndex());
        }
        return result;
    }

    protected Command getDeleteBendpointCommand(BendpointRequest request) {
        Object result = UnexecutableCommand.INSTANCE;
        if (request.getSource() instanceof AbstractConnectionSymbolEditPart) {
            AbstractConnectionSymbolEditPart connection = (AbstractConnectionSymbolEditPart)request.getSource();
            result = ConnectionBendpointsCommand.removeBendpoint(connection.getConnectionSymbolModel(), request.getIndex());
            if (request.getIndex() < this.bendpointHandles.size()) {
                this.bendpointHandles.remove(request.getIndex());
                --this.handleSize;
            }
        }
        return result;
    }

    protected Command getMoveBendpointCommand(BendpointRequest request) {
        Object result = UnexecutableCommand.INSTANCE;
        if (request.getSource() instanceof AbstractConnectionSymbolEditPart) {
            AbstractConnectionSymbolEditPart connection = (AbstractConnectionSymbolEditPart)request.getSource();
            result = ConnectionBendpointsCommand.moveBendpoint(connection.getConnectionSymbolModel(), this.computeLocation(request), request.getIndex());
        }
        return result;
    }

    private Point computeLocation(BendpointRequest request) {
        Point location = request.getLocation().getCopy();
        if (!(request instanceof DummyBendpointRequest)) {
            ScalableFreeformRootEditPart root = (ScalableFreeformRootEditPart)request.getSource().getRoot();
            ZoomManager manager = root.getZoomManager();
            Viewport viewport = (Viewport)root.getFigure();
            Point view = viewport.getViewLocation();
            if (!this.isSelected(request)) {
                location.performTranslate(view.x, view.y);
            }
            location.performScale(1.0 / manager.getZoom());
        }
        return location;
    }

    private boolean isSelected(BendpointRequest request) {
        int bendPointIndex = request.getIndex();
        BendpointSelectionMoveHandle mvHandle = this.bendpointHandles.size() > bendPointIndex ? (BendpointSelectionMoveHandle)((Object)this.bendpointHandles.get(bendPointIndex)) : null;
        return mvHandle != null ? mvHandle.isSelected() : false;
    }

    private void snapLocation(BendpointRequest request) {
        Point location = request.getLocation();
        RootEditPart root = request.getSource().getRoot();
        SnapToHelper snapToHelper = (SnapToHelper)root.getContents().getAdapter(SnapToHelper.class);
        if (snapToHelper != null) {
            PrecisionPoint preciseLocation = new PrecisionPoint(location);
            PrecisionPoint preciseDelta = new PrecisionPoint(0, 0);
            snapToHelper.snapPoint((Request)request, 192, preciseLocation, preciseDelta);
            location.performTranslate(preciseDelta.x, preciseDelta.y);
        }
    }

    public void showSourceFeedback(Request request) {
        if (request instanceof BendpointRequest) {
            this.snapLocation((BendpointRequest)request);
        }
        if ("move bendpoint".equals(request.getType())) {
            if (request instanceof BendpointRequest && this.isSelected((BendpointRequest)request)) {
                this.showMyMoveBendpointFeedback((BendpointRequest)request);
                return;
            }
            this.showMoveBendpointFeedback((BendpointRequest)request);
        } else if ("create bendpoint".equals(request.getType())) {
            this.showCreateBendpointFeedback((BendpointRequest)request);
        }
    }

    protected void showMyMoveBendpointFeedback(BendpointRequest request) {
        ScalableFreeformRootEditPart root = (ScalableFreeformRootEditPart)request.getSource().getRoot();
        ZoomManager manager = root.getZoomManager();
        Point p = new Point(request.getLocation());
        p.performScale(1.0 / manager.getZoom());
        List constraint = (List)this.getConnection().getRoutingConstraint();
        AbsoluteBendpoint bp = new AbsoluteBendpoint(p);
        constraint.set(request.getIndex(), bp);
        this.getConnection().setRoutingConstraint((Object)constraint);
    }

    public void unSelectBendpoints() {
        List bendPoints;
        Connection connection = this.getConnection();
        if (connection != null && (bendPoints = (List)connection.getRoutingConstraint()) != null) {
            int i = 0;
            while (i <= bendPoints.size()) {
                if (this.bendpointHandles.size() >= i + 1) {
                    BendpointSelectionMoveHandle mvHandle = (BendpointSelectionMoveHandle)((Object)this.bendpointHandles.get(i));
                    mvHandle.setSelected(false);
                }
                ++i;
            }
        }
    }

    private List createHandlesForUserBendpoints() {
        ArrayList<Object> list = new ArrayList<Object>();
        ConnectionEditPart connEP = (ConnectionEditPart)this.getHost();
        PointList points = this.getConnection().getPoints();
        ArrayList bendPoints = (ArrayList)this.getConnection().getRoutingConstraint();
        int bendPointIndex = 0;
        Point currBendPoint = null;
        if (bendPoints == null) {
            bendPoints = new ArrayList();
        }
        if (!bendPoints.isEmpty()) {
            currBendPoint = ((Bendpoint)bendPoints.get(bendPointIndex)).getLocation();
        }
        int i = 0;
        while (i < points.size() - 1) {
            list.add(new BendpointCreationHandle(connEP, bendPointIndex, i));
            if (bendPointIndex < bendPoints.size() && currBendPoint.equals((Object)points.getPoint(i + 1))) {
                BendpointSelectionMoveHandle mvHandle = new BendpointSelectionMoveHandle(connEP, bendPointIndex, i + 1);
                list.add((Object)mvHandle);
                boolean isSelected = false;
                BendpointSelectionMoveHandle oldMvHandle = this.bendpointHandles.size() > bendPointIndex ? (BendpointSelectionMoveHandle)((Object)this.bendpointHandles.get(bendPointIndex)) : null;
                isSelected = oldMvHandle != null ? oldMvHandle.isSelected() : false;
                mvHandle.setSelected(isSelected);
                if (bendPointIndex < this.bendpointHandles.size()) {
                    this.bendpointHandles.set(bendPointIndex, mvHandle);
                } else {
                    this.bendpointHandles.add(mvHandle);
                }
                if (++bendPointIndex < bendPoints.size()) {
                    currBendPoint = ((Bendpoint)bendPoints.get(bendPointIndex)).getLocation();
                }
            }
            ++i;
        }
        return list;
    }

    protected void addSelectionHandles() {
        super.addSelectionHandles();
        List selectedHandles = this.getSelectedHandles();
        for (BendpointHandle handle : this.handles) {
            if (!(handle instanceof BendpointSelectionMoveHandle)) continue;
            ((BendpointSelectionMoveHandle)handle).setSelectedHandles(selectedHandles);
        }
    }

    private List getSelectedHandles() {
        ArrayList<BendpointHandle> selectedHandles = new ArrayList<BendpointHandle>();
        for (BendpointHandle handle : this.handles) {
            if (!(handle instanceof BendpointSelectionMoveHandle) || !((BendpointSelectionMoveHandle)handle).isSelected()) continue;
            selectedHandles.add(handle);
        }
        return selectedHandles;
    }

    protected List createSelectionHandles() {
        List list = new ArrayList();
        list = this.isAutomaticallyBending() ? this.createHandlesForAutomaticBendpoints() : this.createHandlesForUserBendpoints();
        return list;
    }

    private boolean isAutomaticallyBending() {
        List constraint = (List)this.getConnection().getRoutingConstraint();
        return constraint == null || constraint.isEmpty();
    }

    private List createHandlesForAutomaticBendpoints() {
        ArrayList<BendpointCreationHandle> list = new ArrayList<BendpointCreationHandle>();
        ConnectionEditPart connEP = (ConnectionEditPart)this.getHost();
        PointList points = this.getConnection().getPoints();
        int i = 0;
        while (i < points.size() - 1) {
            list.add(new BendpointCreationHandle(connEP, 0, i));
            ++i;
        }
        return list;
    }

    public static class DummyBendpointRequest
    extends BendpointRequest {
    }
}

