/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.editors.parts.diagram.policies;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.requests.BendpointRequest;
import org.eclipse.gef.tools.ConnectionBendpointTracker;
import org.eclipse.stardust.modeling.core.editors.figures.BendpointSelectionMoveHandle;

public class DiagramConnectionBendpointTracker
extends ConnectionBendpointTracker {
    private List sourceRequests;
    private ArrayList locations;
    private final List selectedBendpoints;
    protected final BendpointSelectionMoveHandle handle;

    public DiagramConnectionBendpointTracker(ConnectionEditPart editpart, List selectedHandles, BendpointSelectionMoveHandle handle) {
        this.selectedBendpoints = selectedHandles;
        this.handle = handle;
        this.setConnectionEditPart(editpart);
        this.setIndex(handle.getIndex());
    }

    protected Command getCommand() {
        CompoundCommand command = new CompoundCommand();
        if (this.selectedBendpoints.size() == 0) {
            command.add(this.getConnectionEditPart().getCommand(super.getSourceRequest()));
        } else {
            for (Request request : this.getSourceRequests()) {
                command.add(this.getConnectionEditPart().getCommand(request));
            }
        }
        return command;
    }

    protected List getSourceRequests() {
        if (this.sourceRequests == null) {
            this.sourceRequests = this.createSourceRequests();
        }
        return this.sourceRequests;
    }

    protected List createSourceRequests() {
        this.sourceRequests = new ArrayList();
        this.locations = new ArrayList();
        for (BendpointSelectionMoveHandle bendpointHandle : this.selectedBendpoints) {
            int index = bendpointHandle.getIndex();
            BendpointRequest request = new BendpointRequest();
            request.setType(this.getType());
            request.setIndex(index);
            request.setSource(this.getConnectionEditPart());
            this.locations.add(bendpointHandle.getLocation());
            this.sourceRequests.add(request);
        }
        return this.sourceRequests;
    }

    protected void showSourceFeedback() {
        if (this.selectedBendpoints.size() == 0) {
            super.showSourceFeedback();
        } else {
            List editParts = this.getOperationSet();
            int i = 0;
            while (i < editParts.size()) {
                EditPart editPart = (EditPart)editParts.get(i);
                for (Request request : this.getSourceRequests()) {
                    editPart.showSourceFeedback(request);
                }
                ++i;
            }
            this.setFlag(16, true);
        }
    }

    protected void eraseSourceFeedback() {
        if (!this.isShowingFeedback()) {
            return;
        }
        if (this.selectedBendpoints.size() == 0) {
            super.eraseSourceFeedback();
        } else {
            this.setFlag(16, false);
            List editParts = this.getOperationSet();
            int i = 0;
            while (i < editParts.size()) {
                EditPart editPart = (EditPart)editParts.get(i);
                for (Request request : this.getSourceRequests()) {
                    editPart.eraseSourceFeedback(request);
                }
                ++i;
            }
        }
    }

    protected void updateSourceRequest() {
        if (this.selectedBendpoints.size() == 0) {
            super.updateSourceRequest();
        } else {
            int i = 0;
            while (i < this.getSourceRequests().size()) {
                BendpointRequest bendpointRequest = (BendpointRequest)this.getSourceRequests().get(i);
                Point newLocation = new Point(((Point)this.locations.get((int)i)).x + this.getDragMoveDelta().width, ((Point)this.locations.get((int)i)).y + this.getDragMoveDelta().height);
                bendpointRequest.setLocation(newLocation);
                ++i;
            }
        }
    }
}

