/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.editors.parts.properties;

import org.eclipse.gef.commands.Command;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.IPropertySource2;

class ResetValueCommand
extends Command {
    protected Object propertyName;
    protected Object undoValue;
    protected IPropertySource target;

    public ResetValueCommand() {
        super("Restore Default Value");
    }

    public boolean canExecute() {
        boolean answer = false;
        if (this.target != null && this.propertyName != null) {
            answer = this.target.isPropertySet(this.propertyName);
            if (this.target instanceof IPropertySource2) {
                answer = answer && ((IPropertySource2)this.target).isPropertyResettable(this.propertyName);
            }
        }
        return answer;
    }

    public void execute() {
        this.undoValue = this.target.getPropertyValue(this.propertyName);
        if (this.undoValue instanceof IPropertySource) {
            this.undoValue = ((IPropertySource)this.undoValue).getEditableValue();
        }
        this.redo();
    }

    public void setTarget(IPropertySource propSource) {
        this.target = propSource;
    }

    public void redo() {
        this.target.resetPropertyValue(this.propertyName);
    }

    public void setPropertyId(Object pName) {
        this.propertyName = pName;
    }

    public void undo() {
        this.target.setPropertyValue(this.propertyName, this.undoValue);
    }
}

