/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.editors.parts.properties;

import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.stardust.modeling.core.Diagram_Messages;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;

public class SymbolWithModelPropertySource
implements IPropertySource {
    private final IPropertySource symbolPropertySource;
    private final IPropertySource modelPropertySource;

    public SymbolWithModelPropertySource(IPropertySource modelPropertySource, IPropertySource symbolPropertySource) {
        this.modelPropertySource = modelPropertySource;
        this.symbolPropertySource = symbolPropertySource;
    }

    public Object getEditableValue() {
        return this.symbolPropertySource.getEditableValue();
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        IPropertyDescriptor[] symbolProperties = this.symbolPropertySource.getPropertyDescriptors();
        IPropertyDescriptor[] modelProperties = this.modelPropertySource.getPropertyDescriptors();
        IPropertyDescriptor[] result = new IPropertyDescriptor[symbolProperties.length + modelProperties.length];
        int i = 0;
        while (i < symbolProperties.length) {
            result[i] = new AnnotatedPropertyDescriptor(this.symbolPropertySource, symbolProperties[i]);
            ++i;
        }
        i = 0;
        while (i < modelProperties.length) {
            result[symbolProperties.length + i] = new AnnotatedPropertyDescriptor(this.modelPropertySource, modelProperties[i]);
            ++i;
        }
        return result;
    }

    public Object getPropertyValue(Object id) {
        Object value = null;
        if (id instanceof PropertyIdWithSource) {
            PropertyIdWithSource idWithSource = (PropertyIdWithSource)id;
            value = idWithSource.source.getPropertyValue(idWithSource.id);
        } else {
            System.err.println(String.valueOf(Diagram_Messages.ERR_UnsupportedPropertyId) + id);
        }
        return value;
    }

    public boolean isPropertySet(Object id) {
        boolean isSet = false;
        if (id instanceof PropertyIdWithSource) {
            PropertyIdWithSource idWithSource = (PropertyIdWithSource)id;
            isSet = idWithSource.source.isPropertySet(idWithSource.id);
        } else {
            System.err.println(String.valueOf(Diagram_Messages.ERR_UnsupportedPropertyId) + id);
        }
        return isSet;
    }

    public void resetPropertyValue(Object id) {
        if (id instanceof PropertyIdWithSource) {
            PropertyIdWithSource idWithSource = (PropertyIdWithSource)id;
            idWithSource.source.resetPropertyValue(idWithSource.id);
        } else {
            System.err.println(String.valueOf(Diagram_Messages.ERR_UnsupportedPropertyId) + id);
        }
    }

    public void setPropertyValue(Object id, Object value) {
        if (id instanceof PropertyIdWithSource) {
            PropertyIdWithSource idWithSource = (PropertyIdWithSource)id;
            idWithSource.source.setPropertyValue(idWithSource.id, value);
        } else {
            System.err.println(String.valueOf(Diagram_Messages.ERR_UnsupportedPropertyId) + id);
        }
    }

    private static class AnnotatedPropertyDescriptor
    implements IPropertyDescriptor {
        private final IPropertySource propSource;
        private final IPropertyDescriptor propDescriptor;

        AnnotatedPropertyDescriptor(IPropertySource source, IPropertyDescriptor descriptor) {
            this.propSource = source;
            this.propDescriptor = descriptor;
        }

        public Object getId() {
            return new PropertyIdWithSource(this.propSource, this.propDescriptor.getId());
        }

        public CellEditor createPropertyEditor(Composite parent) {
            return this.propDescriptor.createPropertyEditor(parent);
        }

        public String getCategory() {
            return this.propDescriptor.getCategory();
        }

        public String getDescription() {
            return this.propDescriptor.getDescription();
        }

        public String getDisplayName() {
            return this.propDescriptor.getDisplayName();
        }

        public String[] getFilterFlags() {
            return this.propDescriptor.getFilterFlags();
        }

        public Object getHelpContextIds() {
            return this.propDescriptor.getHelpContextIds();
        }

        public ILabelProvider getLabelProvider() {
            return this.propDescriptor.getLabelProvider();
        }

        public boolean isCompatibleWith(IPropertyDescriptor anotherProperty) {
            return this.propDescriptor.isCompatibleWith(anotherProperty);
        }
    }

    private static class PropertyIdWithSource {
        final IPropertySource source;
        final Object id;

        PropertyIdWithSource(IPropertySource source, Object id) {
            this.source = source;
            this.id = id;
        }
    }
}

