/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.editors.parts.tree;

import java.util.Collections;
import java.util.List;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.stardust.model.xpdl.carnot.IIdentifiableElement;
import org.eclipse.stardust.model.xpdl.carnot.IIdentifiableModelElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelElement;
import org.eclipse.stardust.model.xpdl.carnot.util.ModelUtils;
import org.eclipse.stardust.modeling.core.editors.IValidationEventListener;
import org.eclipse.stardust.modeling.core.editors.IValidationStatus;
import org.eclipse.stardust.modeling.core.editors.WorkflowModelEditor;
import org.eclipse.stardust.modeling.core.editors.parts.tree.AbstractEObjectTreeEditPart;

public class ChildCategoryNode
extends AbstractEObjectTreeEditPart {
    private final Spec spec;

    public ChildCategoryNode(WorkflowModelEditor editor, Spec spec) {
        super(editor, spec, spec.target, spec.icon, spec.childrenFeatures);
        this.spec = spec;
        spec.setEditPart(this);
    }

    @Override
    public String getLabel() {
        return this.spec.label;
    }

    @Override
    protected List getModelChildren() {
        List items = super.getModelChildren();
        Collections.sort(items, ModelUtils.IDENTIFIABLE_COMPARATOR);
        return items;
    }

    @Override
    public Object getAdapter(Class key) {
        if (this.spec.target instanceof IModelElement && (IIdentifiableModelElement.class.equals((Object)key) || IIdentifiableElement.class.equals((Object)key) || IModelElement.class.equals((Object)key))) {
            return this.spec.target;
        }
        return super.getAdapter(key);
    }

    public static class Spec
    implements IValidationEventListener {
        public AbstractEObjectTreeEditPart editPart;
        public final EObject target;
        public final String label;
        public final String icon;
        public final EStructuralFeature[] childrenFeatures;

        public EObject getTarget() {
            return this.target;
        }

        public Spec(EObject target, String label, String icon, EStructuralFeature[] childrenFeatures) {
            this.target = target;
            this.label = label;
            this.icon = icon;
            this.childrenFeatures = childrenFeatures;
        }

        public void setEditPart(ChildCategoryNode node) {
            this.editPart = node;
        }

        @Override
        public void onIssuesUpdated(EObject element, IValidationStatus validationStatus) {
            boolean hasWarnings = !validationStatus.getWarnings().isEmpty() || !validationStatus.getChildrenWithWarnings().isEmpty();
            boolean hasErrors = !validationStatus.getErrors().isEmpty() || !validationStatus.getChildrenWithErrors().isEmpty();
            int i = 0;
            while (i < this.childrenFeatures.length) {
                AbstractEObjectTreeEditPart treePart;
                EReference ref = (EReference)this.childrenFeatures[i];
                EClass eClass = ref.getEReferenceType();
                if (eClass.equals(element.eClass()) && (treePart = this.editPart) != null) {
                    treePart.setState(hasErrors ? 2 : (hasWarnings ? 1 : 0));
                }
                ++i;
            }
        }
    }
}

