/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.editors.tools;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.requests.CreationFactory;
import org.eclipse.gef.tools.ConnectionCreationTool;
import org.eclipse.gef.ui.parts.ScrollingGraphicalViewer;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.AbstractNodeSymbolEditPart;
import org.eclipse.stardust.modeling.core.editors.tools.CommandCanceledException;
import org.eclipse.stardust.modeling.core.editors.tools.ViewportScrollHelper;

public class CarnotConnectionCreationTool
extends ConnectionCreationTool {
    public CarnotConnectionCreationTool() {
        this.setUnloadWhenFinished(true);
    }

    protected void executeCurrentCommand() {
        try {
            super.executeCurrentCommand();
        }
        catch (CommandCanceledException commandCanceledException) {
            this.setCurrentCommand(null);
        }
    }

    public CarnotConnectionCreationTool(CreationFactory factory) {
        super(factory);
        this.setUnloadWhenFinished(true);
    }

    protected boolean handleMove() {
        if (super.handleMove() && this.isInState(64)) {
            this.scrollDiagramPage();
        }
        return true;
    }

    protected boolean handleHover() {
        if (super.handleHover() && this.isInState(64)) {
            this.scrollDiagramPage();
        }
        return true;
    }

    private void scrollDiagramPage() {
        if (this.getCurrentViewer() instanceof ScrollingGraphicalViewer) {
            ViewportScrollHelper scrollHelper = new ViewportScrollHelper((GraphicalEditPart)this.getCurrentViewer().getRootEditPart(), (ScrollingGraphicalViewer)this.getCurrentViewer());
            scrollHelper.updateViewport(this.getLocation());
        }
    }

    protected void handleFinished() {
        if (this.unloadWhenFinished() && !this.getCurrentInput().isControlKeyDown()) {
            this.getDomain().loadDefaultTool();
        } else {
            this.reactivate();
        }
    }

    public void startConnection(AbstractNodeSymbolEditPart part) {
        this.setViewer(part.getViewer());
        IFigure figure = part.getFigure();
        Point start = figure.getBounds().getCenter();
        figure = figure.getParent();
        while (figure.getParent() != null) {
            figure.translateToParent((Translatable)start);
            figure = figure.getParent();
        }
        this.getCurrentInput().getMouseLocation().setLocation(start);
        this.setStartLocation(start);
        this.handleButtonDown(1);
    }
}

