/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.editors.tools;

import java.util.List;
import org.eclipse.gef.palette.PaletteContainer;
import org.eclipse.gef.palette.PaletteEntry;
import org.eclipse.gef.palette.ToolEntry;
import org.eclipse.jface.resource.ImageDescriptor;

public class PaletteFlyout
extends PaletteContainer {
    public static final String PALETTE_TYPE_STACK = "$PaletteFlyout";
    public static final String PROPERTY_ACTIVE_ENTRY = "Active Entry";
    private PaletteEntry activeEntry;

    public PaletteFlyout(String name, String desc, ImageDescriptor icon) {
        super(name, desc, icon, (Object)PALETTE_TYPE_STACK);
        this.setUserModificationPermission(7);
    }

    public boolean acceptsType(Object type) {
        if (!type.equals(ToolEntry.PALETTE_TYPE_TOOL)) {
            return false;
        }
        return super.acceptsType(type);
    }

    public void add(int index, PaletteEntry entry) {
        super.add(index, entry);
        this.checkActiveEntry();
    }

    public void addAll(List list) {
        super.addAll(list);
        this.checkActiveEntry();
    }

    private void checkActiveEntry() {
        PaletteEntry currEntry = this.activeEntry;
        if (!this.getChildren().contains(this.activeEntry)) {
            this.activeEntry = null;
        }
        if (this.activeEntry == null && this.getChildren().size() > 0) {
            this.activeEntry = (PaletteEntry)this.getChildren().get(0);
        }
        this.listeners.firePropertyChange(PROPERTY_ACTIVE_ENTRY, currEntry, this.activeEntry);
    }

    public PaletteEntry getActiveEntry() {
        this.checkActiveEntry();
        return this.activeEntry;
    }

    public void remove(PaletteEntry entry) {
        super.remove(entry);
        this.checkActiveEntry();
    }

    public void setActiveEntry(PaletteEntry entry) {
        PaletteEntry oldEntry = this.activeEntry;
        if (this.activeEntry != null && (this.activeEntry.equals(entry) || !this.getChildren().contains(entry))) {
            return;
        }
        this.activeEntry = entry;
        this.listeners.firePropertyChange(PROPERTY_ACTIVE_ENTRY, oldEntry, this.activeEntry);
    }
}

