/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.editors.ui;

import java.util.ArrayList;
import java.util.HashSet;
import org.eclipse.swt.custom.TreeEditor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public abstract class CarnotCellEditor {
    private ArrayList<TreeEditor> editors = new ArrayList();
    private int column;

    public abstract boolean canEdit(Object var1);

    public abstract Object getValue(Object var1);

    public abstract void setValue(Object var1, Object var2);

    public abstract Control createControl(Composite var1, Object var2);

    public abstract void refresh(TreeEditor var1);

    public CarnotCellEditor(int column) {
        this.column = column;
    }

    public void setTree(Tree tree) {
        ArrayList<TreeEditor> free = new ArrayList<TreeEditor>();
        HashSet<TreeItem> used = new HashSet<TreeItem>();
        for (TreeEditor editor : this.editors) {
            TreeItem treeItem = editor.getItem();
            if (treeItem.isDisposed()) {
                free.add(editor);
                continue;
            }
            used.add(treeItem);
            editor.layout();
        }
        int i = free.size() - 1;
        while (i >= 0) {
            TreeEditor editor = (TreeEditor)free.get(i);
            this.editors.remove(editor);
            editor.getEditor().dispose();
            editor.dispose();
            --i;
        }
        this.addItems(tree, tree.getItems(), used);
    }

    private void addItems(Tree tree, TreeItem[] items, HashSet<TreeItem> used) {
        int i = 0;
        while (i < items.length) {
            Object data;
            TreeItem treeItem = items[i];
            if (!used.contains(treeItem) && this.canEdit(data = treeItem.getData())) {
                Control control = this.createControl((Composite)tree, data);
                TreeEditor editor = new TreeEditor(tree);
                editor.grabHorizontal = true;
                control.setBackground(tree.getBackground());
                control.setForeground(tree.getForeground());
                editor.setEditor(control, treeItem, this.column);
                this.editors.add(editor);
            }
            this.addItems(tree, treeItem.getItems(), used);
            ++i;
        }
    }

    public void dispose() {
        for (TreeEditor editor : this.editors) {
            editor.getEditor().dispose();
            editor.dispose();
        }
        this.editors.clear();
    }

    public void refresh() {
        for (TreeEditor editor : this.editors) {
            this.refresh(editor);
        }
    }
}

