/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.editors.ui;

import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.stardust.common.CollectionUtils;
import org.eclipse.stardust.common.StringUtils;
import org.eclipse.stardust.model.xpdl.carnot.IModelElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelElementNodeSymbol;
import org.eclipse.stardust.model.xpdl.carnot.spi.SpiExtensionRegistry;
import org.eclipse.stardust.modeling.common.platform.utils.ExtensionsResolver;
import org.eclipse.stardust.modeling.core.Diagram_Messages;
import org.eclipse.stardust.modeling.core.editors.ui.CarnotPreferenceNode;
import org.eclipse.stardust.modeling.core.editors.ui.ModelElementPropertyDialog;
import org.eclipse.stardust.modeling.core.properties.Category;
import org.eclipse.stardust.modeling.core.spi.ConfigurationElement;
import org.eclipse.stardust.modeling.core.spi.SpiPropertyPage;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IWorkbenchPropertyPage;
import org.eclipse.ui.PlatformUI;

public class CarnotPropertyPageContributor {
    private static final String CLASS_PROPERTY = "class";
    public static String[] CATEGORIES = new String[]{"core", "spi", "extension"};
    private static CarnotPropertyPageContributor instance;

    public static CarnotPropertyPageContributor instance() {
        if (instance == null) {
            instance = new CarnotPropertyPageContributor();
        }
        return instance;
    }

    public boolean contributePropertyPages(PreferenceManager manager, IAdaptable adaptable) {
        return this.contributePropertyPages(manager, adaptable, null);
    }

    public boolean contributePropertyPages(PreferenceManager manager, IAdaptable adaptable, String category) {
        List<CarnotPreferenceNode> list = this.contributePropertyPages(adaptable, category);
        int i = 0;
        while (i < list.size()) {
            CarnotPreferenceNode node = list.get(i);
            if (category == null) {
                manager.addToRoot((IPreferenceNode)node);
            } else {
                manager.addTo(category, (IPreferenceNode)node);
            }
            ++i;
        }
        return !list.isEmpty();
    }

    public List<CarnotPreferenceNode> contributePropertyPages(IAdaptable adaptable) {
        return this.contributePropertyPages(adaptable, null);
    }

    public List<CarnotPreferenceNode> contributePropertyPages(IAdaptable adaptable, String category) {
        IConfigurationElement[] extensions;
        IModelElement element;
        IPerspectiveDescriptor perspective = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getPerspective();
        Map filters = CollectionUtils.newMap();
        if (perspective != null) {
            filters.put("perspectiveType", perspective.getId());
        }
        if ((element = this.getModelElement(adaptable)) == null) {
            element = (EObject)adaptable.getAdapter(EObject.class);
        }
        List sorted = CollectionUtils.newList();
        IConfigurationElement[] iConfigurationElementArray = extensions = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.ui.propertyPages");
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement cfg = iConfigurationElementArray[n2];
            String cls = cfg.getAttribute(CLASS_PROPERTY);
            if (!Category.class.getName().equals(cls) && (category == null || category.equals(cfg.getAttribute("category"))) && ExtensionsResolver.isMatchingElement((EObject)element, (String)"objectClass", (Map)filters, (IConfigurationElement)cfg)) {
                sorted.add(cfg);
            }
            ++n2;
        }
        Collections.sort(sorted, new Comparator<IConfigurationElement>(){

            @Override
            public int compare(IConfigurationElement c1, IConfigurationElement c2) {
                String cat1 = c1.getAttribute("category");
                String cat2 = c2.getAttribute("category");
                String id1 = c1.getAttribute("id");
                String id2 = c2.getAttribute("id");
                if (StringUtils.isEmpty((String)cat2)) {
                    return -1;
                }
                if (StringUtils.isEmpty((String)cat1)) {
                    return 1;
                }
                if (id1.equals("_cwm_general_")) {
                    return -1;
                }
                if (id2.equals("_cwm_general_")) {
                    return 1;
                }
                if (cat1.equals(cat2)) {
                    return id1.compareTo(id2);
                }
                int i = 0;
                while (i < CATEGORIES.length) {
                    if (CATEGORIES[i].equals(cat1)) {
                        return -1;
                    }
                    if (CATEGORIES[i].equals(cat2)) {
                        return 1;
                    }
                    ++i;
                }
                return cat1.compareTo(cat2);
            }
        });
        Map children = CollectionUtils.newMap();
        int i = 0;
        while (i < sorted.size()) {
            IConfigurationElement c1 = (IConfigurationElement)sorted.get(i);
            String cat1 = c1.getAttribute("category");
            if (!StringUtils.isEmpty((String)cat1)) {
                int j = 0;
                while (j < sorted.size()) {
                    IConfigurationElement c2;
                    String id2;
                    if (j != i && cat1.equals(id2 = (c2 = (IConfigurationElement)sorted.get(j)).getAttribute("id"))) {
                        List list = (List)children.get(c2);
                        if (list == null) {
                            list = CollectionUtils.newList();
                            children.put(c2, list);
                        }
                        list.add(c1);
                    }
                    ++j;
                }
            }
            ++i;
        }
        Collection values = children.values();
        for (List list : values) {
            sorted.removeAll(list);
        }
        List result = CollectionUtils.newList();
        int i2 = 0;
        while (i2 < sorted.size()) {
            IConfigurationElement c1 = (IConfigurationElement)sorted.get(i2);
            CarnotPreferenceNode node = new CarnotPreferenceNode(new ConfigurationElement(c1), adaptable, CLASS_PROPERTY, i2);
            result.add(node);
            this.addChildren(node, adaptable, c1, children);
            ++i2;
        }
        return result;
    }

    private void addChildren(CarnotPreferenceNode parent, IAdaptable adaptable, IConfigurationElement cfg, Map<IConfigurationElement, List<IConfigurationElement>> children) {
        List<IConfigurationElement> list = children.get(cfg);
        if (list != null) {
            int i = 0;
            while (i < list.size()) {
                IConfigurationElement c1 = list.get(i);
                CarnotPreferenceNode node = new CarnotPreferenceNode(new ConfigurationElement(c1), adaptable, CLASS_PROPERTY, i);
                parent.add((IPreferenceNode)node);
                this.addChildren(node, adaptable, c1, children);
                ++i;
            }
        }
    }

    public boolean isApplicableTo(IAdaptable adaptable) {
        if (!(adaptable instanceof EditPart)) {
            return false;
        }
        IModelElement element = this.getModelElement(adaptable);
        if (element == null) {
            element = (EObject)adaptable.getAdapter(EObject.class);
        }
        IPerspectiveDescriptor perspective = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getPerspective();
        Map filters = CollectionUtils.newMap();
        if (perspective != null) {
            filters.put("perspectiveType", perspective.getId());
        }
        IConfigurationElement[] extensions = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.ui.propertyPages");
        int i = 0;
        while (i < extensions.length) {
            if (ExtensionsResolver.isMatchingElement((EObject)element, (String)"objectClass", (Map)filters, (IConfigurationElement)extensions[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected IModelElement getModelElement(IAdaptable adaptable) {
        IModelElementNodeSymbol symbol = (IModelElementNodeSymbol)adaptable.getAdapter(IModelElementNodeSymbol.class);
        if (symbol != null && symbol.getModelElement() == null) {
            return (IModelElement)adaptable.getAdapter(IModelElement.class);
        }
        return symbol == null ? (IModelElement)adaptable.getAdapter(IModelElement.class) : symbol.getModelElement();
    }

    public boolean contributeSpiPropertyPages(final ModelElementPropertyDialog dialog, String extensionPointId, String extensionId, IAdaptable element) {
        Map extensions = SpiExtensionRegistry.instance().getExtensions(extensionPointId);
        IConfigurationElement template = (IConfigurationElement)extensions.get(extensionId);
        PreferenceManager manager = dialog.getPreferenceManager();
        if (template != null && manager.find(ModelElementPropertyDialog.convertId(template.getAttribute("id"))) == null) {
            final ConfigurationElement cfgTemplate = new ConfigurationElement(template);
            CarnotPreferenceNode node = new CarnotPreferenceNode(cfgTemplate, element, 1000){

                @Override
                public void createPage() {
                    try {
                        SpiPropertyPage page = new SpiPropertyPage(cfgTemplate);
                        this.internalSetPage((IWorkbenchPropertyPage)page);
                    }
                    catch (CoreException e) {
                        ErrorDialog.openError((Shell)dialog.getShell(), (String)Diagram_Messages.ERROR_DIA_EXC, (String)e.getMessage(), (IStatus)e.getStatus());
                    }
                }
            };
            dialog.addNodeTo(null, node, null);
            return true;
        }
        return false;
    }
}

