/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.editors.ui;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.stardust.model.xpdl.carnot.ITypedElement;
import org.eclipse.stardust.modeling.core.DiagramPlugin;
import org.eclipse.stardust.modeling.core.editors.WorkflowModelEditor;
import org.eclipse.stardust.modeling.core.editors.parts.IconFactory;
import org.eclipse.stardust.modeling.core.editors.ui.TableLabelProvider;
import org.eclipse.swt.graphics.Image;

public class EObjectLabelProvider
extends LabelProvider
implements TableLabelProvider {
    protected WorkflowModelEditor editor;

    public EObjectLabelProvider(WorkflowModelEditor editor) {
        this.editor = editor;
    }

    public String getText(Object element) {
        if (element instanceof EObject) {
            String text = this.getText("name", element);
            if (text.length() == 0) {
                text = this.getText("id", element);
            }
            if (text.length() == 0 && element instanceof ITypedElement) {
                text = this.getText(((ITypedElement)element).getMetaType());
            }
            if (text.length() != 0) {
                return text;
            }
        }
        return super.getText(element);
    }

    public boolean isLabelProperty(Object element, String property) {
        return super.isLabelProperty(element, property);
    }

    @Override
    public String getText(String name, Object element) {
        EObject eObject = (EObject)element;
        EStructuralFeature attr = eObject.eClass().getEStructuralFeature(name);
        Object value = attr == null ? null : eObject.eGet(attr);
        return value == null ? "" : value.toString();
    }

    @Override
    public String getText(int index, Object element) {
        EObject eObject = (EObject)element;
        EStructuralFeature attr = eObject.eClass().getEStructuralFeature(index);
        Object value = attr == null ? null : eObject.eGet(attr);
        return value == null ? "" : value.toString();
    }

    @Override
    public boolean isNamed() {
        return true;
    }

    @Override
    public boolean accept(Object element) {
        return element instanceof EObject;
    }

    @Override
    public Image getImage(Object element) {
        IconFactory iconFactory = this.editor != null ? this.editor.getIconFactory() : new IconFactory(null);
        String icon = iconFactory.getIconFor((EObject)element);
        return icon == null ? null : DiagramPlugin.getImage(icon);
    }
}

