/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.editors.ui.validation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.preference.IPreferencePage;
import org.eclipse.jface.util.ListenerList;
import org.eclipse.stardust.modeling.common.platform.validation.IQuickValidationStatus;
import org.eclipse.stardust.modeling.common.ui.jface.databinding.IBindingMediator;
import org.eclipse.stardust.modeling.common.ui.jface.databinding.IModelAdapter;
import org.eclipse.stardust.modeling.common.ui.jface.databinding.IWidgetAdapter;
import org.eclipse.stardust.modeling.common.ui.jface.databinding.SwtWidgetAdapter;
import org.eclipse.stardust.modeling.common.ui.jface.widgets.LabelWithStatus;
import org.eclipse.stardust.modeling.core.editors.IEObjectValidationStatus;
import org.eclipse.stardust.modeling.core.editors.IValidationEventListener;
import org.eclipse.stardust.modeling.core.editors.IValidationStatus;
import org.eclipse.stardust.modeling.core.editors.ui.IPageValidationEventListener;
import org.eclipse.stardust.modeling.core.editors.ui.validation.SwtValidationLabelAdapter;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Widget;

public class PageValidationManager
implements IValidationEventListener {
    private final IPreferencePage page;
    private final ListenerList pageStatusListeners = new ListenerList();
    private static final IBindingMediator NOOP_MEDIATOR = new NoopBindingMediator();
    private final Map widgetBindings = new HashMap();
    private final Map infos = new HashMap();
    private final Map warnings = new HashMap();
    private final Map errors = new HashMap();

    public PageValidationManager(IPreferencePage page) {
        this.page = page;
    }

    public void dispose() {
        while (!this.widgetBindings.isEmpty()) {
            this.unbind(this.widgetBindings.keySet().iterator().next());
        }
    }

    public void bind(EObject model, Object feature, Label label) {
        this.bind(model, feature, (IWidgetAdapter)new SwtValidationLabelAdapter(label));
    }

    public void bind(EObject model, Object feature, LabelWithStatus label) {
        this.bind(model, feature, (IWidgetAdapter)new SwtValidationLabelAdapter(label));
    }

    public void bind(EObject model, Object feature, IWidgetAdapter widgetAdapter) {
        ArrayList<IWidgetAdapter> eFtrBindings;
        HashMap<Object, ArrayList<IWidgetAdapter>> modelBindings = (HashMap<Object, ArrayList<IWidgetAdapter>>)this.widgetBindings.get(model);
        if (modelBindings == null) {
            modelBindings = new HashMap<Object, ArrayList<IWidgetAdapter>>();
            this.widgetBindings.put(model, modelBindings);
        }
        if ((eFtrBindings = (ArrayList<IWidgetAdapter>)modelBindings.get(feature)) == null) {
            eFtrBindings = new ArrayList<IWidgetAdapter>();
            modelBindings.put(feature, eFtrBindings);
        }
        eFtrBindings.add(widgetAdapter);
        widgetAdapter.bind(NOOP_MEDIATOR);
    }

    public void unbind(EObject model, Object feature, Widget widget) {
        List eFtrBindings;
        Map modelBindings = (Map)this.widgetBindings.get(model);
        if (modelBindings != null && (eFtrBindings = (List)modelBindings.get(feature)) != null) {
            int i = 0;
            while (i < eFtrBindings.size()) {
                IWidgetAdapter ftrBinding = (IWidgetAdapter)eFtrBindings.get(i);
                if (ftrBinding instanceof SwtWidgetAdapter && ((SwtWidgetAdapter)ftrBinding).getWidget().equals(widget)) {
                    eFtrBindings.remove(ftrBinding);
                    ftrBinding.unbind();
                    break;
                }
                ++i;
            }
        }
    }

    public void unbind(Object model) {
        Map modelBindings = (Map)this.widgetBindings.remove(model);
        if (modelBindings != null) {
            for (List eFtrBindings : modelBindings.values()) {
                Iterator j = eFtrBindings.iterator();
                while (j.hasNext()) {
                    ((IWidgetAdapter)j.next()).unbind();
                }
            }
            modelBindings.clear();
        }
    }

    public IQuickValidationStatus getPageStatus() {
        return new PageValidationStatus();
    }

    public void addPageValidationEventListener(IPageValidationEventListener listener) {
        this.pageStatusListeners.add((Object)listener);
    }

    public void removePageValidationEventListener(IPageValidationEventListener listener) {
        this.pageStatusListeners.remove((Object)listener);
    }

    @Override
    public void onIssuesUpdated(EObject element, IValidationStatus validationStatus) {
        Map modelBindings = (Map)this.widgetBindings.get(element);
        if (modelBindings != null) {
            for (Map.Entry entry : modelBindings.entrySet()) {
                Object feature = entry.getKey();
                List eFtrBindings = (List)entry.getValue();
                IValidationStatus bindingStatus = validationStatus;
                if (bindingStatus instanceof IEObjectValidationStatus && feature != null) {
                    bindingStatus = ((IEObjectValidationStatus)bindingStatus).getFeatureStatus(feature);
                }
                Iterator j = eFtrBindings.iterator();
                while (j.hasNext()) {
                    ((IWidgetAdapter)j.next()).updateVisuals((Object)bindingStatus);
                }
                PageValidationManager.updateValidationStatus(this.infos, element, feature, bindingStatus.hasInfos());
                PageValidationManager.updateValidationStatus(this.warnings, element, feature, bindingStatus.hasWarnings());
                PageValidationManager.updateValidationStatus(this.errors, element, feature, bindingStatus.hasErrors());
            }
        }
        this.firePageStatusUpdated();
    }

    protected void firePageStatusUpdated() {
        IQuickValidationStatus status = this.getPageStatus();
        Object[] listeners = this.pageStatusListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            ((IPageValidationEventListener)listeners[i]).pageStatusUpdated(this.page, status);
            ++i;
        }
    }

    private static final void updateValidationStatus(Map issueRegistry, Object model, Object eFtr, boolean hasIssues) {
        HashSet<Object> modelIssues = (HashSet<Object>)issueRegistry.get(model);
        if (hasIssues) {
            if (modelIssues == null) {
                modelIssues = new HashSet<Object>();
                issueRegistry.put(model, modelIssues);
            }
            modelIssues.add(eFtr);
        } else if (modelIssues != null) {
            modelIssues.remove(eFtr);
            if (modelIssues.isEmpty()) {
                issueRegistry.remove(model);
            }
        }
    }

    private static final class NoopBindingMediator
    implements IBindingMediator {
        private NoopBindingMediator() {
        }

        public void updateModel(IWidgetAdapter binding, Object value) {
        }

        public void updateWidget(IModelAdapter binding, Object value) {
        }
    }

    final class PageValidationStatus
    implements IQuickValidationStatus {
        PageValidationStatus() {
        }

        public boolean hasIssues() {
            return this.hasErrors() || this.hasWarnings() || this.hasInfos();
        }

        public boolean hasInfos() {
            return !PageValidationManager.this.infos.isEmpty();
        }

        public boolean hasWarnings() {
            return !PageValidationManager.this.warnings.isEmpty();
        }

        public boolean hasErrors() {
            return !PageValidationManager.this.errors.isEmpty();
        }
    }
}

