/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.editors.ui.validation;

import java.util.Iterator;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.stardust.modeling.common.platform.validation.IQuickValidationStatus;
import org.eclipse.stardust.modeling.common.ui.jface.databinding.SwtWidgetAdapter;
import org.eclipse.stardust.modeling.common.ui.jface.widgets.LabelWithStatus;
import org.eclipse.stardust.modeling.core.Diagram_Messages;
import org.eclipse.stardust.modeling.core.editors.IValidationStatus;
import org.eclipse.stardust.modeling.validation.Issue;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Widget;

public class SwtValidationLabelAdapter
extends SwtWidgetAdapter {
    public SwtValidationLabelAdapter(Label label) {
        super((Widget)label);
    }

    public SwtValidationLabelAdapter(LabelWithStatus label) {
        super((Widget)label);
    }

    public void updateControl(Object value) {
        if (value instanceof IValidationStatus && this.getWidget() != null && !this.getWidget().isDisposed()) {
            IValidationStatus status = (IValidationStatus)value;
            if (this.getWidget() instanceof LabelWithStatus) {
                ((LabelWithStatus)this.getWidget()).setValidationStatus((IQuickValidationStatus)status);
            } else if (this.getWidget() instanceof Label) {
                ((Label)this.getWidget()).setForeground(!status.getErrors().isEmpty() ? ColorConstants.red : (!status.getWarnings().isEmpty() ? ColorConstants.yellow : ColorConstants.black));
            }
            if (this.getWidget() instanceof Control) {
                String nl = "";
                StringBuffer toolTip = new StringBuffer();
                Iterator i = status.getErrors().iterator();
                while (i.hasNext()) {
                    toolTip.append(nl).append(Diagram_Messages.LB_ToolTip_Error).append(((Issue)i.next()).getMessage());
                    nl = "\n";
                }
                i = status.getWarnings().iterator();
                while (i.hasNext()) {
                    toolTip.append(nl).append(Diagram_Messages.LB_ToolTip_Warning).append(((Issue)i.next()).getMessage());
                    nl = "\n";
                }
                ((Control)this.getWidget()).setToolTipText(toolTip.toString());
            }
        }
    }
}

