/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.export;

import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.SWTGraphics;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.editparts.LayerManager;
import org.eclipse.gef.ui.parts.ScrollingGraphicalViewer;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.stardust.common.error.PublicException;
import org.eclipse.stardust.common.log.LogManager;
import org.eclipse.stardust.common.log.Logger;
import org.eclipse.stardust.model.xpdl.carnot.ActivitySymbolType;
import org.eclipse.stardust.model.xpdl.carnot.DiagramType;
import org.eclipse.stardust.model.xpdl.carnot.TransitionConnectionType;
import org.eclipse.stardust.model.xpdl.carnot.TransitionType;
import org.eclipse.stardust.modeling.core.DiagramPlugin;
import org.eclipse.stardust.modeling.core.Diagram_Messages;
import org.eclipse.stardust.modeling.core.editors.WorkflowModelEditor;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.ActivitySymbolNodeEditPart;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.IHighliteableGraphicalObject;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.WorkflowModelDiagramEditPartFactory;
import org.eclipse.stardust.modeling.core.highlighting.ColorFactory;
import org.eclipse.stardust.modeling.core.highlighting.HighlightState;
import org.eclipse.stardust.modeling.core.highlighting.IColorFactory;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchPart;

public class DiagramExporter {
    private static final Logger trace = LogManager.getLogger(DiagramExporter.class);
    private static final boolean headlessMode;
    private static int jpgInsetLeft;
    private static int jpgInsetRigth;
    private static int jpgInsetTop;
    private static int jpgInsetBottom;
    private DiagramType diagram;
    private Map highligteStates;
    private final IColorFactory colorFactory;
    private Integer changedFontHeight;
    private final IWorkbenchPart editor;

    static {
        if (DiagramPlugin.getDefault() == null) {
            new DiagramPlugin();
            headlessMode = true;
        } else {
            headlessMode = false;
        }
        jpgInsetLeft = 50;
        jpgInsetRigth = 50;
        jpgInsetTop = 25;
        jpgInsetBottom = 25;
    }

    public DiagramExporter(DiagramType diagram) {
        this(diagram, null, null);
    }

    public DiagramExporter(DiagramType diagram, Integer fontHeight) {
        this(diagram, fontHeight, null);
    }

    public DiagramExporter(DiagramType diagram, IWorkbenchPart workbenchPart) {
        this(diagram, null, workbenchPart);
    }

    protected DiagramExporter(DiagramType diagram, Integer fontHeight, IWorkbenchPart workbenchPart) {
        this.diagram = diagram;
        this.changedFontHeight = fontHeight;
        this.editor = workbenchPart;
        this.setHighligteStates(null);
        if (headlessMode && Display.getCurrent() == null) {
            new Display();
        }
        this.colorFactory = new ColorFactory(ColorConstants.black);
    }

    public byte[] dumpDiagramToJPEG() {
        BufferedImage image = this.drawDiagram();
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        this.encodeImage(image, outStream, "jpeg");
        return outStream.toByteArray();
    }

    public byte[] dumpDiagramToPNG() {
        BufferedImage image = this.drawDiagram();
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        this.encodeImage(image, outStream, "png");
        return outStream.toByteArray();
    }

    public byte[] dumpDiagramToGIF() {
        BufferedImage image = this.drawDiagram();
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        this.encodeImage(image, outStream, "gif");
        return outStream.toByteArray();
    }

    public void dumpDiagramToJPEGFile(File file) {
        BufferedImage image = this.drawDiagram();
        try {
            this.encodeImage(image, new FileOutputStream(file), "jpeg");
        }
        catch (FileNotFoundException e) {
            throw new PublicException((Throwable)e);
        }
    }

    public void dumpDiagramToPNGFile(File file) {
        BufferedImage image = this.drawDiagram();
        try {
            this.encodeImage(image, new FileOutputStream(file), "png");
        }
        catch (FileNotFoundException e) {
            throw new PublicException((Throwable)e);
        }
    }

    public void dumpDiagramToGIFFile(File file) {
        BufferedImage image = this.drawDiagram();
        try {
            this.encodeImage(image, new FileOutputStream(file), "gif");
        }
        catch (FileNotFoundException e) {
            throw new PublicException((Throwable)e);
        }
    }

    public void setHighligteStates(Map highligteStates) {
        this.highligteStates = highligteStates != null ? highligteStates : new HashMap();
    }

    private void applyHighlightStates(EditPart editPart) {
        if (editPart != null) {
            Long oid;
            HighlightState highlightState;
            TransitionConnectionType transitionConnection;
            TransitionType transition;
            Object rawModel = editPart.getModel();
            if (rawModel instanceof ActivitySymbolType) {
                ActivitySymbolType activitySymbol = (ActivitySymbolType)rawModel;
                Long oid2 = new Long(activitySymbol.getActivity().getElementOid());
                HighlightState highlightState2 = (HighlightState)((Object)this.highligteStates.get(oid2));
                if (highlightState2 != null) {
                    IHighliteableGraphicalObject highlightable = (IHighliteableGraphicalObject)editPart;
                    highlightable.setHighliteBorderColor(this.colorFactory.createColor(highlightState2));
                }
                ActivitySymbolNodeEditPart symbolEditPart = (ActivitySymbolNodeEditPart)editPart;
                ArrayList connectionEditParts = new ArrayList();
                connectionEditParts.addAll(symbolEditPart.getSourceConnections());
                connectionEditParts.addAll(symbolEditPart.getTargetConnections());
                Iterator iter = connectionEditParts.iterator();
                while (iter.hasNext()) {
                    this.applyHighlightStates((EditPart)iter.next());
                }
            } else if (rawModel instanceof TransitionConnectionType && (transition = (transitionConnection = (TransitionConnectionType)rawModel).getTransition()) != null && (highlightState = (HighlightState)((Object)this.highligteStates.get(oid = new Long(transition.getElementOid())))) != null) {
                IHighliteableGraphicalObject highlightable = (IHighliteableGraphicalObject)editPart;
                highlightable.setHighliteBorderColor(this.colorFactory.createColor(highlightState));
            }
            Iterator iter = editPart.getChildren().iterator();
            while (iter.hasNext()) {
                this.applyHighlightStates((EditPart)iter.next());
            }
        }
    }

    private BufferedImage drawDiagram() {
        ScrollingGraphicalViewer viewer = new ScrollingGraphicalViewer();
        viewer.setEditPartFactory((EditPartFactory)new WorkflowModelDiagramEditPartFactory((WorkflowModelEditor)(this.editor instanceof WorkflowModelEditor ? this.editor : null)));
        EditPart editPart = viewer.getEditPartFactory().createEditPart(null, (Object)this.diagram);
        editPart.setParent((EditPart)viewer.getRootEditPart());
        if (editPart instanceof GraphicalEditPart) {
            Font font = JFaceResources.getDialogFont();
            try {
                Image imageBuffer;
                IFigure diagramLayer;
                GraphicalEditPart graphicalEditPart = (GraphicalEditPart)editPart;
                viewer.setContents((EditPart)graphicalEditPart);
                this.applyHighlightStates((EditPart)graphicalEditPart);
                if (this.changedFontHeight != null) {
                    FontData[] fontData = font.getFontData();
                    int i = 0;
                    while (i < fontData.length) {
                        fontData[i].setHeight(this.changedFontHeight.intValue());
                        ++i;
                    }
                    font = new Font((Device)Display.getCurrent(), fontData);
                }
                if ((diagramLayer = graphicalEditPart.getFigure()).getBackgroundColor() == null) {
                    diagramLayer.setBackgroundColor(ColorConstants.white);
                }
                diagramLayer.setFont(font);
                diagramLayer.validate();
                LayerManager manager = (LayerManager)viewer.getEditPartRegistry().get(LayerManager.ID);
                IFigure connectionLayer = manager.getLayer((Object)"Connection Layer");
                connectionLayer.setFont(font);
                connectionLayer.validate();
                Rectangle bounds = this.computeBounds(diagramLayer);
                diagramLayer.setBounds(bounds);
                try {
                    imageBuffer = new Image(null, bounds.width, bounds.height);
                }
                catch (SWTError sWTError) {
                    imageBuffer = null;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    imageBuffer = null;
                }
                if (imageBuffer == null) {
                    throw new RuntimeException(MessageFormat.format(Diagram_Messages.MSG_CannotCreateImageBuffer, new Object[0]));
                }
                GC imageGC = new GC((Drawable)imageBuffer, 0x6000000);
                SWTGraphics graphics = new SWTGraphics(imageGC);
                graphics.translate(bounds.getLocation().negate());
                graphics.setClip(bounds);
                graphics.fillRectangle(bounds.x, bounds.y, bounds.width, bounds.height);
                diagramLayer.setBorder(null);
                diagramLayer.paint((Graphics)graphics);
                connectionLayer.setBorder(null);
                connectionLayer.paint((Graphics)graphics);
                BufferedImage bufferedImage = DiagramExporter.convertToAWT(imageBuffer.getImageData());
                return bufferedImage;
            }
            finally {
                if (this.changedFontHeight != null) {
                    font.dispose();
                }
            }
        }
        throw new RuntimeException(Diagram_Messages.MSG_CannotDrawDiagram);
    }

    private Rectangle computeBounds(IFigure figure) {
        int left = Integer.MAX_VALUE;
        int right = Integer.MIN_VALUE;
        int top = Integer.MAX_VALUE;
        int bottom = Integer.MIN_VALUE;
        List children = figure.getChildren();
        for (IFigure child : children) {
            Rectangle childBounds = child.getBounds();
            left = Math.min(left, childBounds.x);
            right = Math.max(right, childBounds.x + childBounds.width);
            top = Math.min(top, childBounds.y);
            bottom = Math.max(bottom, childBounds.y + childBounds.height);
        }
        Rectangle rect = new Rectangle(left - jpgInsetLeft, top - jpgInsetTop, right - left + jpgInsetLeft + jpgInsetRigth, bottom - top + jpgInsetTop + jpgInsetBottom);
        return rect;
    }

    private void encodeImage(BufferedImage image, OutputStream outStream, String imgFormat) {
        try {
            try {
                ImageIO.write((RenderedImage)image, imgFormat, outStream);
            }
            catch (Exception x) {
                throw new PublicException((Throwable)x);
            }
        }
        finally {
            if (outStream != null) {
                try {
                    outStream.close();
                }
                catch (IOException ex) {
                    throw new PublicException((Throwable)ex);
                }
            }
        }
    }

    private static BufferedImage convertToAWT(ImageData data) {
        ColorModel colorModel = null;
        PaletteData palette = data.palette;
        if (palette.isDirect) {
            colorModel = new DirectColorModel(data.depth, palette.redMask, palette.greenMask, palette.blueMask);
            BufferedImage bufferedImage = new BufferedImage(colorModel, colorModel.createCompatibleWritableRaster(data.width, data.height), false, null);
            WritableRaster raster = bufferedImage.getRaster();
            int[] pixelArray = new int[3];
            int y = 0;
            while (y < data.height) {
                int x = 0;
                while (x < data.width) {
                    int pixel = data.getPixel(x, y);
                    RGB rgb = palette.getRGB(pixel);
                    pixelArray[0] = rgb.red;
                    pixelArray[1] = rgb.green;
                    pixelArray[2] = rgb.blue;
                    raster.setPixels(x, y, 1, 1, pixelArray);
                    ++x;
                }
                ++y;
            }
            return bufferedImage;
        }
        RGB[] rgbs = palette.getRGBs();
        byte[] red = new byte[rgbs.length];
        byte[] green = new byte[rgbs.length];
        byte[] blue = new byte[rgbs.length];
        int i = 0;
        while (i < rgbs.length) {
            RGB rgb = rgbs[i];
            red[i] = (byte)rgb.red;
            green[i] = (byte)rgb.green;
            blue[i] = (byte)rgb.blue;
            ++i;
        }
        colorModel = data.transparentPixel != -1 ? new IndexColorModel(data.depth, rgbs.length, red, green, blue, data.transparentPixel) : new IndexColorModel(data.depth, rgbs.length, red, green, blue);
        BufferedImage bufferedImage = new BufferedImage(colorModel, colorModel.createCompatibleWritableRaster(data.width, data.height), false, null);
        WritableRaster raster = bufferedImage.getRaster();
        int[] pixelArray = new int[1];
        int y = 0;
        while (y < data.height) {
            int x = 0;
            while (x < data.width) {
                int pixel;
                pixelArray[0] = pixel = data.getPixel(x, y);
                raster.setPixel(x, y, pixelArray);
                ++x;
            }
            ++y;
        }
        return bufferedImage;
    }
}

