/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.properties;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.stardust.model.xpdl.carnot.IExtensibleElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelElementNodeSymbol;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.model.xpdl.carnot.util.AttributeUtil;
import org.eclipse.stardust.model.xpdl.carnot.util.ModelUtils;
import org.eclipse.stardust.model.xpdl.carnot.util.VariableContext;
import org.eclipse.stardust.model.xpdl.carnot.util.VariableContextHelper;
import org.eclipse.stardust.modeling.common.platform.utils.WorkspaceUtils;
import org.eclipse.stardust.modeling.common.ui.jface.utils.FormBuilder;
import org.eclipse.stardust.modeling.core.Diagram_Messages;
import org.eclipse.stardust.modeling.core.editors.WorkflowModelEditor;
import org.eclipse.stardust.modeling.core.properties.AbstractModelElementPropertyPage;
import org.eclipse.stardust.modeling.javascript.editor.EditorUtils;
import org.eclipse.stardust.modeling.javascript.editor.JSCompilationUnitEditor;
import org.eclipse.stardust.modeling.javascript.editor.controller.JavaScriptEditorController;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;

public class ActivityCriticalityPropertyPage
extends AbstractModelElementPropertyPage {
    private Composite sourceViewerComposite;
    private Label criticalityFormula;
    private JSCompilationUnitEditor criticalityFormulaEditor;
    private JavaScriptEditorController controller = new JavaScriptEditorController();
    private IProject project;
    private ModelType model;

    @Override
    public void dispose() {
        super.dispose();
        EditorUtils.deleteFileStructure((IProject)this.project, (ModelType)this.model);
    }

    @Override
    protected void performDefaults() {
        super.performDefaults();
    }

    @Override
    public void loadFieldsFromElement(IModelElementNodeSymbol symbol, IModelElement element) {
        ModelType model = ModelUtils.findContainingModel((EObject)element);
        this.controller.intializeModel(model);
        this.loadFormula(element);
    }

    private void loadFormula(IModelElement element) {
        String formula = AttributeUtil.getAttributeValue((IExtensibleElement)((IExtensibleElement)element), (String)"ipp:criticalityFormula");
        this.refreshDocument();
        if (formula != null) {
            this.criticalityFormulaEditor.getAdaptedSourceViewer().getTextWidget().setText(formula.trim());
        }
    }

    @Override
    public void loadElementFromFields(IModelElementNodeSymbol symbol, IModelElement element) {
        ModelType model = ModelUtils.findContainingModel((EObject)element);
        String formula = this.criticalityFormulaEditor.getAdaptedSourceViewer().getTextWidget().getText().trim();
        VariableContext variableContext = VariableContextHelper.getInstance().getContext(model);
        if (variableContext != null && !variableContext.isCriticalityFormulaChanged()) {
            AttributeUtil.setAttribute((IExtensibleElement)model, (String)"ipp:criticalityFormula", (String)"String", (String)formula);
            variableContext.setCriticalityFormulaChanged(false);
        } else {
            this.loadFormula(element);
        }
    }

    public void refreshDocument() {
        this.criticalityFormulaEditor.getAdaptedSourceViewer().getDocument().set(this.controller.getMasterDocument());
        this.controller.recalculateRegions(this.criticalityFormulaEditor.getAdaptedSourceViewer().getDocument());
        JSCompilationUnitEditor.RegionWithLineOffset expressionRegion = this.controller.getExpressionRegion();
        this.criticalityFormulaEditor.getAdaptedSourceViewer().setVisibleRegion(expressionRegion.getOffset(), expressionRegion.getLength());
        this.criticalityFormulaEditor.setLineOffset(expressionRegion.getLineOffset());
    }

    @Override
    public Control createBody(Composite parent) {
        Composite composite = FormBuilder.createComposite((Composite)parent, (int)1);
        this.model = ModelUtils.findContainingModel((EObject)this.getModelElement());
        WorkflowModelEditor editor = (WorkflowModelEditor)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        IEditorSite editorSite = editor.getEditorSite();
        this.project = WorkspaceUtils.getProjectFromEObject((EObject)this.getModelElement());
        this.criticalityFormula = FormBuilder.createLabel((Composite)composite, (String)Diagram_Messages.LBL_Formula, (int)2);
        EditorUtils.deleteFileStructure((IProject)this.project, (ModelType)this.model);
        try {
            EditorUtils.addJSSupport((IProject)this.project, (ModelType)this.model);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        IFile tempFileResource = EditorUtils.createFileStructure((IProject)this.project, (ModelType)this.model, (String)"conditions.js");
        this.criticalityFormulaEditor = new JSCompilationUnitEditor();
        this.criticalityFormulaEditor.setTheSite((IWorkbenchPartSite)editorSite);
        this.criticalityFormulaEditor.setInput((IEditorInput)new FileEditorInput(tempFileResource));
        this.sourceViewerComposite = new Composite(composite, 0);
        GridData svcData = new GridData();
        svcData.grabExcessHorizontalSpace = true;
        svcData.grabExcessVerticalSpace = true;
        svcData.horizontalSpan = 2;
        svcData.horizontalAlignment = 4;
        svcData.verticalAlignment = 4;
        this.sourceViewerComposite.setLayout((Layout)new FillLayout());
        this.sourceViewerComposite.setLayoutData((Object)svcData);
        this.criticalityFormulaEditor.createPartControl(this.sourceViewerComposite);
        this.criticalityFormula.setVisible(false);
        this.sourceViewerComposite.setVisible(false);
        this.criticalityFormulaEditor.getAdaptedSourceViewer().setEditable(true);
        ((JSCompilationUnitEditor.AdaptedSourceViewer)this.criticalityFormulaEditor.getAdaptedSourceViewer()).setAutoCompletion(true);
        this.sourceViewerComposite.setEnabled(true);
        this.criticalityFormula.setVisible(true);
        this.sourceViewerComposite.setVisible(true);
        return composite;
    }
}

