/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.properties;

import java.util.List;
import org.eclipse.stardust.model.xpdl.carnot.ActivityType;
import org.eclipse.stardust.model.xpdl.carnot.IExtensibleElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelElementNodeSymbol;
import org.eclipse.stardust.model.xpdl.carnot.ProcessDefinitionType;
import org.eclipse.stardust.model.xpdl.carnot.TransitionType;
import org.eclipse.stardust.model.xpdl.carnot.util.ActivityUtil;
import org.eclipse.stardust.model.xpdl.carnot.util.AttributeUtil;
import org.eclipse.stardust.model.xpdl.carnot.util.ModelUtils;
import org.eclipse.stardust.modeling.common.ui.jface.utils.FormBuilder;
import org.eclipse.stardust.modeling.core.Diagram_Messages;
import org.eclipse.stardust.modeling.core.editors.ui.CarnotPreferenceNode;
import org.eclipse.stardust.modeling.core.properties.ActivityParticipantPropertyPage;
import org.eclipse.stardust.modeling.core.properties.ActivityQualityControlCodesPropertyPage;
import org.eclipse.stardust.modeling.core.properties.ActivityQualityControlPropertyPage;
import org.eclipse.stardust.modeling.core.properties.IdentifiablePropertyPage;
import org.eclipse.stardust.modeling.core.spi.ConfigurationElement;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;

public class ActivityGeneralPropertyPage
extends IdentifiablePropertyPage {
    private ConfigurationElement performer;
    private ConfigurationElement qualityControl;
    private ConfigurationElement qualityControlCodes;
    private Button abortCheck;
    private Button hibernateCheck;
    private Button relocateSourceCheck;
    private Button relocateTargetCheck;

    @Override
    public void loadFieldsFromElement(IModelElementNodeSymbol symbol, IModelElement element) {
        super.loadFieldsFromElement(symbol, element);
        ActivityType activity = (ActivityType)element;
        switch (activity.getImplementation()) {
            case MANUAL_LITERAL: 
            case APPLICATION_LITERAL: {
                this.setButtonState(this.abortCheck, true, activity.isAllowsAbortByPerformer());
                this.setButtonState(this.relocateSourceCheck, true, AttributeUtil.getBooleanValue((IExtensibleElement)activity, (String)"carnot:engine:relocate:source"));
                break;
            }
            default: {
                this.setButtonState(this.abortCheck, false, false);
                this.setButtonState(this.relocateSourceCheck, false, false);
            }
        }
        this.setButtonState(this.relocateTargetCheck, true, AttributeUtil.getBooleanValue((IExtensibleElement)activity, (String)"carnot:engine:relocate:target"));
        this.hibernateCheck.setSelection(activity.isHibernateOnCreation());
        if (ActivityUtil.isInteractive((ActivityType)activity) && this.performer == null) {
            this.performer = ConfigurationElement.createPageConfiguration("_cwm_participant_", ActivityParticipantPropertyPage.PARTICIPANT_LABEL, "icons/full/obj16/role.gif", ActivityParticipantPropertyPage.class.getName(), "core");
            this.addNodeTo(null, new CarnotPreferenceNode(this.performer, this.getElement(), 2), null);
            this.refreshTree();
        }
        if (ActivityUtil.isInteractive((ActivityType)activity)) {
            if (this.qualityControl == null) {
                this.qualityControl = ConfigurationElement.createPageConfiguration("_cwm_quality_control_", ActivityQualityControlPropertyPage.QUALITY_CONTROL_LABEL, "icons/full/obj16/activity.gif", ActivityQualityControlPropertyPage.class.getName(), "core");
                this.addNodeTo(null, new CarnotPreferenceNode(this.qualityControl, this.getElement(), 2), null);
                this.refreshTree();
            }
            if (this.qualityControlCodes == null) {
                this.qualityControlCodes = ConfigurationElement.createPageConfiguration("_cwm_quality_control_codes_", ActivityQualityControlCodesPropertyPage.QUALITY_CONTROL_CODES_LABEL, "icons/full/obj16/activity.gif", ActivityQualityControlCodesPropertyPage.class.getName(), "core");
                this.addNodeTo(null, new CarnotPreferenceNode(this.qualityControlCodes, this.getElement(), 2), null);
                this.refreshTree();
            }
        }
    }

    private void setButtonState(Button button, boolean enabled, boolean selected) {
        button.setEnabled(enabled);
        button.setSelection(selected);
    }

    @Override
    public void loadElementFromFields(IModelElementNodeSymbol symbol, IModelElement element) {
        super.loadElementFromFields(symbol, element);
        ActivityType activity = (ActivityType)element;
        switch (activity.getImplementation()) {
            case MANUAL_LITERAL: 
            case APPLICATION_LITERAL: {
                activity.setAllowsAbortByPerformer(this.abortCheck.getSelection());
                AttributeUtil.setBooleanAttribute((IExtensibleElement)activity, (String)"carnot:engine:relocate:source", (Boolean)this.relocateSourceCheck.getSelection());
                break;
            }
            default: {
                activity.unsetAllowsAbortByPerformer();
                AttributeUtil.setBooleanAttribute((IExtensibleElement)activity, (String)"carnot:engine:relocate:source", null);
            }
        }
        AttributeUtil.setBooleanAttribute((IExtensibleElement)activity, (String)"carnot:engine:relocate:target", (Boolean)(this.relocateTargetCheck.getSelection() ? Boolean.TRUE : null));
        activity.setHibernateOnCreation(this.hibernateCheck.getSelection());
        this.updateRelocateTransition((ProcessDefinitionType)activity.eContainer());
    }

    private void updateRelocateTransition(ProcessDefinitionType process) {
        boolean supportsRelocation = false;
        for (ActivityType activity : process.getActivity()) {
            if (!AttributeUtil.getBooleanValue((IExtensibleElement)activity, (String)"carnot:engine:relocate:source") && !AttributeUtil.getBooleanValue((IExtensibleElement)activity, (String)"carnot:engine:relocate:target")) continue;
            supportsRelocation = true;
            break;
        }
        TransitionType relocationTransition = (TransitionType)ModelUtils.findElementById((List)process.getTransition(), (String)"__internal_relocate_transition__");
        if (!supportsRelocation && relocationTransition != null) {
            process.getTransition().remove((Object)relocationTransition);
        }
    }

    @Override
    public void contributeExtraControls(Composite composite) {
        super.contributeExtraControls(composite);
        Composite panel = FormBuilder.createComposite((Composite)composite, (int)2, (int)2);
        GridLayout grid = (GridLayout)panel.getLayout();
        grid.makeColumnsEqualWidth = true;
        grid.marginWidth = 0;
        grid.marginHeight = 0;
        this.abortCheck = FormBuilder.createCheckBox((Composite)panel, (String)Diagram_Messages.CHECKBOX_AllowsAbortByParticipant, (GridData)new GridData(16384, 0x1000000, true, false));
        this.relocateSourceCheck = FormBuilder.createCheckBox((Composite)panel, (String)Diagram_Messages.LBL_SUPPORTS_RELOCATION, (GridData)new GridData(16384, 0x1000000, true, false));
        this.hibernateCheck = FormBuilder.createCheckBox((Composite)panel, (String)Diagram_Messages.CHECKBOX_HibernateInitially, (GridData)new GridData(16384, 0x1000000, true, false));
        this.relocateTargetCheck = FormBuilder.createCheckBox((Composite)panel, (String)Diagram_Messages.LBL_IS_RELOCATION_TARGET, (GridData)new GridData(16384, 0x1000000, true, false));
    }
}

