/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.properties;

import com.gface.date.DatePickerCombo;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gef.EditPart;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.stardust.common.CollectionUtils;
import org.eclipse.stardust.common.StringUtils;
import org.eclipse.stardust.engine.core.pojo.data.Type;
import org.eclipse.stardust.model.xpdl.carnot.AccessPointType;
import org.eclipse.stardust.model.xpdl.carnot.ActivityImplementationType;
import org.eclipse.stardust.model.xpdl.carnot.ActivityType;
import org.eclipse.stardust.model.xpdl.carnot.ApplicationContextTypeType;
import org.eclipse.stardust.model.xpdl.carnot.ApplicationType;
import org.eclipse.stardust.model.xpdl.carnot.CarnotWorkflowModelPackage;
import org.eclipse.stardust.model.xpdl.carnot.ContextType;
import org.eclipse.stardust.model.xpdl.carnot.DataMappingConnectionType;
import org.eclipse.stardust.model.xpdl.carnot.DataMappingType;
import org.eclipse.stardust.model.xpdl.carnot.DataSymbolType;
import org.eclipse.stardust.model.xpdl.carnot.DataType;
import org.eclipse.stardust.model.xpdl.carnot.DirectionType;
import org.eclipse.stardust.model.xpdl.carnot.IModelElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelElementNodeSymbol;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.model.xpdl.carnot.util.AccessPointUtil;
import org.eclipse.stardust.model.xpdl.carnot.util.ActivityUtil;
import org.eclipse.stardust.model.xpdl.carnot.util.ModelUtils;
import org.eclipse.stardust.model.xpdl.util.NameIdUtils;
import org.eclipse.stardust.modeling.common.ui.jface.databinding.AbstractWidgetAdapter;
import org.eclipse.stardust.modeling.common.ui.jface.databinding.BindingManager;
import org.eclipse.stardust.modeling.common.ui.jface.databinding.EFeatureAdapter;
import org.eclipse.stardust.modeling.common.ui.jface.databinding.EObjectAdapter;
import org.eclipse.stardust.modeling.common.ui.jface.databinding.IBindingMediator;
import org.eclipse.stardust.modeling.common.ui.jface.databinding.IModelAdapter;
import org.eclipse.stardust.modeling.common.ui.jface.databinding.IWidgetAdapter;
import org.eclipse.stardust.modeling.common.ui.jface.databinding.SwtButtonAdapter;
import org.eclipse.stardust.modeling.common.ui.jface.utils.FormBuilder;
import org.eclipse.stardust.modeling.common.ui.jface.utils.LabeledText;
import org.eclipse.stardust.modeling.common.ui.jface.utils.LabeledViewer;
import org.eclipse.stardust.modeling.common.ui.jface.widgets.LabelWithStatus;
import org.eclipse.stardust.modeling.core.Diagram_Messages;
import org.eclipse.stardust.modeling.core.Verifier;
import org.eclipse.stardust.modeling.core.VerifierFactory;
import org.eclipse.stardust.modeling.core.editors.ui.AccessPathBrowserComposite;
import org.eclipse.stardust.modeling.core.editors.ui.EObjectLabelProvider;
import org.eclipse.stardust.modeling.core.editors.ui.SwtDatePickerAdapter;
import org.eclipse.stardust.modeling.core.editors.ui.SwtVerifierTextAdapter;
import org.eclipse.stardust.modeling.core.properties.AbstractModelElementPropertyPage;
import org.eclipse.stardust.modeling.core.properties.IButtonManager;
import org.eclipse.stardust.modeling.core.ui.Data2DataPathModelAdapter2;
import org.eclipse.stardust.modeling.core.ui.Data2DataPathWidgetAdapter2;
import org.eclipse.stardust.modeling.core.ui.DataMappingModelAdapter;
import org.eclipse.stardust.modeling.core.ui.DatePickerComposite;
import org.eclipse.stardust.modeling.core.ui.PrimitiveDataWidgetAdapter;
import org.eclipse.stardust.modeling.core.utils.GenericUtils;
import org.eclipse.stardust.modeling.core.utils.WidgetBindingManager;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class DataMappingPropertyPage
extends AbstractModelElementPropertyPage {
    private static final Type[] TYPES = DataMappingPropertyPage.fetchTypes();
    protected LabeledText txtId;
    protected LabeledText txtName;
    private LabelWithStatus dataLabel;
    private ComboViewer dataText;
    private LabelWithStatus dataPathLabel;
    private AccessPathBrowserComposite dataPathBrowser;
    private LabelWithStatus apLabel;
    private ComboViewer accessPointText;
    private LabelWithStatus accessPathLabel;
    private AccessPathBrowserComposite accessPathBrowser;
    private Button[] buttons;
    private WidgetBindingManager binding;
    private List<AccessPointType> accessPoints = CollectionUtils.newList();
    private ModelType model;
    private ActivityType activity;
    private DataMappingType dataMapping;
    private DirectionType direction;
    private String dataMappingContext;
    private Button isConstantStateButton;
    private Button isDataStateButton;
    private Composite stackLayoutComposite;
    private StackLayout stackLayout;
    private Group dataGroup;
    private Group constantGroup;
    private ComboViewer typeViewer;
    private Composite valueComposite;
    private Map<Type, Object> valueControlsMap = CollectionUtils.newHashMap();
    private ModifyListener listener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            if (GenericUtils.getAutoIdValue()) {
                String computedId = NameIdUtils.createIdFromName(null, (EObject)DataMappingPropertyPage.this.getModelElement());
                DataMappingPropertyPage.this.txtId.getText().setText(computedId);
            }
        }
    };

    @Override
    public void loadFieldsFromElement(IModelElementNodeSymbol symbol, IModelElement element) {
        this.txtName.getText().removeModifyListener(this.listener);
        this.binding = this.getWidgetBindingManager();
        this.dataMapping = (DataMappingType)element;
        this.model = ModelUtils.findContainingModel((EObject)this.dataMapping);
        ApplicationContextTypeType ctxType = (ApplicationContextTypeType)ModelUtils.findIdentifiableElement((EObject)this.model, (EStructuralFeature)CarnotWorkflowModelPackage.eINSTANCE.getModelType_ApplicationContextType(), (String)this.dataMapping.getContext());
        this.dataText.getCombo().setEnabled(this.getData() == null);
        this.dataMappingContext = this.dataMapping.getContext();
        this.binding.getModelBindingManager().bind((IModelAdapter)new Data2DataPathModelAdapter2(this.model, this.model.getData()), (IWidgetAdapter)new Data2DataPathWidgetAdapter2((StructuredViewer)this.dataText, this.dataPathBrowser, this.dataMapping.getDirection()));
        this.binding.bind(new LabeledViewer((StructuredViewer)this.dataText, this.dataLabel), (EObject)this.dataMapping, (EStructuralFeature)CarnotWorkflowModelPackage.eINSTANCE.getDataMappingType_Data());
        this.binding.getModelBindingManager().bind((EObject)this.dataMapping, (EStructuralFeature)CarnotWorkflowModelPackage.eINSTANCE.getDataMappingType_Data(), (IWidgetAdapter)new AbstractWidgetAdapter(){

            public void updateVisuals(Object value) {
                ActivityType activity = (ActivityType)DataMappingPropertyPage.this.dataMapping.eContainer();
                if (activity != null) {
                    ActivityUtil.updateConnections((ActivityType)activity);
                }
            }
        });
        this.binding.bind(new LabeledText(this.dataPathBrowser.getMethodText(), this.dataPathLabel), (EObject)this.dataMapping, (EStructuralFeature)CarnotWorkflowModelPackage.eINSTANCE.getDataMappingType_DataPath());
        boolean hasApplicationPath = ctxType.isHasApplicationPath();
        this.activity = (ActivityType)this.dataMapping.eContainer();
        if (hasApplicationPath) {
            this.accessPointText.getCombo().setEnabled(true);
            this.updateAccessPoints();
            this.direction = this.dataMapping.getDirection();
            if (DirectionType.IN_LITERAL.equals((Object)this.direction)) {
                this.direction = DirectionType.OUT_LITERAL;
            } else if (DirectionType.OUT_LITERAL.equals((Object)this.direction)) {
                this.direction = DirectionType.IN_LITERAL;
            }
            this.binding.getModelBindingManager().bind((IModelAdapter)new Data2DataPathModelAdapter2(this.activity, this.accessPoints), (IWidgetAdapter)new Data2DataPathWidgetAdapter2((StructuredViewer)this.accessPointText, this.accessPathBrowser, this.direction));
            this.binding.bind(new LabeledViewer((StructuredViewer)this.accessPointText, this.apLabel), (EObject)this.dataMapping, (EStructuralFeature)CarnotWorkflowModelPackage.eINSTANCE.getDataMappingType_ApplicationAccessPoint(), new EFeatureAdapter(){

                public Object toModel(EObjectAdapter binding, Object value) {
                    return value == null ? null : ((AccessPointType)value).getId();
                }

                public Object fromModel(EObjectAdapter binding, Object value) {
                    for (AccessPointType ap : DataMappingPropertyPage.this.accessPoints) {
                        if (!ap.getId().equals(value)) continue;
                        return ap;
                    }
                    return null;
                }
            });
            this.binding.bind(new LabeledText(this.accessPathBrowser.getMethodText(), this.accessPathLabel), (EObject)this.dataMapping, (EStructuralFeature)CarnotWorkflowModelPackage.eINSTANCE.getDataMappingType_ApplicationPath());
        } else if (ActivityImplementationType.ROUTE_LITERAL.equals((Object)this.activity.getImplementation())) {
            this.accessPointText.getCombo().setEnabled(!AccessPointUtil.isIn((DirectionType)this.dataMapping.getDirection()));
            this.accessPathBrowser.setAccessPoint(null, null);
            if (AccessPointUtil.isIn((DirectionType)this.dataMapping.getDirection())) {
                this.txtId.getText().addModifyListener(new ModifyListener(){

                    public void modifyText(ModifyEvent e) {
                        String value = DataMappingPropertyPage.this.dataMapping.getApplicationAccessPoint();
                        DataMappingPropertyPage.this.dataMapping.setApplicationAccessPoint(DataMappingPropertyPage.this.txtId.getText().getText());
                        DataMappingPropertyPage.this.accessPointText.getCombo().setText(DataMappingPropertyPage.this.txtId.getText().getText());
                        List dataMappings = ActivityUtil.getDataMappings((ActivityType)DataMappingPropertyPage.this.activity, (!AccessPointUtil.isIn((DirectionType)DataMappingPropertyPage.this.dataMapping.getDirection()) ? 1 : 0) != 0, (String)"default");
                        for (DataMappingType ap : dataMappings) {
                            if (ap.getApplicationAccessPoint() == null || !ap.getApplicationAccessPoint().equals(value)) continue;
                            ap.setApplicationAccessPoint(DataMappingPropertyPage.this.txtId.getText().getText());
                        }
                    }
                });
            } else {
                this.binding.getModelBindingManager().bind((EObject)this.activity, (EStructuralFeature)CarnotWorkflowModelPackage.eINSTANCE.getActivityType_DataMapping(), (IWidgetAdapter)new AbstractWidgetAdapter(){

                    public void updateVisuals(Object value) {
                        List dataMappings = ActivityUtil.getDataMappings((ActivityType)DataMappingPropertyPage.this.activity, (!AccessPointUtil.isIn((DirectionType)DataMappingPropertyPage.this.dataMapping.getDirection()) ? 1 : 0) != 0, (String)"default");
                        ISelection selection = DataMappingPropertyPage.this.accessPointText.getSelection();
                        if (!DataMappingPropertyPage.this.accessPointText.getCombo().isDisposed()) {
                            if (DataMappingPropertyPage.this.accessPointText.getContentProvider() == null) {
                                DataMappingPropertyPage.this.accessPointText.setContentProvider((IContentProvider)new ArrayContentProvider());
                            }
                            DataMappingPropertyPage.this.accessPointText.setInput((Object)dataMappings);
                            DataMappingPropertyPage.this.accessPointText.setSelection(selection);
                        }
                    }
                });
                this.binding.bind(new LabeledViewer((StructuredViewer)this.accessPointText, this.apLabel), (EObject)this.dataMapping, (EStructuralFeature)CarnotWorkflowModelPackage.eINSTANCE.getDataMappingType_ApplicationAccessPoint(), new EFeatureAdapter(){

                    public Object toModel(EObjectAdapter binding, Object value) {
                        if (value instanceof DataMappingType) {
                            return ((DataMappingType)value).getId();
                        }
                        return null;
                    }

                    public Object fromModel(EObjectAdapter binding, Object value) {
                        List dataMappings = ActivityUtil.getDataMappings((ActivityType)DataMappingPropertyPage.this.activity, (!AccessPointUtil.isIn((DirectionType)DataMappingPropertyPage.this.dataMapping.getDirection()) ? 1 : 0) != 0, (String)"default");
                        for (DataMappingType ap : dataMappings) {
                            if (!ap.getId().equals(value)) continue;
                            return ap;
                        }
                        return null;
                    }
                });
            }
        } else {
            this.accessPointText.getCombo().setEnabled(false);
            this.accessPointText.setSelection(null);
            this.accessPathBrowser.setAccessPoint(null, null);
        }
        if (StringUtils.isEmpty((String)this.dataMapping.getName())) {
            this.dataMapping.setName(this.dataMapping.getId());
        }
        this.binding.bind(this.txtName, (EObject)element, (EStructuralFeature)CarnotWorkflowModelPackage.eINSTANCE.getIIdentifiableElement_Name());
        this.txtName.getText().addModifyListener(this.listener);
        this.binding.bind(this.txtId, (EObject)element, (EStructuralFeature)CarnotWorkflowModelPackage.eINSTANCE.getIIdentifiableElement_Id());
        if (DirectionType.IN_LITERAL.equals((Object)this.dataMapping.getDirection()) && "default".equals(this.dataMappingContext)) {
            BindingManager mgr = this.binding.getModelBindingManager();
            mgr.bind((IModelAdapter)new DataMappingModelAdapter(ModelUtils.findContainingModel((EObject)element), Arrays.asList(TYPES), (DataMappingType)element), (IWidgetAdapter)new PrimitiveDataWidgetAdapter(this.typeViewer, this.valueComposite, this.valueControlsMap){

                public void updateModel(Object value) {
                    super.updateModel(value);
                }
            });
            int i = 0;
            while (i < TYPES.length) {
                Object control = this.valueControlsMap.get(TYPES[i]);
                if (TYPES[i].equals((Object)Type.Timestamp) || TYPES[i].equals((Object)Type.Calendar)) {
                    Button resetBtn = null;
                    DatePickerCombo datePickerCombo = ((DatePickerComposite)control).getCalendarCombo();
                    resetBtn = ((DatePickerComposite)control).getResetBtn();
                    mgr.bind((IModelAdapter)new DataMappingModelAdapter(ModelUtils.findContainingModel((EObject)element), TYPES[i], (DataMappingType)element), (IWidgetAdapter)this.getSwtDatePickerAdapter(datePickerCombo, resetBtn));
                } else if (TYPES[i].equals((Object)Type.Boolean)) {
                    Button button = (Button)control;
                    mgr.bind((IModelAdapter)new DataMappingModelAdapter(ModelUtils.findContainingModel((EObject)element), TYPES[i], (DataMappingType)element), (IWidgetAdapter)this.getSwtButtonAdapter(button));
                } else {
                    Type type = TYPES[i];
                    Text text = (Text)control;
                    mgr.bind((IModelAdapter)new DataMappingModelAdapter(ModelUtils.findContainingModel((EObject)element), TYPES[i], (DataMappingType)element), (IWidgetAdapter)this.getSwtVerifierTextAdapter(type, text));
                }
                ++i;
            }
            if (this.dataMapping.getData() != null) {
                this.isConstantStateButton.setSelection(false);
                this.isDataStateButton.setSelection(true);
                this.constantGroup.setVisible(false);
                this.dataGroup.setVisible(true);
                this.stackLayout.topControl = this.dataGroup;
            } else if (this.dataMapping.getData() == null && this.dataMapping.getDataPath() != null && this.dataMapping.getDataPath().startsWith("(")) {
                this.isConstantStateButton.setSelection(true);
                this.isDataStateButton.setSelection(false);
                this.dataGroup.setVisible(false);
                this.constantGroup.setVisible(true);
                this.stackLayout.topControl = this.constantGroup;
                String constantString = this.dataMapping.getDataPath();
                Object type = this.getType(constantString, false);
                this.typeViewer.setSelection((ISelection)new StructuredSelection(type));
                String constantValue = (String)this.getType(constantString, true);
                Object control = this.valueControlsMap.get(type);
                if (type.equals(Type.Timestamp) || type.equals(Type.Calendar)) {
                    Date dateValue = new Date();
                    try {
                        Date.parse(constantValue);
                    }
                    catch (Exception exception) {}
                    DatePickerCombo datePickerCombo = ((DatePickerComposite)control).getCalendarCombo();
                    datePickerCombo.setDate(dateValue);
                } else if (type.equals(Type.Boolean)) {
                    boolean booleanValue = false;
                    try {
                        booleanValue = Boolean.parseBoolean(constantValue);
                    }
                    catch (Exception exception) {}
                    Button button = (Button)control;
                    button.setSelection(booleanValue);
                } else {
                    if (type.equals(Type.Double) || type.equals(Type.Float)) {
                        constantValue = constantValue.replace(".", ",");
                    }
                    Text text = (Text)control;
                    text.setText(constantValue != null ? constantValue : "");
                }
            } else {
                this.dataGroup.setVisible(false);
                this.constantGroup.setVisible(false);
            }
            this.stackLayoutComposite.layout();
        } else {
            this.isConstantStateButton.setVisible(false);
            this.isDataStateButton.setVisible(false);
            this.constantGroup.setVisible(false);
            this.dataGroup.setVisible(true);
            this.stackLayout.topControl = this.dataGroup;
            this.stackLayoutComposite.layout();
        }
    }

    private SwtVerifierTextAdapter getSwtVerifierTextAdapter(final Type type, Text text) {
        return new SwtVerifierTextAdapter(text){

            public void updateControl(Object value) {
                Type selectedType = (Type)((IStructuredSelection)DataMappingPropertyPage.this.typeViewer.getSelection()).getFirstElement();
                if (type.equals((Object)selectedType)) {
                    super.updateControl(value);
                }
            }
        };
    }

    private SwtButtonAdapter getSwtButtonAdapter(Button b) {
        return new SwtButtonAdapter(b){

            public void bind(IBindingMediator manager) {
                super.bind(manager);
                final Button button = (Button)this.getWidget();
                button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        this.updateModel(button.getSelection() ? Boolean.TRUE.toString() : Boolean.FALSE.toString());
                    }
                });
            }

            public void updateControl(Object value) {
                Type selectedType;
                if (value != null && !(value instanceof Boolean)) {
                    Object object = value = "true".equalsIgnoreCase(value.toString()) ? Boolean.TRUE : Boolean.FALSE;
                }
                if (Type.Boolean.equals((Object)(selectedType = (Type)((IStructuredSelection)DataMappingPropertyPage.this.typeViewer.getSelection()).getFirstElement()))) {
                    super.updateControl(value);
                }
            }
        };
    }

    private SwtDatePickerAdapter getSwtDatePickerAdapter(DatePickerCombo datePickerCombo, Button resetBtn) {
        return new SwtDatePickerAdapter(datePickerCombo, resetBtn){

            @Override
            public void updateControl(Object value) {
                Type selectedType = (Type)((IStructuredSelection)DataMappingPropertyPage.this.typeViewer.getSelection()).getFirstElement();
                if (Type.Calendar.equals((Object)selectedType) || Type.Timestamp.equals((Object)selectedType)) {
                    super.updateControl(value);
                }
            }
        };
    }

    private void updateAccessPoints() {
        this.accessPoints.clear();
        this.accessPoints.addAll(ActivityUtil.getAccessPoints((ActivityType)this.activity, (DirectionType.IN_LITERAL == this.dataMapping.getDirection() ? 1 : 0) != 0, (String)this.dataMapping.getContext()));
    }

    private DataType getData() {
        IAdaptable element = this.getElement();
        if (element instanceof EditPart) {
            Object model = ((EditPart)element).getModel();
            if (model instanceof DataMappingConnectionType) {
                model = ((DataMappingConnectionType)model).getDataSymbol();
            }
            if (model instanceof DataSymbolType) {
                model = ((DataSymbolType)model).getData();
            }
            if (model instanceof DataType) {
                return (DataType)model;
            }
        }
        return null;
    }

    public void setVisible(boolean visible) {
        if (visible) {
            IButtonManager manager = (IButtonManager)this.getElement().getAdapter(IButtonManager.class);
            manager.updateButtons(this.getModelElement(), this.buttons);
            this.refreshAccessPoint();
        }
        super.setVisible(visible);
    }

    public void refreshAccessPoint() {
        if (this.dataMapping == null) {
            this.dataMapping = (DataMappingType)this.getModelElement();
        }
        if (!this.dataMapping.getContext().equals(this.dataMappingContext)) {
            this.loadFieldsFromElement(null, (IModelElement)this.dataMapping);
        }
        String ap = this.dataMapping.getApplicationAccessPoint();
        this.accessPointText.refresh();
        this.dataMapping.setApplicationAccessPoint(ap);
    }

    @Override
    public void contributeVerticalButtons(Composite parent) {
        IButtonManager manager = (IButtonManager)this.getElement().getAdapter(IButtonManager.class);
        this.buttons = manager.createButtons(parent);
    }

    @Override
    public void loadElementFromFields(IModelElementNodeSymbol symbol, IModelElement element) {
    }

    @Override
    public Control createBody(Composite parent) {
        Composite composite = FormBuilder.createComposite((Composite)parent, (int)2);
        this.txtName = FormBuilder.createLabeledText((Composite)composite, (String)Diagram_Messages.LB_Name);
        this.txtName.setTextLimit(80);
        this.txtId = FormBuilder.createLabeledText((Composite)composite, (String)Diagram_Messages.LB_ID);
        this.txtId.setTextLimit(80);
        boolean autoIdButtonValue = GenericUtils.getAutoIdValue();
        if (autoIdButtonValue) {
            this.txtId.getText().setEditable(false);
        }
        this.createConstantStateGroup(composite);
        this.stackLayoutComposite = new Composite(composite, 0);
        GridData gridData = new GridData(4, 0, false, false);
        gridData.horizontalSpan = 2;
        this.stackLayoutComposite.setLayoutData((Object)gridData);
        this.stackLayout = new StackLayout();
        this.stackLayoutComposite.setLayout((Layout)this.stackLayout);
        this.createDataGroup(this.stackLayoutComposite);
        this.createConstantGroup(this.stackLayoutComposite);
        return composite;
    }

    private void createConstantStateGroup(Composite composite) {
        this.isConstantStateButton = FormBuilder.createRadioButton((Composite)composite, (String)Diagram_Messages.TXT_DataMapping_Constant);
        this.isConstantStateButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (DataMappingPropertyPage.this.isConstantStateButton.getSelection()) {
                    DataMappingPropertyPage.this.resetElement();
                    DataMappingPropertyPage.this.dataGroup.setVisible(false);
                    DataMappingPropertyPage.this.constantGroup.setVisible(true);
                    ((DataMappingPropertyPage)DataMappingPropertyPage.this).stackLayout.topControl = DataMappingPropertyPage.this.constantGroup;
                    DataMappingPropertyPage.this.stackLayoutComposite.layout();
                }
            }
        });
        this.isDataStateButton = FormBuilder.createRadioButton((Composite)composite, (String)Diagram_Messages.TXT_DataMapping_DataBound);
        this.isDataStateButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (DataMappingPropertyPage.this.isDataStateButton.getSelection()) {
                    DataMappingPropertyPage.this.resetElement();
                    DataMappingPropertyPage.this.constantGroup.setVisible(false);
                    DataMappingPropertyPage.this.dataGroup.setVisible(true);
                    ((DataMappingPropertyPage)DataMappingPropertyPage.this).stackLayout.topControl = DataMappingPropertyPage.this.dataGroup;
                    DataMappingPropertyPage.this.stackLayoutComposite.layout();
                }
            }
        });
    }

    private void resetElement() {
        this.typeViewer.setSelection(null);
        int i = 0;
        while (i < TYPES.length) {
            Object control = this.valueControlsMap.get(TYPES[i]);
            if (TYPES[i].equals((Object)Type.Timestamp) || TYPES[i].equals((Object)Type.Calendar)) {
                DatePickerCombo datePickerCombo = ((DatePickerComposite)control).getCalendarCombo();
                datePickerCombo.setData(null);
            } else if (TYPES[i].equals((Object)Type.Boolean)) {
                Button button = (Button)control;
                button.setSelection(false);
            } else {
                Text text = (Text)control;
                text.setText("");
            }
            ++i;
        }
        this.dataMapping.setData(null);
        this.dataMapping.setDataPath(null);
        this.dataMapping.setApplicationPath(null);
        this.dataMapping.setApplicationAccessPoint(null);
    }

    private void createDataGroup(Composite composite) {
        this.dataGroup = FormBuilder.createGroup((Composite)composite, (String)"", (int)2);
        GridData gridDataGroup = new GridData(4, 0, false, false);
        gridDataGroup.horizontalSpan = 2;
        this.dataGroup.setLayoutData((Object)gridDataGroup);
        this.dataLabel = FormBuilder.createLabelWithRightAlignedStatus((Composite)this.dataGroup, (String)Diagram_Messages.LB_Data);
        this.dataText = new ComboViewer(FormBuilder.createCombo((Composite)this.dataGroup));
        this.dataText.setSorter(new ViewerSorter());
        this.dataText.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.dataText.setLabelProvider((IBaseLabelProvider)new EObjectLabelProvider(this.getEditor()));
        this.dataPathLabel = FormBuilder.createLabelWithRightAlignedStatus((Composite)this.dataGroup, (String)Diagram_Messages.LB_DataPath);
        this.dataPathBrowser = new AccessPathBrowserComposite(this.getEditor(), (Composite)this.dataGroup, Diagram_Messages.LB_DataPath, this.supportsPrimitiveBrowsing());
        this.apLabel = FormBuilder.createLabelWithRightAlignedStatus((Composite)this.dataGroup, (String)Diagram_Messages.LB_AccessPoint);
        this.accessPointText = new ComboViewer(FormBuilder.createCombo((Composite)this.dataGroup));
        this.accessPointText.setSorter(new ViewerSorter());
        this.accessPointText.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.accessPointText.setLabelProvider((IBaseLabelProvider)new EObjectLabelProvider(this.getEditor()));
        this.accessPathLabel = FormBuilder.createLabelWithRightAlignedStatus((Composite)this.dataGroup, (String)Diagram_Messages.LB_AccessPointPath);
        this.accessPathBrowser = new AccessPathBrowserComposite(this.getEditor(), (Composite)this.dataGroup, Diagram_Messages.LB_AccessPointPath, this.supportsPrimitiveBrowsing());
    }

    private void createConstantGroup(Composite composite) {
        this.constantGroup = FormBuilder.createGroup((Composite)composite, (String)"", (int)2);
        GridData gridDataGroup = new GridData(4, 0, false, false);
        gridDataGroup.horizontalSpan = 2;
        this.constantGroup.setLayoutData((Object)gridDataGroup);
        FormBuilder.createLabel((Composite)this.constantGroup, (String)Diagram_Messages.LB_SPI_Type);
        this.typeViewer = new ComboViewer(FormBuilder.createCombo((Composite)this.constantGroup));
        this.typeViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.typeViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object type) {
                return ((Type)type).getId();
            }
        });
        FormBuilder.createLabel((Composite)this.constantGroup, (String)Diagram_Messages.LB_DefaultValue);
        this.valueComposite = new Composite((Composite)this.constantGroup, 0);
        GridData gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        if (this.typeViewer.getCombo().getBounds().height > 0) {
            gd.heightHint = this.typeViewer.getCombo().getBounds().height;
        }
        gd.horizontalAlignment = 4;
        this.valueComposite.setLayoutData((Object)gd);
        StackLayout layout = new StackLayout();
        this.valueComposite.setLayout((Layout)layout);
        this.valueControlsMap.put(TYPES[0], this.createDatePickerComposite());
        this.valueControlsMap.put(TYPES[1], FormBuilder.createText((Composite)this.valueComposite));
        this.valueControlsMap.put(TYPES[2], this.createDatePickerComposite());
        this.valueControlsMap.put(TYPES[3], new Button(this.valueComposite, 32));
        this.valueControlsMap.put(TYPES[4], this.createVerifiedText(VerifierFactory.byteVerifier));
        this.valueControlsMap.put(TYPES[5], this.createLimitedText(1));
        this.valueControlsMap.put(TYPES[6], this.createVerifiedText(VerifierFactory.doubleVerifier));
        this.valueControlsMap.put(TYPES[7], this.createVerifiedText(VerifierFactory.floatVerifier));
        this.valueControlsMap.put(TYPES[8], this.createVerifiedText(VerifierFactory.intVerifier));
        this.valueControlsMap.put(TYPES[9], this.createVerifiedText(VerifierFactory.longVerifier));
        this.valueControlsMap.put(TYPES[10], this.createVerifiedText(VerifierFactory.shortVerifier));
    }

    private boolean supportsPrimitiveBrowsing() {
        ContextType contextType;
        ApplicationType app;
        DataMappingType dmt;
        ActivityType act;
        IModelElement modelElement;
        boolean browsePrimAllowed = true;
        if (this.getElement().getAdapter(IModelElement.class) != null && (modelElement = (IModelElement)this.getElement().getAdapter(IModelElement.class)) instanceof DataMappingType && (act = (ActivityType)(dmt = (DataMappingType)modelElement).eContainer()).getApplication() != null && (app = act.getApplication()).isInteractive() && app.getContext() != null && !app.getContext().isEmpty() && (contextType = (ContextType)app.getContext().get(0)).getType() != null && contextType.getType().getId().equalsIgnoreCase("externalWebApp")) {
            browsePrimAllowed = false;
        }
        return browsePrimAllowed;
    }

    private static Type[] fetchTypes() {
        List tmp = Type.getTypes();
        ArrayList types = CollectionUtils.newArrayList();
        for (Type type : tmp) {
            if (type.equals((Object)Type.Enumeration)) continue;
            types.add(type);
        }
        Object[] array = types.toArray(new Type[types.size()]);
        Arrays.sort(array);
        return array;
    }

    private Text createVerifiedText(Verifier verifier) {
        Text text = FormBuilder.createText((Composite)this.valueComposite);
        text.addVerifyListener((VerifyListener)verifier);
        return text;
    }

    private Text createLimitedText(int limit) {
        Text text = FormBuilder.createText((Composite)this.valueComposite);
        text.setTextLimit(limit);
        return text;
    }

    private DatePickerComposite createDatePickerComposite() {
        Composite calendarComposite = new Composite(this.valueComposite, 0);
        GridData gdCal = new GridData();
        gdCal.grabExcessHorizontalSpace = true;
        gdCal.horizontalAlignment = 4;
        calendarComposite.setLayoutData((Object)gdCal);
        GridLayout gl = new GridLayout();
        gl.numColumns = 2;
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        calendarComposite.setLayout((Layout)gl);
        GridData gdDP = new GridData();
        gdDP.grabExcessHorizontalSpace = true;
        gdDP.horizontalAlignment = 4;
        DatePickerCombo calendarCombo = new DatePickerCombo(calendarComposite, 2048);
        calendarCombo.setLayoutData((Object)gdDP);
        calendarCombo.setEditable(false);
        calendarCombo.setDateFormat((DateFormat)new SimpleDateFormat(Diagram_Messages.SIMPLE_DATE_FORMAT, Locale.GERMANY));
        Button resetButton = new Button(calendarComposite, 0);
        resetButton.setText(Diagram_Messages.BUT_RESET);
        GridData gdBtn = new GridData();
        gdBtn.grabExcessVerticalSpace = true;
        resetButton.setLayoutData((Object)gdBtn);
        DatePickerComposite datePickerComposite = new DatePickerComposite(calendarComposite, calendarCombo, resetButton);
        return datePickerComposite;
    }

    private Object getType(String path, boolean returnValue) {
        if (StringUtils.isEmpty((String)path)) {
            return null;
        }
        String tmpType = null;
        String constantValue = null;
        if ((path = path.trim()).startsWith("(")) {
            path = path.substring(1, path.length());
            String[] split = path.split("\\)");
            tmpType = split[0];
            if (split.length > 1) {
                constantValue = split[1];
                constantValue = constantValue.trim();
            }
            if (returnValue) {
                return constantValue;
            }
            List tmp = Type.getTypes();
            for (Type type : tmp) {
                if (!type.getId().equals(tmpType)) continue;
                return type;
            }
        }
        return null;
    }
}

