/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.properties;

import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.stardust.common.StringUtils;
import org.eclipse.stardust.model.xpdl.carnot.AbstractEventAction;
import org.eclipse.stardust.model.xpdl.carnot.ActivityType;
import org.eclipse.stardust.model.xpdl.carnot.BindActionType;
import org.eclipse.stardust.model.xpdl.carnot.CarnotWorkflowModelFactory;
import org.eclipse.stardust.model.xpdl.carnot.EventActionType;
import org.eclipse.stardust.model.xpdl.carnot.EventConditionTypeType;
import org.eclipse.stardust.model.xpdl.carnot.EventHandlerType;
import org.eclipse.stardust.model.xpdl.carnot.IEventHandlerOwner;
import org.eclipse.stardust.model.xpdl.carnot.IIdentifiableModelElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelElement;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.model.xpdl.carnot.ProcessDefinitionType;
import org.eclipse.stardust.model.xpdl.carnot.UnbindActionType;
import org.eclipse.stardust.model.xpdl.carnot.util.ActionTypeUtil;
import org.eclipse.stardust.model.xpdl.carnot.util.EventHandlingUtils;
import org.eclipse.stardust.model.xpdl.carnot.util.ModelUtils;
import org.eclipse.stardust.modeling.common.ui.IdFactory;
import org.eclipse.stardust.modeling.common.ui.jface.utils.FormBuilder;
import org.eclipse.stardust.modeling.core.Diagram_Messages;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.commands.CreateMetaTypeCommand;
import org.eclipse.stardust.modeling.core.properties.AbstractModelElementPropertyPage;
import org.eclipse.stardust.modeling.core.properties.ActionTypePropertyPage;
import org.eclipse.stardust.modeling.core.properties.IButtonManager;
import org.eclipse.stardust.modeling.core.spi.ConfigurationElement;
import org.eclipse.stardust.modeling.core.utils.MetaTypeModelingUtils;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;

public class EventHandlingButtonController
implements IButtonManager {
    public static final int ADD_EVENT_ACTION_BUTTON = 4;
    public static final int ADD_BIND_ACTION_BUTTON = 5;
    public static final int ADD_UNBIND_ACTION_BUTTON = 6;
    private Object selection;
    private final AbstractModelElementPropertyPage rootPage;

    public EventHandlingButtonController(AbstractModelElementPropertyPage rootPage) {
        this.rootPage = rootPage;
    }

    @Override
    public Object getSelection() {
        return this.selection == null ? null : this.selection;
    }

    @Override
    public void updateButtons(Object selection, Button[] buttons) {
        int i = 0;
        while (i < buttons.length) {
            if (buttons[i].isDisposed()) {
                return;
            }
            ++i;
        }
        this.selection = selection;
        buttons[0].setEnabled(selection instanceof ConfigurationElement || selection instanceof EventHandlerType || selection instanceof AbstractEventAction);
        buttons[1].setEnabled(selection != null && !(selection instanceof EventConditionTypeType) && !(selection instanceof ConfigurationElement));
        EventHandlerType handler = this.getEventHandlerFromSelection(selection);
        if (handler != null && !StringUtils.isEmpty((String)handler.getId())) {
            EventConditionTypeType type = handler.getType();
            boolean process = handler.eContainer() instanceof ProcessDefinitionType;
            boolean activity = handler.eContainer() instanceof ActivityType;
            buttons[4].setEnabled(!ActionTypeUtil.getSupportedActionTypes((EventConditionTypeType)type, (boolean)process, (boolean)activity, (String)"event").isEmpty());
            buttons[5].setEnabled(!ActionTypeUtil.getSupportedActionTypes((EventConditionTypeType)type, (boolean)process, (boolean)activity, (String)"bind").isEmpty());
            buttons[6].setEnabled(!ActionTypeUtil.getSupportedActionTypes((EventConditionTypeType)type, (boolean)process, (boolean)activity, (String)"unbind").isEmpty());
        } else {
            buttons[4].setEnabled(false);
            buttons[5].setEnabled(false);
            buttons[6].setEnabled(false);
        }
        buttons[2].setEnabled(this.isMoveUpAllowed(selection));
        buttons[3].setEnabled(this.isMoveDownAllowed(selection));
    }

    @Override
    public Button[] createButtons(Composite parent) {
        final Button[] buttons = new Button[7];
        buttons[0] = FormBuilder.createButton((Composite)parent, (String)Diagram_Messages.B_Add, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EventHandlingButtonController.this.performAdd(buttons);
            }
        });
        buttons[4] = FormBuilder.createButton((Composite)parent, (String)Diagram_Messages.B_AddEventAction, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EventHandlingButtonController.this.performAddEventAction(buttons);
            }
        });
        buttons[5] = FormBuilder.createButton((Composite)parent, (String)Diagram_Messages.B_AddBindAction, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EventHandlingButtonController.this.performAddBindAction(buttons);
            }
        });
        buttons[6] = FormBuilder.createButton((Composite)parent, (String)Diagram_Messages.B_AddUnbindAction, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EventHandlingButtonController.this.performAddUnbindAction(buttons);
            }
        });
        buttons[1] = FormBuilder.createButton((Composite)parent, (String)Diagram_Messages.B_Delete, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EventHandlingButtonController.this.performDelete(buttons);
            }
        });
        buttons[2] = FormBuilder.createButton((Composite)parent, (String)Diagram_Messages.B_MoveUp, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EventHandlingButtonController.this.performUp(buttons);
            }
        });
        buttons[3] = FormBuilder.createButton((Composite)parent, (String)Diagram_Messages.B_MoveDown, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EventHandlingButtonController.this.performDown(buttons);
            }
        });
        return buttons;
    }

    private void performAdd(Button[] buttons) {
        IConfigurationElement config = this.getConfigurationFromSelection();
        if (config != null) {
            EventHandlerType handler = this.createEventHandler(config);
            this.updateButtons(handler, buttons);
            this.rootPage.selectPageForObject(handler);
        }
    }

    private void performDelete(Button[] buttons) {
        Object selection = this.getSelection();
        if (selection instanceof EventHandlerType) {
            EventHandlerType handler = (EventHandlerType)selection;
            this.getEventHandlers().remove(handler);
            this.updateButtons(null, buttons);
            this.rootPage.selectPage("_cwm_eventhandling_");
        } else if (ActionTypeUtil.isAction((Object)selection)) {
            this.removeAction((IIdentifiableModelElement)selection);
            this.updateButtons(null, buttons);
            this.rootPage.selectPage("_cwm_eventhandling_");
        }
    }

    protected void performAddEventAction(Button[] buttons) {
        EventHandlerType eventHandlerType = this.getEventHandlerFromSelection(this.getSelection());
        Object action = this.addAction(buttons, Diagram_Messages.ACT_EventAction, Diagram_Messages.ACT_DESC_EventAction, (List)eventHandlerType.getEventAction(), (IIdentifiableModelElement)CarnotWorkflowModelFactory.eINSTANCE.createEventActionType(), eventHandlerType);
        this.rootPage.selectPageForObject(action);
    }

    protected void performAddBindAction(Button[] buttons) {
        EventHandlerType eventHandlerType = this.getEventHandlerFromSelection(this.getSelection());
        Object action = this.addAction(buttons, Diagram_Messages.ACT_BindAction, Diagram_Messages.ACT_DESC_BindAction, (List)eventHandlerType.getBindAction(), (IIdentifiableModelElement)CarnotWorkflowModelFactory.eINSTANCE.createBindActionType(), eventHandlerType);
        this.rootPage.selectPageForObject(action);
    }

    protected void performAddUnbindAction(Button[] buttons) {
        EventHandlerType eventHandlerType = this.getEventHandlerFromSelection(this.getSelection());
        Object action = this.addAction(buttons, Diagram_Messages.ACT_UnbindAction, Diagram_Messages.ACT_DESC_UnbindAction, (List)eventHandlerType.getUnbindAction(), (IIdentifiableModelElement)CarnotWorkflowModelFactory.eINSTANCE.createUnbindActionType(), eventHandlerType);
        this.rootPage.selectPageForObject(action);
    }

    private void performUp(Button[] buttons) {
        Object element = this.getSelection();
        List list = this.getContainmentList(element);
        if (list != null) {
            this.moveUp(list, element);
            this.updateButtons(element, buttons);
            this.updateButtons(element, buttons);
        }
    }

    private void performDown(Button[] buttons) {
        Object element = this.getSelection();
        List list = this.getContainmentList(element);
        if (list != null) {
            this.moveDown(list, element);
            this.updateButtons(element, buttons);
            this.updateButtons(element, buttons);
        }
    }

    private void moveUp(List list, Object element) {
        int index = list.indexOf(element);
        if (list instanceof EList) {
            ((EList)list).move(index - 1, element);
        } else {
            list.remove(element);
            list.add(index - 1, element);
        }
    }

    private void moveDown(List list, Object element) {
        int index = list.indexOf(element);
        if (list instanceof EList) {
            ((EList)list).move(index + 1, element);
        } else {
            list.remove(element);
            list.add(index + 1, element);
        }
    }

    private List getContainmentList(Object element) {
        List list = null;
        if (element instanceof EventHandlerType) {
            list = this.getEventHandlers();
        } else if (element instanceof EventActionType) {
            list = ModelUtils.findContainingEventHandlerType((EObject)((EObject)element)).getEventAction();
        } else if (element instanceof BindActionType) {
            list = ModelUtils.findContainingEventHandlerType((EObject)((EObject)element)).getBindAction();
        } else if (element instanceof UnbindActionType) {
            list = ModelUtils.findContainingEventHandlerType((EObject)((EObject)element)).getUnbindAction();
        }
        return list;
    }

    private List getEventHandlers() {
        IModelElement model = (IModelElement)this.rootPage.getModelElement();
        if (model instanceof EventHandlerType) {
            return Collections.singletonList(model);
        }
        if (model instanceof IEventHandlerOwner) {
            return ((IEventHandlerOwner)model).getEventHandler();
        }
        return null;
    }

    private Object addAction(Button[] buttons, String id, String name, List list, IIdentifiableModelElement actionType, EventHandlerType eventHandlerType) {
        IdFactory idFactory = new IdFactory(id, name);
        idFactory.computeNames(list);
        actionType.setId(idFactory.getId());
        actionType.setName(idFactory.getName());
        ActionTypePropertyPage.setActionType(ModelUtils.findContainingModel((EObject)eventHandlerType), actionType, ActionTypeUtil.findFirstActionType((EventHandlerType)eventHandlerType, (String)ActionTypeUtil.getContext((IModelElement)actionType)));
        list.add(actionType);
        this.updateButtons(actionType, buttons);
        return actionType;
    }

    private EventHandlerType getEventHandlerFromSelection(Object selection) {
        return selection instanceof EObject ? ModelUtils.findContainingEventHandlerType((EObject)((EObject)selection)) : null;
    }

    private EventHandlerType createEventHandler(IConfigurationElement config) {
        ModelType model = ModelUtils.findContainingModel((EObject)((IModelElement)this.rootPage.getElement().getAdapter(IModelElement.class)));
        EventConditionTypeType conditionType = EventHandlingUtils.findConfiguredEventConditionType((ModelType)model, (String)config.getAttribute("id"), (boolean)true, (boolean)true);
        if (conditionType == null) {
            CreateMetaTypeCommand cmdAddConditionType = MetaTypeModelingUtils.getCreateEventConditionTypeCmd(config);
            cmdAddConditionType.setParent((EObject)model);
            cmdAddConditionType.execute();
            conditionType = EventHandlingUtils.findConfiguredEventConditionType((ModelType)model, (String)config.getAttribute("id"), (boolean)true, (boolean)true);
        }
        IdFactory idFactory = new IdFactory(conditionType.getId(), conditionType.getName());
        idFactory.computeNames(this.getEventHandlers());
        CarnotWorkflowModelFactory factory = CarnotWorkflowModelFactory.eINSTANCE;
        EventHandlerType handler = factory.createEventHandlerType();
        handler.setId(idFactory.getId());
        handler.setName(idFactory.getName());
        handler.setType(conditionType);
        this.getEventHandlers().add(handler);
        return handler;
    }

    private void removeAction(IIdentifiableModelElement action) {
        List list = this.getContainmentList(action);
        if (list != null) {
            list.remove(action);
        }
    }

    private boolean isMoveUpAllowed(Object element) {
        List list = this.getContainmentList(element);
        return list == null ? false : list.indexOf(element) > 0;
    }

    private boolean isMoveDownAllowed(Object element) {
        List list = this.getContainmentList(element);
        return list == null ? false : list.indexOf(element) < list.size() - 1;
    }

    private IConfigurationElement getConfigurationFromSelection() {
        Object selection = this.getSelection();
        IConfigurationElement config = null;
        if (ActionTypeUtil.isAction((Object)selection)) {
            selection = ((AbstractEventAction)selection).eContainer();
        }
        if (selection instanceof EventHandlerType) {
            config = (IConfigurationElement)EventHandlingUtils.findInstalledEventConditionTypes((boolean)(this.rootPage.getModelElement() instanceof ActivityType), (boolean)(this.rootPage.getModelElement() instanceof ProcessDefinitionType)).get(((EventHandlerType)selection).getType().getId());
        } else if (selection instanceof ConfigurationElement) {
            config = (IConfigurationElement)EventHandlingUtils.findInstalledEventConditionTypes((boolean)(this.rootPage.getModelElement() instanceof ActivityType), (boolean)(this.rootPage.getModelElement() instanceof ProcessDefinitionType)).get(((ConfigurationElement)selection).getAttribute("id"));
        }
        return config;
    }
}

