/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.properties;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.IPreferencePage;
import org.eclipse.jface.preference.PreferenceNode;
import org.eclipse.stardust.model.xpdl.carnot.AbstractEventAction;
import org.eclipse.stardust.model.xpdl.carnot.EventConditionTypeType;
import org.eclipse.stardust.model.xpdl.carnot.EventHandlerType;
import org.eclipse.stardust.model.xpdl.carnot.IEventHandlerOwner;
import org.eclipse.stardust.model.xpdl.carnot.IMetaType;
import org.eclipse.stardust.model.xpdl.carnot.IModelElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelElementNodeSymbol;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.model.xpdl.carnot.spi.SpiExtensionRegistry;
import org.eclipse.stardust.model.xpdl.carnot.util.EventHandlingUtils;
import org.eclipse.stardust.model.xpdl.carnot.util.ModelUtils;
import org.eclipse.stardust.modeling.core.Diagram_Messages;
import org.eclipse.stardust.modeling.core.editors.WorkflowModelEditor;
import org.eclipse.stardust.modeling.core.editors.ui.CarnotPreferenceNode;
import org.eclipse.stardust.modeling.core.editors.ui.CarnotPropertyPageContributor;
import org.eclipse.stardust.modeling.core.editors.ui.EObjectLabelProvider;
import org.eclipse.stardust.modeling.core.editors.ui.ModelElementPropertyDialog;
import org.eclipse.stardust.modeling.core.properties.AbstractEventHandlingStructureSynchronizer;
import org.eclipse.stardust.modeling.core.properties.AbstractModelElementPropertyPage;
import org.eclipse.stardust.modeling.core.properties.ActionTypePropertyPage;
import org.eclipse.stardust.modeling.core.properties.ConditionPropertyPage;
import org.eclipse.stardust.modeling.core.properties.EventHandlersPropertyPage;
import org.eclipse.stardust.modeling.core.properties.EventHandlingButtonController;
import org.eclipse.stardust.modeling.core.properties.IButtonManager;
import org.eclipse.stardust.modeling.core.properties.ModelElementAdaptable;
import org.eclipse.stardust.modeling.core.spi.ConfigurationElement;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPropertyPage;

public class EventHandlingOutlineSynchronizer
extends AbstractEventHandlingStructureSynchronizer {
    private final AbstractModelElementPropertyPage rootPage;
    private EObjectLabelProvider defaultProvider;
    private Map spiTypes;
    private Map modelTypes;

    public EventHandlingOutlineSynchronizer(AbstractModelElementPropertyPage rootPage, IEventHandlerOwner target) {
        super(target);
        this.rootPage = rootPage;
        this.defaultProvider = new EObjectLabelProvider(rootPage.getEditor());
    }

    public AbstractModelElementPropertyPage getRootPage() {
        return this.rootPage;
    }

    @Override
    public void init() {
        if (this.getEventHandlerOwner() != null) {
            ModelType model = ModelUtils.findContainingModel((EObject)this.getEventHandlerOwner());
            this.modelTypes = model != null ? this.collectModelTypes(model) : Collections.EMPTY_MAP;
            this.spiTypes = this.collectSpiTypes();
        }
        super.init();
    }

    @Override
    public void updateOutline(Object hint) {
        super.updateOutline(hint);
        this.getRootPage().refreshTree();
    }

    @Override
    protected void synchronizeConditionTypes() {
        CarnotPreferenceNode parentNode = (CarnotPreferenceNode)this.rootPage.getPreferenceManager().find("_cwm_eventhandling_");
        HashSet<String> existingIds = new HashSet<String>();
        IPreferenceNode[] subNodes = parentNode.getSubNodes();
        int i = 0;
        while (i < subNodes.length) {
            if (this.spiTypes.containsKey(subNodes[i].getId())) {
                existingIds.add(subNodes[i].getId());
            } else {
                this.rootPage.removePreferenceNode(parentNode, (CarnotPreferenceNode)subNodes[i]);
            }
            ++i;
        }
        for (IConfigurationElement conditionTypeConfig : this.spiTypes.values()) {
            String id = conditionTypeConfig.getAttribute("id");
            if (!existingIds.contains(id)) {
                this.addConditionTypeNode(conditionTypeConfig);
            }
            this.synchronizeEventHandlers(id);
        }
    }

    @Override
    protected void synchronizeEventHandlers(String conditionTypeId) {
        CarnotPreferenceNode parentNode = (CarnotPreferenceNode)this.rootPage.getPreferenceManager().find(this.getConditionTypeNodeId(conditionTypeId));
        IPreferenceNode[] subNodes = parentNode.getSubNodes();
        HashMap<String, IPreferenceNode> existingNodes = new HashMap<String, IPreferenceNode>();
        int i = 0;
        while (i < subNodes.length) {
            existingNodes.put(subNodes[i].getId(), subNodes[i]);
            ++i;
        }
        List handlers = ModelUtils.findMetaTypeInstances((List)this.getEventHandlerOwner().getEventHandler(), (String)conditionTypeId);
        int i2 = 0;
        while (i2 < handlers.size()) {
            EventHandlerType handler = (EventHandlerType)handlers.get(i2);
            String id = handler.getId();
            CarnotPreferenceNode node = (CarnotPreferenceNode)((Object)existingNodes.get(id));
            if (node == null) {
                node = this.addHandlerNode(handler);
            } else {
                existingNodes.remove(id);
            }
            node.setSortOrder(i2);
            this.synchronizeEventActions(handler);
            ++i2;
        }
        Iterator i22 = existingNodes.values().iterator();
        while (i22.hasNext()) {
            this.rootPage.removePreferenceNode(parentNode, (CarnotPreferenceNode)((Object)i22.next()));
        }
    }

    @Override
    protected void synchronizeEventActions(EventHandlerType handler) {
        CarnotPreferenceNode parentNode = (CarnotPreferenceNode)this.rootPage.getPreferenceManager().find(this.getHandlerNodeId(handler));
        IPreferenceNode[] subNodes = parentNode.getSubNodes();
        HashMap<IModelElement, IPreferenceNode> existingActions = new HashMap<IModelElement, IPreferenceNode>();
        int[] index = new int[1];
        int i = 0;
        while (i < subNodes.length) {
            IModelElement element = (IModelElement)((CarnotPreferenceNode)subNodes[i]).getAdaptable().getAdapter(IModelElement.class);
            if (element instanceof AbstractEventAction) {
                existingActions.put(element, subNodes[i]);
            } else {
                int n = index[0];
                index[0] = n + 1;
                ((CarnotPreferenceNode)subNodes[i]).setSortOrder(n);
            }
            ++i;
        }
        this.syncActionNodes((List)handler.getBindAction(), existingActions, index);
        this.syncActionNodes((List)handler.getEventAction(), existingActions, index);
        this.syncActionNodes((List)handler.getUnbindAction(), existingActions, index);
        Iterator i2 = existingActions.values().iterator();
        while (i2.hasNext()) {
            this.rootPage.removePreferenceNode(parentNode, (CarnotPreferenceNode)((Object)i2.next()));
        }
    }

    private void syncActionNodes(List actionList, HashMap existingActions, int[] index) {
        for (AbstractEventAction action : actionList) {
            CarnotPreferenceNode node = (CarnotPreferenceNode)((Object)existingActions.get(action));
            if (node == null) {
                node = this.addActionNode(action);
            } else {
                existingActions.remove(action);
            }
            int n = index[0];
            index[0] = n + 1;
            node.setSortOrder(n);
        }
    }

    private PreferenceNode addConditionTypeNode(IConfigurationElement template) {
        final ConfigurationElement config = ConfigurationElement.createPageConfiguration(template.getAttribute("id"), template.getAttribute("name"), SpiExtensionRegistry.encodeExtensionIcon((IConfigurationElement)template), EventHandlersPropertyPage.class.toString());
        final EventHandlingButtonController buttonController = new EventHandlingButtonController(this.rootPage);
        CarnotPreferenceNode node = new CarnotPreferenceNode(config, new ModelElementAdaptable(new Class[]{IButtonManager.class}, new Object[]{buttonController}, this.rootPage.getElement())){

            @Override
            public void createPage() {
                EventHandlersPropertyPage page = new EventHandlersPropertyPage(config, buttonController);
                this.internalSetPage((IWorkbenchPropertyPage)page);
            }
        };
        return this.rootPage.addNodeTo("_cwm_eventhandling_", node, null);
    }

    private CarnotPreferenceNode addHandlerNode(EventHandlerType handler) {
        IConfigurationElement conditionTypeConfig = (IConfigurationElement)this.spiTypes.get(handler.getMetaType().getId());
        if (conditionTypeConfig == null) {
            conditionTypeConfig = (IConfigurationElement)this.modelTypes.get(handler.getMetaType().getId());
        }
        final ConfigurationElement config = ConfigurationElement.createPageConfiguration(handler.getId(), handler.getName(), SpiExtensionRegistry.encodeExtensionIcon((IConfigurationElement)conditionTypeConfig), conditionTypeConfig.getAttribute("propertyPageClass"));
        IButtonManager buttonController = null;
        IPreferencePage page = this.rootPage.getPage(this.getConditionTypeNodeId(handler.getType()));
        if (page instanceof EventHandlersPropertyPage) {
            buttonController = ((EventHandlersPropertyPage)page).getButtonController();
        }
        ModelElementAdaptable adaptable = new ModelElementAdaptable(new Class[]{IButtonManager.class, IModelElement.class, IModelElementNodeSymbol.class}, new Object[]{buttonController != null ? buttonController : this.rootPage, handler}, this.rootPage.getElement());
        CarnotPreferenceNode node = new CarnotPreferenceNode(config, adaptable){

            @Override
            public void createPage() {
                try {
                    ConditionPropertyPage page = new ConditionPropertyPage(config);
                    this.internalSetPage((IWorkbenchPropertyPage)page);
                }
                catch (CoreException e) {
                    ErrorDialog.openError((Shell)EventHandlingOutlineSynchronizer.this.rootPage.getShell(), (String)Diagram_Messages.ERROR_DIA_EXC, (String)e.getMessage(), (IStatus)e.getStatus());
                }
            }
        };
        CarnotPropertyPageContributor contributor = CarnotPropertyPageContributor.instance();
        List<CarnotPreferenceNode> nodes = contributor.contributePropertyPages(adaptable);
        if (nodes.size() == 1) {
            CarnotPreferenceNode root = nodes.get(0);
            IPreferenceNode[] subnodes = root.getSubNodes();
            int i = 0;
            while (i < subnodes.length) {
                root.remove(subnodes[i]);
                node.add(subnodes[i]);
                ++i;
            }
        }
        return this.rootPage.addNodeTo(this.getConditionTypeNodeId(handler.getMetaType().getId()), node, this.defaultProvider);
    }

    private WorkflowModelEditor getEditor() {
        return this.getRootPage().getEditor();
    }

    private CarnotPreferenceNode addActionNode(AbstractEventAction action) {
        EventHandlerType handler = ModelUtils.findContainingEventHandlerType((EObject)action);
        ConfigurationElement config = ConfigurationElement.createPageConfiguration(action.getId(), action.getName(), this.getEditor().getIconFactory().getIconFor((EObject)action), ActionTypePropertyPage.class.getName());
        IButtonManager buttonController = null;
        IPreferencePage page = this.rootPage.getPage(this.getConditionTypeNodeId(handler.getType()));
        if (page instanceof EventHandlersPropertyPage) {
            buttonController = ((EventHandlersPropertyPage)page).getButtonController();
        }
        CarnotPreferenceNode node = new CarnotPreferenceNode(config, new ModelElementAdaptable(new Class[]{IButtonManager.class, IModelElement.class, IModelElementNodeSymbol.class}, new Object[]{buttonController != null ? buttonController : this.rootPage, action}, this.rootPage.getElement()), -2);
        return this.rootPage.addNodeTo(this.getHandlerNodeId(handler), node, this.defaultProvider);
    }

    private String getConditionTypeNodeId(EventConditionTypeType conditionType) {
        return this.getConditionTypeNodeId(conditionType.getId());
    }

    private String getConditionTypeNodeId(String conditionTypeId) {
        return ModelElementPropertyDialog.composePageId("_cwm_eventhandling_", conditionTypeId);
    }

    private String getHandlerNodeId(EventHandlerType handler) {
        if (handler != null) {
            IMetaType conditionType = handler.getMetaType();
            return ModelElementPropertyDialog.composePageId(this.getConditionTypeNodeId(conditionType.getId()), handler.getId());
        }
        return null;
    }

    private Map collectSpiTypes() {
        return EventHandlingUtils.findInstalledEventConditionTypes((boolean)PKG_CWM.getActivityType().isInstance((Object)this.getEventHandlerOwner()), (boolean)PKG_CWM.getProcessDefinitionType().isInstance((Object)this.getEventHandlerOwner()));
    }

    private Map collectModelTypes(ModelType model) {
        return EventHandlingUtils.findConfiguredEventConditionTypes((ModelType)model, (boolean)PKG_CWM.getActivityType().isInstance((Object)this.getEventHandlerOwner()), (boolean)PKG_CWM.getProcessDefinitionType().isInstance((Object)this.getEventHandlerOwner()));
    }
}

