/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.properties;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.stardust.model.xpdl.carnot.AbstractEventAction;
import org.eclipse.stardust.model.xpdl.carnot.EventConditionTypeType;
import org.eclipse.stardust.model.xpdl.carnot.EventHandlerType;
import org.eclipse.stardust.model.xpdl.carnot.IEventHandlerOwner;
import org.eclipse.stardust.modeling.core.properties.EventHandlingNotificationAdapter;

public class EventHandlingTableContentProvider
extends EventHandlingNotificationAdapter
implements ITreeContentProvider {
    private final String conditionTypeId;
    private TreeViewer viewer;

    public EventHandlingTableContentProvider(String conditionTypeId) {
        this.conditionTypeId = conditionTypeId;
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof EventHandlerType) {
            EventHandlerType handler = (EventHandlerType)parentElement;
            ArrayList result = new ArrayList();
            this.addActions(result, (List)handler.getBindAction());
            this.addActions(result, (List)handler.getEventAction());
            this.addActions(result, (List)handler.getUnbindAction());
            return result.toArray();
        }
        return new Object[0];
    }

    private void addActions(List result, List actions) {
        Iterator i = actions.iterator();
        while (i.hasNext()) {
            result.add(i.next());
        }
    }

    public Object getParent(Object element) {
        return element instanceof AbstractEventAction ? ((EObject)element).eContainer() : null;
    }

    public boolean hasChildren(Object element) {
        return element instanceof EventHandlerType && (!((EventHandlerType)element).getBindAction().isEmpty() || !((EventHandlerType)element).getEventAction().isEmpty() || !((EventHandlerType)element).getUnbindAction().isEmpty());
    }

    public Object[] getElements(Object inputElement) {
        ArrayList<EventHandlerType> result = new ArrayList<EventHandlerType>();
        IEventHandlerOwner owner = (IEventHandlerOwner)inputElement;
        EList list = owner.getEventHandler();
        for (EventHandlerType handler : list) {
            EventConditionTypeType type = handler.getType();
            if (type == null || !this.conditionTypeId.equals(type.getId())) continue;
            result.add(handler);
        }
        return result.toArray();
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.dispose();
        this.init((IEventHandlerOwner)newInput);
        this.viewer = (TreeViewer)viewer;
    }

    @Override
    public void actionChanged(AbstractEventAction action, String property) {
        this.viewer.update((Object)action, new String[]{property});
    }

    @Override
    public void actionAdded(AbstractEventAction action) {
        this.viewer.refresh((Object)action.eContainer());
    }

    @Override
    public void actionMoved(AbstractEventAction action) {
        this.viewer.refresh((Object)action.eContainer());
    }

    @Override
    public void actionRemoved(AbstractEventAction action) {
        this.viewer.refresh((Object)action.eContainer());
    }

    @Override
    public void handlerChanged(EventHandlerType handler, String property) {
        this.viewer.update((Object)handler, new String[]{property});
    }

    @Override
    public void handlerAdded(EventHandlerType handler) {
        this.viewer.refresh();
    }

    @Override
    public void handlerMoved(EventHandlerType handler) {
        this.viewer.refresh();
    }

    @Override
    public void handlerRemoved(EventHandlerType handler) {
        this.viewer.refresh();
    }
}

