/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.properties;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.stardust.model.xpdl.carnot.AttributeType;
import org.eclipse.stardust.model.xpdl.carnot.IExtensibleElement;
import org.eclipse.stardust.model.xpdl.carnot.IIdentifiableModelElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelElementNodeSymbol;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.model.xpdl.carnot.util.AttributeUtil;
import org.eclipse.stardust.model.xpdl.carnot.util.ModelUtils;
import org.eclipse.stardust.model.xpdl.util.NameIdUtils;
import org.eclipse.stardust.modeling.common.ui.jface.databinding.EFeatureAdapter;
import org.eclipse.stardust.modeling.common.ui.jface.utils.FormBuilder;
import org.eclipse.stardust.modeling.common.ui.jface.utils.LabeledText;
import org.eclipse.stardust.modeling.core.Diagram_Messages;
import org.eclipse.stardust.modeling.core.properties.AbstractModelElementPropertyPage;
import org.eclipse.stardust.modeling.core.utils.CwmFeatureAdapter;
import org.eclipse.stardust.modeling.core.utils.GenericUtils;
import org.eclipse.stardust.modeling.core.utils.WidgetBindingManager;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class IdentifiablePropertyPage
extends AbstractModelElementPropertyPage {
    private static final String EMPTY = "";
    private Label stxtOid;
    protected LabeledText txtId;
    protected LabeledText txtName;
    protected LabeledText txtDescription;
    private Button publicCheckBox;
    private boolean publicType;
    protected IIdentifiableModelElement modelElement;
    private Boolean providesVisibility = false;
    private ModifyListener listener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            IdentifiablePropertyPage.this.onNameUpdate(GenericUtils.getAutoIdValue(), ((Text)e.widget).getText());
        }
    };

    protected void onNameUpdate(boolean autoFillEnabled, String name) {
        if (autoFillEnabled) {
            this.txtId.getText().setEditable(false);
            String computedId = NameIdUtils.createIdFromName(null, (EObject)this.getModelElement());
            this.txtId.getText().setText(computedId);
        } else {
            this.txtId.getText().setEditable(true);
        }
    }

    @Override
    public void loadFieldsFromElement(IModelElementNodeSymbol symbol, IModelElement element) {
        EObject model;
        Proxy proxy;
        InvocationHandler ih;
        IModelElement bindElement = element;
        if (bindElement instanceof Proxy && bindElement instanceof ModelType && (ih = Proxy.getInvocationHandler(proxy = (Proxy)bindElement)) instanceof ModelUtils.EObjectInvocationHandler && (model = ((ModelUtils.EObjectInvocationHandler)ih).getModel()) instanceof ModelType) {
            bindElement = model;
        }
        this.txtName.getText().removeModifyListener(this.listener);
        WidgetBindingManager wBndMgr = this.getWidgetBindingManager();
        wBndMgr.getModelBindingManager().bind((EObject)bindElement, (EStructuralFeature)PKG_CWM.getIModelElement_ElementOid(), this.stxtOid);
        wBndMgr.bind(this.txtId, (EObject)bindElement, (EStructuralFeature)PKG_CWM.getIIdentifiableElement_Id());
        wBndMgr.bind(this.txtName, (EObject)bindElement, (EStructuralFeature)PKG_CWM.getIIdentifiableElement_Name());
        if (element instanceof IIdentifiableModelElement) {
            wBndMgr.bind(this.txtDescription, (EObject)bindElement, (EStructuralFeature)(element instanceof ModelType ? PKG_CWM.getModelType_Description() : PKG_CWM.getIIdentifiableModelElement_Description()), (EFeatureAdapter)CwmFeatureAdapter.INSTANCE);
        }
        wBndMgr.getModelBindingManager().updateWidgets((Object)bindElement);
        this.txtName.getText().addModifyListener(this.listener);
        this.txtName.getText().selectAll();
        this.txtName.getText().setFocus();
    }

    @Override
    public void loadElementFromFields(IModelElementNodeSymbol symbol, IModelElement element) {
    }

    @Override
    public Control createBody(Composite parent) {
        Composite composite = FormBuilder.createLabeledControlsComposite((Composite)parent);
        FormBuilder.createLabelWithRightAlignedStatus((Composite)composite, (String)this.getOidLabel());
        this.stxtOid = FormBuilder.createLabel((Composite)composite, (String)EMPTY);
        this.txtName = FormBuilder.createLabeledText((Composite)composite, (String)Diagram_Messages.LB_Name);
        this.txtName.setTextLimit(80);
        this.txtId = FormBuilder.createLabeledText((Composite)composite, (String)Diagram_Messages.LB_ID);
        this.txtId.setTextLimit(80);
        boolean autoIdButtonValue = GenericUtils.getAutoIdValue();
        if (autoIdButtonValue) {
            this.txtId.getText().setEditable(false);
        }
        this.contributeExtraControls(composite);
        if (this.getModelElement() instanceof IIdentifiableModelElement) {
            FormBuilder.createHorizontalSeparator((Composite)composite, (int)2);
            this.txtDescription = FormBuilder.createLabeledTextArea((Composite)composite, (String)Diagram_Messages.TA_Description);
            this.modelElement = (IIdentifiableModelElement)this.getModelElement();
        }
        if (this.providesVisibility.booleanValue()) {
            this.setupVisibility();
        }
        return composite;
    }

    protected String getOidLabel() {
        return Diagram_Messages.LB_ElementOID;
    }

    protected void contributeExtraControls(Composite composite) {
        if (this.providesVisibility.booleanValue()) {
            this.publicCheckBox = FormBuilder.createCheckBox((Composite)composite, (String)Diagram_Messages.CHECKBOX_Visibility, (int)2);
            this.publicCheckBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    IdentifiablePropertyPage.this.publicType = !IdentifiablePropertyPage.this.publicType;
                    if (IdentifiablePropertyPage.this.publicType) {
                        AttributeUtil.setAttribute((IExtensibleElement)IdentifiablePropertyPage.this.modelElement, (String)"carnot:engine:visibility", (String)"Public");
                    } else {
                        AttributeUtil.setAttribute((IExtensibleElement)IdentifiablePropertyPage.this.modelElement, (String)"carnot:engine:visibility", (String)"Private");
                    }
                }
            });
        }
    }

    protected String getId() {
        return this.txtId.getText().getText();
    }

    protected String getName() {
        return this.txtName.getText().getText();
    }

    protected void setupVisibility() {
        AttributeType visibility = AttributeUtil.getAttribute((IExtensibleElement)((IExtensibleElement)this.getModelElement()), (String)"carnot:engine:visibility");
        if (visibility == null) {
            String visibilityDefault = PlatformUI.getPreferenceStore().getString("multiPackageModelingVisibility");
            if (visibilityDefault == null || visibilityDefault == EMPTY || visibilityDefault.equalsIgnoreCase("Public")) {
                AttributeUtil.setAttribute((IExtensibleElement)this.modelElement, (String)"carnot:engine:visibility", (String)"Public");
                this.publicType = true;
            }
        } else {
            this.publicType = visibility.getValue().equalsIgnoreCase("Public");
        }
        this.publicCheckBox.setSelection(this.publicType);
    }

    protected void setProvidesVisibility(boolean flag) {
        this.providesVisibility = flag;
    }
}

