/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.properties;

import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gef.EditPart;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.stardust.model.xpdl.carnot.IModelElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelElementNodeSymbol;
import org.eclipse.stardust.model.xpdl.carnot.IModelParticipant;
import org.eclipse.stardust.model.xpdl.carnot.LaneSymbol;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.model.xpdl.carnot.util.ModelUtils;
import org.eclipse.stardust.modeling.common.ui.jface.utils.FormBuilder;
import org.eclipse.stardust.modeling.common.ui.jface.utils.LabeledViewer;
import org.eclipse.stardust.modeling.common.ui.jface.widgets.LabelWithStatus;
import org.eclipse.stardust.modeling.core.Diagram_Messages;
import org.eclipse.stardust.modeling.core.editors.parts.properties.DefaultPropSheetCmdFactory;
import org.eclipse.stardust.modeling.core.editors.ui.EObjectLabelProvider;
import org.eclipse.stardust.modeling.core.properties.IdentifiablePropertyPage;
import org.eclipse.stardust.modeling.core.utils.HierarchyUtils;
import org.eclipse.stardust.modeling.core.utils.IdentifiableViewerSorter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;

public class LanePropertyPage
extends IdentifiablePropertyPage {
    private LabeledViewer labeledWidget;
    private IModelParticipant originalPerformer;
    private TableViewer viewer;

    @Override
    public void loadFieldsFromElement(IModelElementNodeSymbol symbol, IModelElement element) {
        super.loadFieldsFromElement(symbol, element);
        LaneSymbol lane = (LaneSymbol)element;
        ModelType model = ModelUtils.findContainingModel((EObject)lane);
        this.viewer = (TableViewer)this.labeledWidget.getViewer();
        this.viewer.getTable().removeAll();
        List participants = HierarchyUtils.getParticipants(lane, model);
        this.originalPerformer = lane.getParticipantReference();
        if (HierarchyUtils.hasChildLanesParticipant(lane)) {
            this.setMessage(Diagram_Messages.LanePropertyPage_SetParticipantInformation, 1);
            if (this.originalPerformer != null) {
                this.viewer.add(new Object[]{this.originalPerformer});
            }
        } else {
            this.viewer.add(participants.toArray());
        }
        this.viewer.setSelection((ISelection)(this.originalPerformer == null ? null : new StructuredSelection((Object)this.originalPerformer)));
    }

    @Override
    protected void performDefaults() {
        super.performDefaults();
        this.viewer.setSelection((ISelection)(this.originalPerformer == null ? null : new StructuredSelection((Object)this.originalPerformer)));
    }

    @Override
    public void loadElementFromFields(IModelElementNodeSymbol symbol, IModelElement element) {
        LaneSymbol lane = (LaneSymbol)element;
        this.originalPerformer = lane.getParticipantReference();
        TableViewer viewer = (TableViewer)this.labeledWidget.getViewer();
        IStructuredSelection selection = (IStructuredSelection)viewer.getSelection();
        IModelParticipant newPerformer = (IModelParticipant)(selection.isEmpty() ? null : selection.getFirstElement());
        if (newPerformer != this.originalPerformer) {
            DefaultPropSheetCmdFactory.INSTANCE.getSetCommand((EditPart)this.getElement(), (EObject)((LaneSymbol)element), (EStructuralFeature)PKG_CWM.getISwimlaneSymbol_ParticipantReference(), newPerformer).execute();
        }
    }

    @Override
    public void contributeExtraControls(Composite composite) {
        LabelWithStatus label = FormBuilder.createLabelWithRightAlignedStatus((Composite)composite, (String)Diagram_Messages.PARTICIPANT_LABEL, (int)3);
        GridLayout layout = new GridLayout(2, false);
        layout.horizontalSpacing = 5;
        Composite tableComposite = FormBuilder.createComposite((Composite)composite, (int)2, (int)3);
        tableComposite.setLayout((Layout)layout);
        Table table = new Table(tableComposite, 2048);
        table.setLayoutData((Object)FormBuilder.createDefaultMultiLineWidgetGridData());
        TableViewer tableViewer = new TableViewer(table);
        tableViewer.setLabelProvider((IBaseLabelProvider)new EObjectLabelProvider(this.getEditor()));
        tableViewer.setSorter((ViewerSorter)new IdentifiableViewerSorter());
        this.labeledWidget = new LabeledViewer((StructuredViewer)tableViewer, label);
        Button button = FormBuilder.createButton((Composite)tableComposite, (String)Diagram_Messages.UncheckButton, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IModelElement modelElement = (IModelElement)LanePropertyPage.this.getModelElement();
                if (modelElement instanceof LaneSymbol) {
                    LaneSymbol symbol = (LaneSymbol)modelElement;
                    symbol.setParticipantReference(null);
                    LanePropertyPage.this.viewer.setSelection(null);
                }
            }
        });
        GridData data = (GridData)button.getLayoutData();
        data.verticalAlignment = 128;
    }
}

