/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.properties;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.viewers.IFilter;

public abstract class ModelElementNotificationAdapter
extends AdapterImpl {
    private List targets = new ArrayList();
    private EStructuralFeature elementListFeature;
    private int[] elementFeatureIds;
    private boolean registerChildren;
    private IFilter filter;

    public abstract void elementChanged(EObject var1);

    public abstract void elementAdded(EObject var1);

    public abstract void elementMoved(EObject var1);

    public abstract void elementRemoved(EObject var1);

    public ModelElementNotificationAdapter(EStructuralFeature elementListFeature, int[] elementFeatureIds, boolean registerChildren) {
        this(elementListFeature, elementFeatureIds, null, registerChildren);
    }

    public ModelElementNotificationAdapter(EStructuralFeature elementListFeature, int[] elementFeatureIds, IFilter filter, boolean registerChildren) {
        this.elementListFeature = elementListFeature;
        this.elementFeatureIds = elementFeatureIds;
        this.filter = filter;
        this.registerChildren = registerChildren;
    }

    public void init(EObject target) {
        if (target != null) {
            this.targets.add(target);
            this.registerAdapter((Notifier)target);
            if (this.registerChildren) {
                this.registerAdapter(this.getChildren(target));
            }
        }
    }

    protected List getChildren(EObject parent) {
        List unfiltered = (List)parent.eGet(this.elementListFeature);
        ArrayList result = new ArrayList();
        if (this.filter == null) {
            result.addAll(unfiltered);
        } else {
            for (Object element : unfiltered) {
                if (!this.filter.select(element)) continue;
                result.add(element);
            }
        }
        return result;
    }

    private void registerAdapter(List elements) {
        Iterator i = elements.iterator();
        while (i.hasNext()) {
            this.registerAdapter((Notifier)i.next());
        }
    }

    public void dispose() {
        int i = 0;
        while (i < this.targets.size()) {
            EObject target = (EObject)this.targets.get(i);
            if (this.registerChildren) {
                this.unregisterAdapter(this.getChildren(target));
            }
            this.unregisterAdapter((Notifier)target);
            ++i;
        }
        this.targets.clear();
    }

    public void dispose(EObject target) {
        if (this.registerChildren) {
            this.unregisterAdapter(this.getChildren(target));
        }
        this.unregisterAdapter((Notifier)target);
        this.targets.remove(target);
    }

    protected Iterator targets() {
        return this.targets.iterator();
    }

    private void unregisterAdapter(List elements) {
        Iterator i = elements.iterator();
        while (i.hasNext()) {
            this.unregisterAdapter((Notifier)i.next());
        }
    }

    public void notifyChanged(Notification msg) {
        block8: {
            EObject notifier;
            block7: {
                block11: {
                    block10: {
                        block9: {
                            if (!this.targets.contains(msg.getNotifier())) break block7;
                            if (this.elementListFeature != msg.getFeature()) break block8;
                            if (3 != msg.getEventType() || !this.matches(msg.getNewValue())) break block9;
                            if (this.registerChildren) {
                                this.registerAdapter((Notifier)msg.getNewValue());
                            }
                            this.elementAdded((EObject)msg.getNewValue());
                            break block8;
                        }
                        if (4 != msg.getEventType() || !this.matches(msg.getOldValue())) break block10;
                        if (this.registerChildren) {
                            this.unregisterAdapter((Notifier)msg.getOldValue());
                        }
                        this.elementRemoved((EObject)msg.getOldValue());
                        break block8;
                    }
                    if (6 != msg.getEventType() || !this.matches(msg.getOldValue())) break block11;
                    List removeList = (List)msg.getOldValue();
                    for (EObject element : removeList) {
                        if (this.registerChildren) {
                            this.unregisterAdapter((Notifier)element);
                        }
                        this.elementRemoved(element);
                    }
                    break block8;
                }
                if (7 != msg.getEventType() || !this.matches(msg.getNewValue())) break block8;
                this.elementMoved((EObject)msg.getNewValue());
                break block8;
            }
            if (this.registerChildren && this.matches(msg.getNotifier()) && this.targets.contains((notifier = (EObject)msg.getNotifier()).eContainer()) && notifier.eContainingFeature() == this.elementListFeature) {
                int featureId = msg.getFeatureID(notifier.getClass());
                int i = 0;
                while (i < this.elementFeatureIds.length) {
                    if (featureId == this.elementFeatureIds[i]) {
                        this.elementChanged(notifier);
                    }
                    ++i;
                }
            }
        }
    }

    private boolean matches(Object value) {
        return this.filter == null || this.filter.select(value);
    }

    protected void registerAdapter(Notifier target) {
        if (target != null && !target.eAdapters().contains((Object)this)) {
            target.eAdapters().add((Object)this);
        }
    }

    protected void unregisterAdapter(Notifier target) {
        if (target != null) {
            target.eAdapters().remove((Object)this);
        }
    }
}

