/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.properties;

import com.gface.date.DatePickerCombo;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;
import org.eclipse.stardust.model.xpdl.carnot.IExtensibleElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelElementNodeSymbol;
import org.eclipse.stardust.model.xpdl.carnot.util.AttributeUtil;
import org.eclipse.stardust.modeling.common.ui.jface.utils.FormBuilder;
import org.eclipse.stardust.modeling.core.Diagram_Messages;
import org.eclipse.stardust.modeling.core.editors.ui.DateUtils;
import org.eclipse.stardust.modeling.core.properties.IdentifiablePropertyPage;
import org.eclipse.swt.widgets.Composite;

public class ModelPropertyPage
extends IdentifiablePropertyPage {
    private static final String EMPTY = "";
    private static final String TIMESTAMP_TYPE = "Timestamp";
    private DatePickerCombo validFrom;

    @Override
    protected String getOidLabel() {
        return Diagram_Messages.LB_OID;
    }

    @Override
    public void loadElementFromFields(IModelElementNodeSymbol symbol, IModelElement element) {
        super.loadElementFromFields(symbol, element);
        AttributeUtil.setAttribute((IExtensibleElement)((IExtensibleElement)element), (String)"carnot:engine:validFrom", (String)TIMESTAMP_TYPE, (String)this.getDate(this.validFrom));
        AttributeUtil.setAttribute((IExtensibleElement)((IExtensibleElement)element), (String)"carnot:engine:validTo", null);
    }

    @Override
    public void loadFieldsFromElement(IModelElementNodeSymbol symbol, IModelElement element) {
        super.loadFieldsFromElement(symbol, element);
        this.setDate(AttributeUtil.getAttributeValue((IExtensibleElement)((IExtensibleElement)element), (String)"carnot:engine:validFrom"), this.validFrom);
    }

    private String getDate(DatePickerCombo control) {
        Date date = control.getDate();
        return date == null ? EMPTY : DateUtils.getNonInteractiveDateFormat().format(date);
    }

    private void setDate(String textValue, DatePickerCombo control) {
        if (textValue != null) {
            try {
                Date date = DateUtils.getNonInteractiveDateFormat().parse(textValue);
                control.setDate(date);
            }
            catch (ParseException parseException) {
                control.setDate(null);
            }
        } else {
            control.setDate(null);
        }
    }

    @Override
    protected void contributeExtraControls(Composite composite) {
        int dpStyle = 224;
        FormBuilder.createLabel((Composite)composite, (String)Diagram_Messages.LB_ValidFrom);
        this.validFrom = new DatePickerCombo(composite, 2048, dpStyle);
        this.validFrom.setDateFormat(DateFormat.getDateInstance(3));
        this.validFrom.setLayoutData((Object)FormBuilder.createDefaultSingleLineWidgetGridData());
    }
}

