/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.properties;

import java.text.NumberFormat;
import java.text.ParseException;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.stardust.common.StringUtils;
import org.eclipse.stardust.model.xpdl.carnot.CarnotWorkflowModelPackage;
import org.eclipse.stardust.model.xpdl.carnot.IModelElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelElementNodeSymbol;
import org.eclipse.stardust.model.xpdl.carnot.RoleType;
import org.eclipse.stardust.modeling.common.ui.jface.utils.FormBuilder;
import org.eclipse.stardust.modeling.core.Diagram_Messages;
import org.eclipse.stardust.modeling.core.VerifierFactory;
import org.eclipse.stardust.modeling.core.properties.IdentifiablePropertyPage;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;

public class RoleGeneralPropertyPage
extends IdentifiablePropertyPage {
    private Text cardinalityText;

    @Override
    public void loadFieldsFromElement(IModelElementNodeSymbol symbol, IModelElement element) {
        super.loadFieldsFromElement(symbol, element);
        RoleType role = (RoleType)element;
        String cardinality = NumberFormat.getIntegerInstance().format(role.getCardinality());
        if (cardinality != null) {
            this.cardinalityText.setText(cardinality);
        }
    }

    @Override
    public void loadElementFromFields(IModelElementNodeSymbol symbol, IModelElement element) {
        super.loadElementFromFields(symbol, element);
        RoleType role = (RoleType)element;
        String cardinalityString = this.cardinalityText.getText().trim();
        int cardinality = 0;
        if (!StringUtils.isEmpty((String)cardinalityString)) {
            try {
                cardinality = NumberFormat.getIntegerInstance().parse(cardinalityString).intValue();
            }
            catch (ParseException parseException) {}
        }
        if (cardinality != 0) {
            role.setCardinality(cardinality);
        } else {
            role.eUnset((EStructuralFeature)CarnotWorkflowModelPackage.eINSTANCE.getRoleType_Cardinality());
        }
    }

    @Override
    public Control createBody(Composite parent) {
        this.setProvidesVisibility(true);
        return super.createBody(parent);
    }

    @Override
    public void contributeExtraControls(Composite composite) {
        super.contributeExtraControls(composite);
        FormBuilder.createLabel((Composite)composite, (String)Diagram_Messages.LB_Cardinality);
        this.cardinalityText = FormBuilder.createText((Composite)composite);
        this.cardinalityText.addVerifyListener((VerifyListener)VerifierFactory.intVerifier);
    }
}

