/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.properties;

import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.stardust.model.xpdl.carnot.DataType;
import org.eclipse.stardust.model.xpdl.carnot.DirectionType;
import org.eclipse.stardust.model.xpdl.carnot.IExtensibleElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelElementNodeSymbol;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.model.xpdl.carnot.util.AttributeUtil;
import org.eclipse.stardust.model.xpdl.carnot.util.ModelUtils;
import org.eclipse.stardust.model.xpdl.carnot.util.ScopeUtils;
import org.eclipse.stardust.modeling.common.ui.jface.databinding.IModelAdapter;
import org.eclipse.stardust.modeling.common.ui.jface.databinding.IWidgetAdapter;
import org.eclipse.stardust.modeling.common.ui.jface.utils.FormBuilder;
import org.eclipse.stardust.modeling.common.ui.jface.utils.LabeledText;
import org.eclipse.stardust.modeling.common.ui.jface.utils.LabeledViewer;
import org.eclipse.stardust.modeling.common.ui.jface.widgets.LabelWithStatus;
import org.eclipse.stardust.modeling.core.Diagram_Messages;
import org.eclipse.stardust.modeling.core.editors.ui.AccessPathBrowserComposite;
import org.eclipse.stardust.modeling.core.editors.ui.EObjectLabelProvider;
import org.eclipse.stardust.modeling.core.properties.AbstractModelElementPropertyPage;
import org.eclipse.stardust.modeling.core.ui.Data2DataPathModelAdapter2;
import org.eclipse.stardust.modeling.core.ui.Data2DataPathWidgetAdapter2;
import org.eclipse.stardust.modeling.core.utils.WidgetBindingManager;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Text;

public class SubprocessRuntimeBindingPropertyPage
extends AbstractModelElementPropertyPage {
    private ComboViewer dataText;
    private AccessPathBrowserComposite dataPathBrowser;
    private LabelWithStatus dataLabel;
    private LabelWithStatus dataPathLabel;
    private Group dataGroup;
    private Button dynamicBindingCheckBox;

    @Override
    public void loadFieldsFromElement(IModelElementNodeSymbol symbol, IModelElement element) {
        WidgetBindingManager binding = this.getWidgetBindingManager();
        ModelType model = ModelUtils.findContainingModel((EObject)element);
        this.dataText.setInput((Object)model.getData());
        binding.bind(new LabeledViewer((StructuredViewer)this.dataText, this.dataLabel), (IExtensibleElement)element, "carnot:engine:dataId", (List)model.getData());
        binding.bind(new LabeledText(this.dataPathBrowser.getMethodText(), this.dataPathLabel), (IExtensibleElement)element, "carnot:engine:dataPath");
        binding.getModelBindingManager().bind((IModelAdapter)new Data2DataPathModelAdapter2(model, model.getData()), (IWidgetAdapter)new Data2DataPathWidgetAdapter2((StructuredViewer)this.dataText, this.dataPathBrowser, DirectionType.IN_LITERAL));
        boolean hasDepartments = AttributeUtil.getBooleanValue((IExtensibleElement)((IExtensibleElement)element), (String)"carnot:engine:bound");
        this.dynamicBindingCheckBox.setSelection(hasDepartments);
        this.dataGroup.setVisible(hasDepartments);
        this.validate(null);
    }

    private void validate(Object selection) {
        String dataPath = null;
        DataType dataType = null;
        if (selection != null) {
            if (selection instanceof String) {
                dataPath = (String)selection;
            } else if (selection instanceof DataType) {
                dataType = (DataType)selection;
            }
        }
        boolean isValid = true;
        IModelElement modelElement = (IModelElement)this.getModelElement();
        if (AttributeUtil.getBooleanValue((IExtensibleElement)((IExtensibleElement)modelElement), (String)"carnot:engine:bound") && !ScopeUtils.isValidScopeData((IExtensibleElement)((IExtensibleElement)modelElement), (String)dataPath, (DataType)dataType)) {
            isValid = false;
        }
        if (isValid) {
            this.setErrorMessage(null);
            this.setValid(true);
        } else {
            this.setErrorMessage(String.valueOf(Diagram_Messages.ERROR_MSG_SELECTED_DATA) + "/" + Diagram_Messages.ERROR_MSG_DATA_PATH_MUST_RESOLVE_TO_A_STRING_VALUE);
            this.setValid(false);
        }
    }

    @Override
    public Control createBody(Composite parent) {
        Composite composite = FormBuilder.createComposite((Composite)parent, (int)2);
        this.createDataGroup(composite);
        return composite;
    }

    private void createDataGroup(Composite composite) {
        this.dynamicBindingCheckBox = FormBuilder.createCheckBox((Composite)composite, (String)Diagram_Messages.BOX_SUBPROCESS_IS_RESOLVED_AT_RUNTIME, (int)2);
        this.dynamicBindingCheckBox.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                boolean selection = SubprocessRuntimeBindingPropertyPage.this.dynamicBindingCheckBox.getSelection();
                SubprocessRuntimeBindingPropertyPage.this.dataGroup.setVisible(selection);
                AttributeUtil.setBooleanAttribute((IExtensibleElement)((IExtensibleElement)SubprocessRuntimeBindingPropertyPage.this.getModelElement()), (String)"carnot:engine:bound", (Boolean)selection);
                SubprocessRuntimeBindingPropertyPage.this.validate(null);
            }
        });
        FormBuilder.createLabel((Composite)composite, (String)" ", (int)2);
        this.dataGroup = FormBuilder.createGroup((Composite)composite, (String)Diagram_Messages.LBL_IMP_MD_ID, (int)2, (int)2);
        GridData gridDataGroup = new GridData(4, 0, false, false);
        gridDataGroup.horizontalSpan = 2;
        this.dataGroup.setLayoutData((Object)gridDataGroup);
        this.dataLabel = FormBuilder.createLabelWithRightAlignedStatus((Composite)this.dataGroup, (String)Diagram_Messages.LB_Data);
        this.dataText = new ComboViewer(FormBuilder.createCombo((Composite)this.dataGroup));
        this.dataText.setSorter(new ViewerSorter());
        this.dataText.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.dataText.setLabelProvider((IBaseLabelProvider)new EObjectLabelProvider(this.getEditor()));
        this.dataText.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (event.getSelection() instanceof StructuredSelection) {
                    Object element = ((StructuredSelection)event.getSelection()).getFirstElement();
                    SubprocessRuntimeBindingPropertyPage.this.validate(element);
                }
            }
        });
        this.dataPathLabel = FormBuilder.createLabelWithRightAlignedStatus((Composite)this.dataGroup, (String)Diagram_Messages.LB_DataPath);
        this.dataPathBrowser = new AccessPathBrowserComposite(this.getEditor(), (Composite)this.dataGroup, Diagram_Messages.LB_DataPath);
        this.dataPathBrowser.getMethodText().addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (e.getSource() instanceof Text) {
                    Text text = (Text)e.getSource();
                    SubprocessRuntimeBindingPropertyPage.this.validate(text.getText());
                }
            }
        });
    }

    @Override
    public void loadElementFromFields(IModelElementNodeSymbol symbol, IModelElement element) {
    }
}

