/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.properties;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.stardust.common.StringUtils;
import org.eclipse.stardust.model.xpdl.carnot.CarnotWorkflowModelFactory;
import org.eclipse.stardust.model.xpdl.carnot.IModelElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelElementNodeSymbol;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.model.xpdl.carnot.TransitionType;
import org.eclipse.stardust.model.xpdl.carnot.XmlTextNode;
import org.eclipse.stardust.model.xpdl.carnot.util.ModelUtils;
import org.eclipse.stardust.modeling.common.platform.utils.WorkspaceUtils;
import org.eclipse.stardust.modeling.common.ui.jface.utils.FormBuilder;
import org.eclipse.stardust.modeling.common.ui.jface.utils.LabeledCombo;
import org.eclipse.stardust.modeling.common.ui.jface.utils.LabeledViewer;
import org.eclipse.stardust.modeling.core.BlacklistVerifier;
import org.eclipse.stardust.modeling.core.Diagram_Messages;
import org.eclipse.stardust.modeling.core.editors.WorkflowModelEditor;
import org.eclipse.stardust.modeling.core.properties.IdentifiablePropertyPage;
import org.eclipse.stardust.modeling.core.utils.GenericUtils;
import org.eclipse.stardust.modeling.javascript.editor.EditorUtils;
import org.eclipse.stardust.modeling.javascript.editor.JSCompilationUnitEditor;
import org.eclipse.stardust.modeling.javascript.editor.controller.JavaScriptEditorController;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;

public class TransitionPropertyPage
extends IdentifiablePropertyPage {
    private ComboViewer targetViewer;
    private Composite sourceViewerComposite;
    private Label conditionExpression;
    private Button forkButton;
    private JSCompilationUnitEditor transitionConditionEditor;
    private JavaScriptEditorController controller = new JavaScriptEditorController();
    private IProject project;
    private ModelType model;
    public static final String[] EXPRESSION_TYPES = new String[]{"CONDITION", "OTHERWISE"};

    @Override
    public void dispose() {
        super.dispose();
        EditorUtils.deleteFileStructure((IProject)this.project, (ModelType)this.model);
    }

    @Override
    protected void performDefaults() {
        super.performDefaults();
        TransitionType transition = (TransitionType)this.getModelElement();
        String expression = this.getExpression(transition);
        String condition = transition.getCondition();
        if (StringUtils.isEmpty((String)condition)) {
            condition = EXPRESSION_TYPES[0];
        }
        this.targetViewer.setSelection((ISelection)new StructuredSelection((Object)condition));
        this.setSelection(condition, expression);
    }

    private String getExpression(TransitionType transition) {
        XmlTextNode type = transition.getExpression();
        String expression = type == null ? null : ModelUtils.getCDataString((FeatureMap)transition.getExpression().getMixed());
        return expression;
    }

    @Override
    public void loadFieldsFromElement(IModelElementNodeSymbol symbol, IModelElement element) {
        ModelType model = ModelUtils.findContainingModel((EObject)element);
        this.controller.intializeModel(model);
        super.loadFieldsFromElement(symbol, element);
        TransitionType transition = (TransitionType)element;
        this.forkButton.setSelection(transition.isForkOnTraversal());
        String expression = this.getExpression(transition);
        String condition = transition.getCondition();
        if (StringUtils.isEmpty((String)condition)) {
            condition = EXPRESSION_TYPES[0];
        }
        this.setSelection(condition, expression);
        this.targetViewer.setSelection((ISelection)new StructuredSelection((Object)condition));
        this.refreshDocument();
        this.transitionConditionEditor.getAdaptedSourceViewer().getTextWidget().setText(expression == null ? "" : expression.trim());
    }

    @Override
    public void loadElementFromFields(IModelElementNodeSymbol symbol, IModelElement element) {
        super.loadElementFromFields(symbol, element);
        TransitionType transition = (TransitionType)element;
        transition.setForkOnTraversal(this.forkButton.getSelection());
        String condition = this.transitionConditionEditor.getAdaptedSourceViewer().getTextWidget().getText().trim();
        String selection = (String)((IStructuredSelection)this.targetViewer.getSelection()).getFirstElement();
        transition.setCondition(selection);
        if (selection.equals(EXPRESSION_TYPES[1])) {
            transition.setExpression(null);
        } else {
            XmlTextNode expression = transition.getExpression();
            if (expression == null) {
                expression = CarnotWorkflowModelFactory.eINSTANCE.createXmlTextNode();
                transition.setExpression(expression);
            }
            if (!StringUtils.isEmpty((String)condition)) {
                ModelUtils.setCDataString((FeatureMap)expression.getMixed(), (String)condition, (boolean)true);
            } else {
                ModelUtils.setCDataString((FeatureMap)expression.getMixed(), (String)"true", (boolean)true);
            }
        }
    }

    @Override
    protected void contributeExtraControls(Composite composite) {
        this.txtId.getText().addVerifyListener((VerifyListener)new BlacklistVerifier("__internal_relocate_transition__"));
        this.model = ModelUtils.findContainingModel((EObject)this.getModelElement());
        WorkflowModelEditor editor = (WorkflowModelEditor)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        IEditorSite editorSite = editor.getEditorSite();
        this.project = WorkspaceUtils.getProjectFromEObject((EObject)this.getModelElement());
        this.forkButton = FormBuilder.createCheckBox((Composite)composite, (String)Diagram_Messages.CHECKBOX_ForkOnTraversal, (int)2);
        FormBuilder.createHorizontalSeparator((Composite)composite, (int)2);
        this.createTypeViewer(composite, Diagram_Messages.LB_ConditionType);
        this.conditionExpression = FormBuilder.createLabel((Composite)composite, (String)Diagram_Messages.LB_ConditionExpression, (int)2);
        IFile tempFileResource = GenericUtils.cleanFileStructure(this.getModelElement(), "conditions.js");
        this.transitionConditionEditor = new JSCompilationUnitEditor();
        this.transitionConditionEditor.setTheSite((IWorkbenchPartSite)editorSite);
        this.transitionConditionEditor.setInput((IEditorInput)new FileEditorInput(tempFileResource));
        this.sourceViewerComposite = new Composite(composite, 0);
        GridData svcData = new GridData();
        svcData.grabExcessHorizontalSpace = true;
        svcData.grabExcessVerticalSpace = true;
        svcData.horizontalSpan = 2;
        svcData.horizontalAlignment = 4;
        svcData.verticalAlignment = 4;
        this.sourceViewerComposite.setLayout((Layout)new FillLayout());
        this.sourceViewerComposite.setLayoutData((Object)svcData);
        this.transitionConditionEditor.createPartControl(this.sourceViewerComposite);
        this.conditionExpression.setVisible(false);
        this.sourceViewerComposite.setVisible(false);
    }

    public void refreshDocument() {
        this.transitionConditionEditor.getAdaptedSourceViewer().getDocument().set(this.controller.getMasterDocument());
        this.controller.recalculateRegions(this.transitionConditionEditor.getAdaptedSourceViewer().getDocument());
        JSCompilationUnitEditor.RegionWithLineOffset expressionRegion = this.controller.getExpressionRegion();
        this.transitionConditionEditor.getAdaptedSourceViewer().setVisibleRegion(expressionRegion.getOffset(), expressionRegion.getLength());
        this.transitionConditionEditor.setLineOffset(expressionRegion.getLineOffset());
    }

    private LabeledViewer createTypeViewer(Composite parent, String label) {
        LabeledCombo targetCombo = FormBuilder.createLabeledCombo((Composite)parent, (String)label);
        this.targetViewer = new ComboViewer(targetCombo.getCombo());
        this.targetViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                int i = 0;
                while (i < EXPRESSION_TYPES.length) {
                    if (EXPRESSION_TYPES[i].equals(element)) {
                        return EXPRESSION_TYPES[i];
                    }
                    ++i;
                }
                return null;
            }
        });
        int i = 0;
        while (i < EXPRESSION_TYPES.length) {
            this.targetViewer.add((Object)EXPRESSION_TYPES[i]);
            ++i;
        }
        this.targetViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                TransitionType transition = (TransitionType)TransitionPropertyPage.this.getModelElement();
                String selection = (String)((IStructuredSelection)event.getSelection()).getFirstElement();
                String expression = null;
                if (selection.equals(EXPRESSION_TYPES[0])) {
                    expression = TransitionPropertyPage.this.getExpression(transition);
                }
                if (StringUtils.isEmpty(expression)) {
                    expression = "true";
                }
                TransitionPropertyPage.this.setSelection(selection, expression);
            }
        });
        LabeledViewer labeledViewer = new LabeledViewer((StructuredViewer)this.targetViewer, targetCombo.getLabel());
        return labeledViewer;
    }

    private void setSelection(String selection, String expression) {
        if (expression == null) {
            expression = "";
        }
        if (selection.equals(EXPRESSION_TYPES[1])) {
            this.transitionConditionEditor.getAdaptedSourceViewer().getTextWidget().setText("");
            this.transitionConditionEditor.getAdaptedSourceViewer().setEditable(false);
            ((JSCompilationUnitEditor.AdaptedSourceViewer)this.transitionConditionEditor.getAdaptedSourceViewer()).setAutoCompletion(false);
            this.sourceViewerComposite.setEnabled(false);
            this.conditionExpression.setVisible(false);
            this.sourceViewerComposite.setVisible(false);
        } else {
            this.transitionConditionEditor.getAdaptedSourceViewer().setEditable(true);
            this.transitionConditionEditor.getAdaptedSourceViewer().getTextWidget().setText(expression.trim());
            ((JSCompilationUnitEditor.AdaptedSourceViewer)this.transitionConditionEditor.getAdaptedSourceViewer()).setAutoCompletion(true);
            this.sourceViewerComposite.setEnabled(true);
            this.conditionExpression.setVisible(true);
            this.sourceViewerComposite.setVisible(true);
        }
    }
}

