/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.properties;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.stardust.engine.core.preferences.configurationvariables.ConfigurationVariableScope;
import org.eclipse.stardust.model.xpdl.carnot.IModelElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelElementNodeSymbol;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.model.xpdl.carnot.util.ModelVariable;
import org.eclipse.stardust.model.xpdl.carnot.util.VariableContext;
import org.eclipse.stardust.model.xpdl.carnot.util.VariableContextHelper;
import org.eclipse.stardust.modeling.common.ui.jface.utils.FormBuilder;
import org.eclipse.stardust.modeling.core.Diagram_Messages;
import org.eclipse.stardust.modeling.core.editors.ui.TableUtil;
import org.eclipse.stardust.modeling.core.properties.AbstractModelElementPropertyPage;
import org.eclipse.stardust.modeling.core.properties.IButtonManager;
import org.eclipse.stardust.modeling.core.properties.LiteralSelectionDialog;
import org.eclipse.stardust.modeling.core.properties.ModelVariableContentProvider;
import org.eclipse.stardust.modeling.core.properties.ModelVariableLabelProvider;
import org.eclipse.stardust.modeling.core.properties.VariableReferencesLabelProvider;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

public class VariablesConfigurationPage
extends AbstractModelElementPropertyPage
implements IButtonManager {
    static final int ADD_BUTTON = 0;
    static final int DELETE_BUTTON = 1;
    static final int REFRESH_BUTTON = 2;
    static final int BUTTON_COUNT = 3;
    private Button[] buttons;
    private TableViewer viewer;
    List<ModelVariable> variablesOrg = new ArrayList<ModelVariable>();
    private TableViewer viewer2;
    private ModelType model;
    protected ModelVariable selectedVariable;
    private VariableContext variablesContext;

    protected String getOidLabel() {
        return Diagram_Messages.LB_OID;
    }

    @Override
    public void loadElementFromFields(IModelElementNodeSymbol symbol, IModelElement element) {
        this.variablesContext.saveVariables();
        this.handleModifications();
    }

    @Override
    public void loadFieldsFromElement(IModelElementNodeSymbol symbol, IModelElement element) {
        if (element instanceof ModelType) {
            this.model = (ModelType)element;
        }
        this.variablesContext = VariableContextHelper.getInstance().getContext(this.model);
        this.variablesContext.cleanupReferences();
        this.viewer.setInput((Object)this.variablesContext.getVariables());
        this.variablesOrg = this.cloneVariables();
        this.validateVariables();
    }

    private void handleModifications() {
        for (ModelVariable modelVariable : this.variablesOrg) {
            String newName = this.getChangedName(modelVariable);
            if (newName == null) continue;
            this.variablesContext.replaceVariable(modelVariable, newName);
        }
    }

    private List<ModelVariable> cloneVariables() {
        ArrayList<ModelVariable> result = new ArrayList<ModelVariable>();
        for (ModelVariable m : this.variablesContext.getVariables()) {
            result.add(m.clone());
        }
        return result;
    }

    @Override
    public Control createBody(Composite parent) {
        Composite composite = FormBuilder.createComposite((Composite)parent, (int)1);
        FormBuilder.createLabel((Composite)composite, (String)Diagram_Messages.LBL_VARIABLES);
        Table table = new Table(composite, 67584);
        table.setHeaderVisible(true);
        table.setLayoutData((Object)FormBuilder.createDefaultLimitedMultiLineWidgetGridData((int)200));
        FormBuilder.applyDefaultTextControlWidth((Control)table);
        this.viewer = new TableViewer(table);
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)VariablesConfigurationPage.this.viewer.getSelection();
                Object o = selection.getFirstElement();
                if (o instanceof ModelVariable) {
                    ModelVariable modelVariable;
                    VariablesConfigurationPage.this.selectedVariable = modelVariable = (ModelVariable)o;
                    List refList = VariablesConfigurationPage.this.variablesContext.getReferences(modelVariable);
                    if (refList != null) {
                        VariablesConfigurationPage.this.viewer2.setInput((Object)refList.toArray());
                    } else {
                        VariablesConfigurationPage.this.viewer2.setInput(new ArrayList());
                    }
                }
            }
        });
        TableUtil.createColumns(table, new String[]{Diagram_Messages.COL_NAME_Name, Diagram_Messages.COL_NAME_DefaultValue, Diagram_Messages.COL_NAME_Description, Diagram_Messages.COL_NAME_Type});
        TableUtil.setInitialColumnSizes(table, new int[]{30, 20, 30, 20});
        this.viewer.setLabelProvider((IBaseLabelProvider)new ModelVariableLabelProvider());
        this.viewer.setContentProvider((IContentProvider)new ModelVariableContentProvider());
        this.viewer.setFilters(new ViewerFilter[]{new VariableFilter()});
        this.attachCellEditors(this.viewer, parent);
        FormBuilder.createLabel((Composite)composite, (String)Diagram_Messages.LBL_REFERENCES);
        Table table2 = new Table(composite, 67584);
        table2.setHeaderVisible(true);
        table2.setLayoutData((Object)FormBuilder.createDefaultLimitedMultiLineWidgetGridData((int)200));
        FormBuilder.applyDefaultTextControlWidth((Control)table2);
        TableUtil.createColumns(table2, new String[]{Diagram_Messages.COL_MD_ELEMENT, Diagram_Messages.COL_ATTRIBUTE, Diagram_Messages.COL_VALUE});
        TableUtil.setInitialColumnSizes(table2, new int[]{35, 35, 35});
        this.viewer2 = new TableViewer(table2);
        this.viewer2.setLabelProvider((IBaseLabelProvider)new VariableReferencesLabelProvider(this.getEditor()));
        this.viewer2.setContentProvider((IContentProvider)new ArrayContentProvider());
        return composite;
    }

    @Override
    public Button[] createButtons(Composite parent) {
        Button[] buttons = new Button[3];
        buttons[0] = FormBuilder.createButton((Composite)parent, (String)Diagram_Messages.B_Add, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                VariablesConfigurationPage.this.variablesContext.getVariables().add(new ModelVariable(Diagram_Messages.CONFIGURATION_VARIABLE_NEW, "", ""));
                VariablesConfigurationPage.this.viewer.refresh();
                VariablesConfigurationPage.this.validateVariables();
            }
        });
        buttons[1] = FormBuilder.createButton((Composite)parent, (String)Diagram_Messages.B_Delete, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (VariablesConfigurationPage.this.selectedVariable != null) {
                    ModelVariable modelVariable = VariablesConfigurationPage.this.selectedVariable;
                    List refList = VariablesConfigurationPage.this.variablesContext.getReferences(modelVariable);
                    if (refList != null && !refList.isEmpty()) {
                        LiteralSelectionDialog dialog = new LiteralSelectionDialog(Display.getCurrent().getActiveShell(), modelVariable);
                        dialog.open();
                        if (!dialog.isCanceled()) {
                            modelVariable.setRemoved(true);
                            if (dialog.isDefaultValueSelected()) {
                                modelVariable.setName(modelVariable.getDefaultValue());
                            }
                            if (dialog.isEmptyLiteralSelected()) {
                                modelVariable.setName("");
                            }
                            if (dialog.isLiteralSelected()) {
                                modelVariable.setName(dialog.getLiteral());
                            }
                        }
                        VariablesConfigurationPage.this.validateVariables();
                    } else {
                        modelVariable.setRemoved(true);
                        modelVariable.setName("");
                        VariablesConfigurationPage.this.validateVariables();
                    }
                    VariablesConfigurationPage.this.viewer.refresh();
                }
            }
        });
        return buttons;
    }

    @Override
    public Object getSelection() {
        return null;
    }

    @Override
    public void updateButtons(Object selection, Button[] buttons) {
    }

    @Override
    public void contributeVerticalButtons(Composite parent) {
        this.buttons = this.createButtons(parent);
    }

    private void attachCellEditors(final TableViewer viewer, Composite parent) {
        viewer.setCellModifier(new ICellModifier(){

            private int getIndex(String value) {
                ConfigurationVariableScope[] scopes = ConfigurationVariableScope.values();
                int cnt = 1;
                ConfigurationVariableScope[] configurationVariableScopeArray = scopes;
                int n = scopes.length;
                int n2 = 0;
                while (n2 < n) {
                    ConfigurationVariableScope scope = configurationVariableScopeArray[n2];
                    if (scope.name().equals(value)) {
                        return cnt;
                    }
                    ++cnt;
                    ++n2;
                }
                return 0;
            }

            public boolean canModify(Object element, String property) {
                return !Diagram_Messages.COL_NAME_Type.equals(property);
            }

            public Object getValue(Object element, String property) {
                if (element instanceof ModelVariable) {
                    ModelVariable modelVariable = (ModelVariable)element;
                    String name = modelVariable.getName();
                    name = name.replace("${", "");
                    name = name.replace("}", "");
                    if (Diagram_Messages.COL_NAME_Name.equals(property)) {
                        return VariableContextHelper.getName((String)name);
                    }
                    if (Diagram_Messages.COL_NAME_DefaultValue.equals(property)) {
                        return modelVariable.getDefaultValue();
                    }
                    if (Diagram_Messages.COL_NAME_Description.equals(property)) {
                        return modelVariable.getDescription();
                    }
                    if (Diagram_Messages.COL_NAME_Type.equals(property)) {
                        String type = VariableContextHelper.getType((String)name);
                        return this.getIndex(type);
                    }
                }
                return "";
            }

            public void modify(Object element, String property, Object value) {
                if (element instanceof TableItem) {
                    ModelVariable modelVariable;
                    TableItem tableItem = (TableItem)element;
                    VariablesConfigurationPage.this.selectedVariable = modelVariable = (ModelVariable)tableItem.getData();
                    if (Diagram_Messages.COL_NAME_Name.equals(property) && VariablesConfigurationPage.this.variablesContext.isValidName(value.toString())) {
                        String name = modelVariable.getName();
                        name = name.replace("${", "");
                        name = name.replace("}", "");
                        String type = VariableContextHelper.getType((String)name);
                        modelVariable.setName("${" + value.toString() + ":" + type + "}");
                    }
                    if (Diagram_Messages.COL_NAME_DefaultValue.equals(property)) {
                        modelVariable.setDefaultValue(value.toString());
                    }
                    if (Diagram_Messages.COL_NAME_Description.equals(property)) {
                        modelVariable.setDescription(value.toString());
                    }
                    Diagram_Messages.COL_NAME_Type.equals(property);
                }
                VariablesConfigurationPage.this.validateVariables();
                viewer.refresh();
            }
        });
        ComboBoxCellEditor typeEditor = new ComboBoxCellEditor((Composite)viewer.getTable(), new String[0]){

            private String[] getScopes() {
                ConfigurationVariableScope[] scopes = ConfigurationVariableScope.values();
                String[] values = new String[scopes.length + 1];
                int cnt = 0;
                values[cnt] = "";
                ConfigurationVariableScope[] configurationVariableScopeArray = scopes;
                int n = scopes.length;
                int n2 = 0;
                while (n2 < n) {
                    ConfigurationVariableScope scope = configurationVariableScopeArray[n2];
                    values[++cnt] = scope.name();
                    ++n2;
                }
                return values;
            }

            protected void doSetValue(Object value) {
                int comboValue = 0;
                super.doSetValue((Object)comboValue);
            }

            public void setItems(String[] items) {
                super.setItems(this.getScopes());
            }
        };
        viewer.setCellEditors(new CellEditor[]{new TextCellEditor((Composite)viewer.getTable()), new TextCellEditor((Composite)viewer.getTable()), new TextCellEditor((Composite)viewer.getTable()), typeEditor});
        viewer.setColumnProperties(new String[]{Diagram_Messages.COL_NAME_Name, Diagram_Messages.COL_NAME_DefaultValue, Diagram_Messages.COL_NAME_Description, Diagram_Messages.COL_NAME_Type});
    }

    private void validateVariables() {
        this.provideError(null, true);
        for (ModelVariable modelVariable : this.variablesContext.getVariables()) {
            if (modelVariable.isRemoved()) continue;
            if (modelVariable.getName().equalsIgnoreCase(Diagram_Messages.CONFIGURATION_VARIABLE_NEW)) {
                this.provideError(Diagram_Messages.PROVIDE_ERROR_PROVIDE_A_VALID_NAME_FOR_NEW_VARIABLE, false);
            }
            if (this.nameExists(modelVariable, modelVariable.getName())) {
                this.provideError(MessageFormat.format(Diagram_Messages.PROVIDE_ERROR_DUPLICATE_VARIABLE, modelVariable.getName()), false);
            }
            if (!this.variablesContext.isValidName(modelVariable.getName())) {
                this.provideError(MessageFormat.format(Diagram_Messages.PROVIDE_ERROR_IS_NOT_A_VALID_VARIABLE_NAME, modelVariable.getName()), false);
            }
            if (this.variablesContext.isValidType(modelVariable.getName())) continue;
            this.provideError(MessageFormat.format(Diagram_Messages.PROVIDE_ERROR_IS_NOT_A_VALID_VARIABLE_NAME_TYPE, modelVariable.getName()), false);
        }
    }

    private void provideError(String errorMessage, boolean valid) {
        this.setErrorMessage(errorMessage);
        this.setValid(valid);
        this.getApplyButton().setEnabled(valid);
        this.buttons[0].setEnabled(valid);
    }

    protected boolean nameExists(ModelVariable editedVariable, String string) {
        for (ModelVariable modelVariable : this.variablesContext.getVariables()) {
            if (modelVariable.isRemoved() || !modelVariable.getName().equals(string) || editedVariable.equals(modelVariable)) continue;
            return true;
        }
        return false;
    }

    private String getChangedName(ModelVariable orgModelVariable) {
        ModelVariable modelVariable = (ModelVariable)this.variablesContext.getVariables().get(this.variablesOrg.indexOf(orgModelVariable));
        if (!modelVariable.getName().equals(orgModelVariable.getName())) {
            return modelVariable.getName();
        }
        return null;
    }

    @Override
    protected void performDefaults() {
        if (this.variablesContext != null && this.variablesContext.getVariables() != null) {
            this.variablesContext.getVariables().clear();
            this.variablesContext.getVariables().addAll(this.variablesOrg);
        }
        this.viewer.refresh(true);
        super.performDefaults();
        this.validateVariables();
    }

    public boolean performCancel() {
        if (this.variablesContext != null && this.variablesContext.getVariables() != null) {
            this.variablesContext.getVariables().clear();
            this.variablesContext.getVariables().addAll(this.variablesOrg);
        }
        return super.performCancel();
    }

    private class VariableFilter
    extends ViewerFilter {
        private VariableFilter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            return !((ModelVariable)element).isRemoved();
        }
    }
}

