/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.search;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.stardust.common.StringUtils;
import org.eclipse.stardust.engine.extensions.dms.data.DmsConstants;
import org.eclipse.stardust.model.xpdl.carnot.AccessPointType;
import org.eclipse.stardust.model.xpdl.carnot.ActivityType;
import org.eclipse.stardust.model.xpdl.carnot.ApplicationType;
import org.eclipse.stardust.model.xpdl.carnot.AttributeType;
import org.eclipse.stardust.model.xpdl.carnot.BindActionType;
import org.eclipse.stardust.model.xpdl.carnot.ConditionalPerformerType;
import org.eclipse.stardust.model.xpdl.carnot.DataMappingType;
import org.eclipse.stardust.model.xpdl.carnot.DataPathType;
import org.eclipse.stardust.model.xpdl.carnot.DataType;
import org.eclipse.stardust.model.xpdl.carnot.DataTypeType;
import org.eclipse.stardust.model.xpdl.carnot.DiagramType;
import org.eclipse.stardust.model.xpdl.carnot.EventActionType;
import org.eclipse.stardust.model.xpdl.carnot.EventHandlerType;
import org.eclipse.stardust.model.xpdl.carnot.GenericLinkConnectionType;
import org.eclipse.stardust.model.xpdl.carnot.IExtensibleElement;
import org.eclipse.stardust.model.xpdl.carnot.IIdentifiableModelElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelParticipant;
import org.eclipse.stardust.model.xpdl.carnot.IdentifiableReference;
import org.eclipse.stardust.model.xpdl.carnot.LaneSymbol;
import org.eclipse.stardust.model.xpdl.carnot.LinkTypeType;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.model.xpdl.carnot.OrganizationType;
import org.eclipse.stardust.model.xpdl.carnot.ParameterMappingType;
import org.eclipse.stardust.model.xpdl.carnot.ParticipantType;
import org.eclipse.stardust.model.xpdl.carnot.PoolSymbol;
import org.eclipse.stardust.model.xpdl.carnot.ProcessDefinitionType;
import org.eclipse.stardust.model.xpdl.carnot.RoleType;
import org.eclipse.stardust.model.xpdl.carnot.TransitionType;
import org.eclipse.stardust.model.xpdl.carnot.TriggerType;
import org.eclipse.stardust.model.xpdl.carnot.UnbindActionType;
import org.eclipse.stardust.model.xpdl.carnot.XmlTextNode;
import org.eclipse.stardust.model.xpdl.carnot.util.AttributeUtil;
import org.eclipse.stardust.model.xpdl.carnot.util.ModelUtils;
import org.eclipse.stardust.model.xpdl.xpdl2.ExternalPackage;
import org.eclipse.stardust.model.xpdl.xpdl2.TypeDeclarationType;
import org.eclipse.stardust.model.xpdl.xpdl2.util.TypeDeclarationUtils;
import org.eclipse.stardust.modeling.core.utils.GenericUtils;
import org.eclipse.xsd.XSDImport;
import org.eclipse.xsd.XSDSchema;

public class ElementReferenceSearcher {
    private ModelType model;
    private List processes;
    private Map matchedElements;
    private EObject checkElement;

    public Map search(EObject element) {
        this.matchedElements = new HashMap();
        this.model = ModelUtils.findContainingModel((EObject)element);
        this.checkElement = element;
        this.search();
        return this.matchedElements;
    }

    public void search() {
        this.processes = this.model.getProcessDefinition();
        if (this.checkElement instanceof ExternalPackage) {
            this.checkTypeDeclaration((ExternalPackage)this.checkElement);
            this.isElementUsedInProcesses((ExternalPackage)this.checkElement);
        }
        if (this.checkElement instanceof TypeDeclarationType) {
            this.checkTypeDeclaration((TypeDeclarationType)this.checkElement);
            this.isElementUsedinApplications(this.checkElement);
        } else if (this.checkElement instanceof ApplicationType) {
            this.isElementUsedInProcesses(this.checkElement);
        } else if (this.checkElement instanceof DataType) {
            this.isElementUsedInProcesses(this.checkElement);
            this.isDataUsedInConditionalPerformer(this.checkElement);
            this.isDataUsedInOrganization(this.checkElement);
        } else if (this.checkElement instanceof LinkTypeType) {
            this.isElementUsedInProcesses(this.checkElement);
            this.isElementUsedinModelDiagrams(this.checkElement);
        } else if (this.checkElement instanceof IModelParticipant) {
            this.isElementUsedInProcesses(this.checkElement);
            this.isParticipantUsedInOrganizations(this.checkElement);
        } else if (this.checkElement instanceof TransitionType || this.checkElement instanceof ProcessDefinitionType || this.checkElement instanceof ActivityType) {
            this.isElementUsedInProcesses(this.checkElement);
        }
    }

    private void addChildren(EObject container, List elements) {
        ArrayList modelChildren = (ArrayList)this.matchedElements.get(container);
        if (modelChildren == null) {
            modelChildren = new ArrayList();
        }
        modelChildren.addAll(elements);
        this.matchedElements.put(container, modelChildren);
    }

    private void checkTypeDeclaration(ExternalPackage externalPackage) {
        ArrayList<DataType> elements = new ArrayList<DataType>();
        EList datas = this.model.getData();
        for (DataType data : datas) {
            if (data.getExternalReference() == null || !externalPackage.getId().equalsIgnoreCase(data.getExternalReference().getLocation())) continue;
            elements.add(data);
        }
        if (!elements.isEmpty()) {
            this.addChildren((EObject)this.model, elements);
        }
    }

    private void checkTypeDeclaration(TypeDeclarationType element) {
        ArrayList<Object> elements = new ArrayList<Object>();
        EList typeDeclarations = this.model.getTypeDeclarations().getTypeDeclaration();
        for (TypeDeclarationType typeDeclaration : typeDeclarations) {
            List xsdImports;
            XSDSchema schema = typeDeclaration.getSchema();
            if (schema == null || (xsdImports = TypeDeclarationUtils.getImports((XSDSchema)schema)) == null) continue;
            for (XSDImport xsdImport : xsdImports) {
                String nextTypeId;
                String schemaLocation = xsdImport.getSchemaLocation();
                if (schemaLocation == null || !schemaLocation.startsWith("urn:internal:") || !(nextTypeId = schemaLocation.substring("urn:internal:".length())).equals(element.getId())) continue;
                elements.add(typeDeclaration);
            }
        }
        EList datas = this.model.getData();
        for (DataType data : datas) {
            String structuredDataId;
            DataTypeType type = data.getType();
            if (type != null && type.getId().equals("struct") || type.getId().equals("primitive")) {
                structuredDataId = AttributeUtil.getAttributeValue((IExtensibleElement)data, (String)"carnot:engine:dataType");
                if (StringUtils.isEmpty((String)structuredDataId) || !structuredDataId.equals(element.getId())) continue;
                elements.add(data);
                continue;
            }
            if (!GenericUtils.isDMSDataType(data) || StringUtils.isEmpty((String)(structuredDataId = AttributeUtil.getAttributeValue((IExtensibleElement)data, (String)DmsConstants.RESOURCE_METADATA_SCHEMA_ATT))) || !structuredDataId.equals(element.getId())) continue;
            elements.add(data);
        }
        if (!elements.isEmpty()) {
            this.addChildren((EObject)this.model, elements);
        }
    }

    private void isElementUsedinApplications(EObject element) {
        ArrayList<ApplicationType> elements = new ArrayList<ApplicationType>();
        EList applications = this.model.getApplication();
        Iterator it = applications.iterator();
        while (it.hasNext()) {
            boolean addApplication = false;
            ApplicationType application = (ApplicationType)it.next();
            EList accessPoints = application.getAccessPoint();
            for (AccessPointType accessPoint : accessPoints) {
                TypeDeclarationType declaration = (TypeDeclarationType)AttributeUtil.getIdentifiable((IExtensibleElement)accessPoint, (String)"carnot:engine:dataType");
                if (declaration == null || !declaration.equals(element)) continue;
                addApplication = true;
            }
            if (!addApplication) continue;
            elements.add(application);
        }
        if (!elements.isEmpty()) {
            this.addChildren((EObject)this.model, elements);
        }
    }

    private void isElementUsedinModelDiagrams(EObject element) {
        ArrayList<DiagramType> elements = new ArrayList<DiagramType>();
        EList diagrams = this.model.getDiagram();
        for (DiagramType diagram : diagrams) {
            if (!this.isElementUsedinDiagram(diagram, element)) continue;
            elements.add(diagram);
        }
        if (!elements.isEmpty()) {
            this.addChildren((EObject)this.model, elements);
        }
    }

    private boolean isElementUsedinDiagram(DiagramType diagram, EObject element) {
        EList pools = diagram.getPoolSymbols();
        for (PoolSymbol pool : pools) {
            for (LaneSymbol lane : pool.getLanes()) {
                IModelParticipant participant = lane.getParticipantReference();
                if (participant == null || !participant.equals(element)) continue;
                return true;
            }
        }
        int p = 0;
        while (p < pools.size()) {
            PoolSymbol pool;
            pool = (PoolSymbol)pools.get(p);
            EList genericLinks = pool.getGenericLinkConnection();
            int i = 0;
            while (i < genericLinks.size()) {
                GenericLinkConnectionType connection = (GenericLinkConnectionType)genericLinks.get(i);
                LinkTypeType modelElement = connection.getLinkType();
                if (modelElement.equals(element)) {
                    return true;
                }
                ++i;
            }
            EList lanes = pool.getLanes();
            int l = 0;
            while (l < lanes.size()) {
                LaneSymbol lane = (LaneSymbol)lanes.get(l);
                genericLinks = lane.getGenericLinkConnection();
                int i2 = 0;
                while (i2 < genericLinks.size()) {
                    GenericLinkConnectionType connection = (GenericLinkConnectionType)genericLinks.get(i2);
                    LinkTypeType modelElement = connection.getLinkType();
                    if (modelElement.equals(element)) {
                        return true;
                    }
                    ++i2;
                }
                ++l;
            }
            ++p;
        }
        EList genericLinks = diagram.getGenericLinkConnection();
        int i = 0;
        while (i < genericLinks.size()) {
            GenericLinkConnectionType connection = (GenericLinkConnectionType)genericLinks.get(i);
            LinkTypeType modelElement = connection.getLinkType();
            if (modelElement.equals(element)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private void isParticipantUsedInOrganizations(EObject element) {
        ArrayList<OrganizationType> elements = new ArrayList<OrganizationType>();
        EList organizations = this.model.getOrganization();
        Iterator i = organizations.iterator();
        while (i.hasNext()) {
            boolean addOrganization = false;
            OrganizationType organization = (OrganizationType)i.next();
            EList participants = organization.getParticipant();
            int cnt = 0;
            while (cnt < participants.size()) {
                IModelParticipant participant = ((ParticipantType)participants.get(cnt)).getParticipant();
                if (participant.equals(element)) {
                    addOrganization = true;
                }
                ++cnt;
            }
            RoleType role = organization.getTeamLead();
            if (role != null && role.equals(element)) {
                addOrganization = true;
            }
            if (!addOrganization) continue;
            elements.add(organization);
        }
        if (!elements.isEmpty()) {
            this.addChildren((EObject)this.model, elements);
        }
    }

    private void isDataUsedInOrganization(EObject element) {
        ArrayList<OrganizationType> elements = new ArrayList<OrganizationType>();
        EList organizations = this.model.getOrganization();
        for (OrganizationType organization : organizations) {
            DataType data;
            String dataId;
            if (!AttributeUtil.getBooleanValue((IExtensibleElement)organization, (String)"carnot:engine:bound") || StringUtils.isEmpty((String)(dataId = AttributeUtil.getAttributeValue((IExtensibleElement)organization, (String)"carnot:engine:dataId"))) || (data = (DataType)ModelUtils.findElementById((List)this.model.getData(), (String)dataId)) == null || !data.equals(element)) continue;
            elements.add(organization);
        }
        if (!elements.isEmpty()) {
            this.addChildren((EObject)this.model, elements);
        }
    }

    private void isDataUsedInConditionalPerformer(EObject element) {
        ArrayList<ConditionalPerformerType> elements = new ArrayList<ConditionalPerformerType>();
        EList conditionalPerformers = this.model.getConditionalPerformer();
        Iterator i = conditionalPerformers.iterator();
        while (i.hasNext()) {
            DataType realmData;
            String dataId;
            boolean addConditionalPerformer = false;
            ConditionalPerformerType conditionalPerformer = (ConditionalPerformerType)i.next();
            DataType dataType = conditionalPerformer.getData();
            if (dataType != null && dataType.equals(element)) {
                addConditionalPerformer = true;
            }
            if (!StringUtils.isEmpty((String)(dataId = AttributeUtil.getAttributeValue((IExtensibleElement)conditionalPerformer, (String)"carnot:engine:conditionalPerformer:realmData"))) && (realmData = (DataType)ModelUtils.findElementById((List)this.model.getData(), (String)dataId)) != null && realmData.equals(element)) {
                addConditionalPerformer = true;
            }
            if (!addConditionalPerformer) continue;
            elements.add(conditionalPerformer);
        }
        if (!elements.isEmpty()) {
            this.addChildren((EObject)this.model, elements);
        }
    }

    private void isElementUsedInProcesses(ExternalPackage externalPackage) {
        ArrayList modelElements = new ArrayList();
        for (ProcessDefinitionType process : this.processes) {
            ArrayList<ActivityType> elements = new ArrayList<ActivityType>();
            EList activities = process.getActivity();
            Iterator it = activities.iterator();
            while (it.hasNext()) {
                boolean addActivity = false;
                ActivityType activity = (ActivityType)it.next();
                if (activity.getExternalRef() != null && activity.getExternalRef().getPackageRef().equals(externalPackage)) {
                    addActivity = true;
                }
                if (addActivity) {
                    elements.add(activity);
                }
                if (elements.isEmpty()) continue;
                this.addChildren((EObject)process, elements);
                modelElements.remove(process);
                addActivity = false;
                elements.clear();
            }
        }
        if (!modelElements.isEmpty()) {
            this.addChildren((EObject)this.model, modelElements);
        }
    }

    private void isElementUsedInProcesses(EObject element) {
        ArrayList<ProcessDefinitionType> modelElements = new ArrayList<ProcessDefinitionType>();
        for (ProcessDefinitionType process : this.processes) {
            if (this.isElementUsedInEventHandlers((List)process.getEventHandler(), element)) {
                modelElements.add(process);
            }
            ArrayList elements = new ArrayList();
            Object activities = process.getActivity();
            if (element instanceof ActivityType) {
                ProcessDefinitionType activityProcess = ((ActivityType)element).getImplementationProcess();
                if (activityProcess != null && activityProcess.equals(process)) {
                    modelElements.add(process);
                }
                activities = new ArrayList();
                if (ModelUtils.findContainingProcess((EObject)element).equals(process)) {
                    activities.add(element);
                }
            }
            Iterator it = activities.iterator();
            while (it.hasNext()) {
                IModelParticipant activityParticipant;
                ProcessDefinitionType activityProcess;
                ApplicationType activityApplication;
                boolean addActivity = false;
                ActivityType activity = (ActivityType)it.next();
                if (this.isElementUsedInDataMappings(activity, element)) {
                    addActivity = true;
                }
                if (this.isElementUsedInEventHandlers((List)activity.getEventHandler(), element)) {
                    addActivity = true;
                }
                HashSet<TransitionType> transitions = new HashSet<TransitionType>();
                EList inTransitions = activity.getInTransitions();
                EList outTransitions = activity.getOutTransitions();
                for (TransitionType transition : inTransitions) {
                    if (transition.equals(element)) {
                        addActivity = true;
                    }
                    if (transition.getFrom().equals(element)) {
                        transitions.add(transition);
                    }
                    if (!transition.getTo().equals(element)) continue;
                    transitions.add(transition);
                }
                for (TransitionType transition : outTransitions) {
                    if (transition.equals(element)) {
                        addActivity = true;
                    }
                    if (transition.getFrom().equals(element)) {
                        transitions.add(transition);
                    }
                    if (!transition.getTo().equals(element)) continue;
                    transitions.add(transition);
                }
                if (!transitions.isEmpty()) {
                    elements.addAll(transitions);
                }
                if ((activityApplication = activity.getApplication()) != null && activityApplication.equals(element)) {
                    addActivity = true;
                }
                if ((activityProcess = activity.getImplementationProcess()) != null && activityProcess.equals(element)) {
                    addActivity = true;
                }
                if ((activityParticipant = activity.getPerformer()) != null && activityParticipant.equals(element)) {
                    addActivity = true;
                }
                if (!addActivity) continue;
                elements.add(activity);
            }
            EList triggers = process.getTrigger();
            Iterator it2 = triggers.iterator();
            while (it2.hasNext()) {
                boolean addTrigger = false;
                TriggerType trigger = (TriggerType)it2.next();
                EList attributes = trigger.getAttribute();
                int a = 0;
                while (a < attributes.size()) {
                    EObject referencedElement;
                    AttributeType attribute = (AttributeType)attributes.get(a);
                    IdentifiableReference reference = attribute.getReference();
                    if (reference != null && (referencedElement = reference.getIdentifiable()) != null && referencedElement.equals(element)) {
                        addTrigger = true;
                    }
                    ++a;
                }
                EList mappings = trigger.getParameterMapping();
                int m = 0;
                while (m < mappings.size()) {
                    ParameterMappingType mappingType = (ParameterMappingType)mappings.get(m);
                    DataType data = mappingType.getData();
                    if (data != null && data.equals(element)) {
                        addTrigger = true;
                    }
                    ++m;
                }
                if (!addTrigger) continue;
                elements.add(trigger);
            }
            if (element instanceof DataType) {
                EList transitions = process.getTransition();
                for (TransitionType transition : transitions) {
                    String dataId;
                    String expression;
                    String condition = transition.getCondition();
                    if (!condition.equals("CONDITION")) continue;
                    XmlTextNode type = transition.getExpression();
                    String string = expression = type == null ? null : ModelUtils.getCDataString((FeatureMap)transition.getExpression().getMixed());
                    if (StringUtils.isEmpty((String)expression) || expression.equals("true") || expression.equals("false") || expression.indexOf(dataId = ((DataType)element).getId()) == -1) continue;
                    elements.add(transition);
                }
            }
            EList diagrams = process.getDiagram();
            for (DiagramType diagram : diagrams) {
                if (!this.isElementUsedinDiagram(diagram, element)) continue;
                elements.add(diagram);
            }
            EList dataPathList = process.getDataPath();
            for (DataPathType dataPath : dataPathList) {
                DataType data = dataPath.getData();
                if (data == null || !data.equals(element)) continue;
                elements.add(dataPath);
            }
            if (elements.isEmpty()) continue;
            this.addChildren((EObject)process, elements);
            modelElements.remove(process);
        }
        if (!modelElements.isEmpty()) {
            this.addChildren((EObject)this.model, modelElements);
        }
    }

    private boolean isElementUsedInDataMappings(ActivityType activity, EObject element) {
        EList dataMappings = activity.getDataMapping();
        for (DataMappingType dataMapping : dataMappings) {
            DataType data = dataMapping.getData();
            if (data == null || !data.equals(element)) continue;
            return true;
        }
        return false;
    }

    private boolean isElementUsedInEventHandlers(List eventHandlers, EObject element) {
        for (EventHandlerType eventHandler : eventHandlers) {
            EList eventActions = eventHandler.getEventAction();
            for (EventActionType actionType : eventActions) {
                if (!(actionType instanceof IExtensibleElement)) continue;
                EList attributes = actionType.getAttribute();
                for (AttributeType attribute : attributes) {
                    IIdentifiableModelElement referencedElement;
                    if (attribute == null || attribute.getReference() == null || (referencedElement = (IIdentifiableModelElement)attribute.getReference().getIdentifiable()) == null || !referencedElement.equals(element)) continue;
                    return true;
                }
            }
            EList bindActions = eventHandler.getBindAction();
            for (BindActionType actionType : bindActions) {
                if (!(actionType instanceof IExtensibleElement)) continue;
                EList attributes = actionType.getAttribute();
                for (AttributeType attribute : attributes) {
                    IIdentifiableModelElement referencedElement;
                    if (attribute == null || attribute.getReference() == null || (referencedElement = (IIdentifiableModelElement)attribute.getReference().getIdentifiable()) == null || !referencedElement.equals(element)) continue;
                    return true;
                }
            }
            EList unbindActions = eventHandler.getUnbindAction();
            for (UnbindActionType actionType : unbindActions) {
                if (!(actionType instanceof IExtensibleElement)) continue;
                EList attributes = actionType.getAttribute();
                for (AttributeType attribute : attributes) {
                    IIdentifiableModelElement referencedElement;
                    if (attribute == null || attribute.getReference() == null || (referencedElement = (IIdentifiableModelElement)attribute.getReference().getIdentifiable()) == null || !referencedElement.equals(element)) continue;
                    return true;
                }
            }
        }
        return false;
    }
}

