/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.search;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.stardust.common.StringUtils;
import org.eclipse.stardust.engine.extensions.dms.data.DmsConstants;
import org.eclipse.stardust.model.xpdl.carnot.AccessPointType;
import org.eclipse.stardust.model.xpdl.carnot.ActivityType;
import org.eclipse.stardust.model.xpdl.carnot.ApplicationType;
import org.eclipse.stardust.model.xpdl.carnot.AttributeType;
import org.eclipse.stardust.model.xpdl.carnot.BindActionType;
import org.eclipse.stardust.model.xpdl.carnot.ConditionalPerformerType;
import org.eclipse.stardust.model.xpdl.carnot.DataMappingType;
import org.eclipse.stardust.model.xpdl.carnot.DataPathType;
import org.eclipse.stardust.model.xpdl.carnot.DataType;
import org.eclipse.stardust.model.xpdl.carnot.DataTypeType;
import org.eclipse.stardust.model.xpdl.carnot.DiagramType;
import org.eclipse.stardust.model.xpdl.carnot.EventActionType;
import org.eclipse.stardust.model.xpdl.carnot.EventHandlerType;
import org.eclipse.stardust.model.xpdl.carnot.GenericLinkConnectionType;
import org.eclipse.stardust.model.xpdl.carnot.IExtensibleElement;
import org.eclipse.stardust.model.xpdl.carnot.IIdentifiableModelElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelParticipant;
import org.eclipse.stardust.model.xpdl.carnot.IdentifiableReference;
import org.eclipse.stardust.model.xpdl.carnot.LaneSymbol;
import org.eclipse.stardust.model.xpdl.carnot.LinkTypeType;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.model.xpdl.carnot.OrganizationType;
import org.eclipse.stardust.model.xpdl.carnot.ParameterMappingType;
import org.eclipse.stardust.model.xpdl.carnot.ParticipantType;
import org.eclipse.stardust.model.xpdl.carnot.PoolSymbol;
import org.eclipse.stardust.model.xpdl.carnot.ProcessDefinitionType;
import org.eclipse.stardust.model.xpdl.carnot.RoleType;
import org.eclipse.stardust.model.xpdl.carnot.TransitionType;
import org.eclipse.stardust.model.xpdl.carnot.TriggerType;
import org.eclipse.stardust.model.xpdl.carnot.UnbindActionType;
import org.eclipse.stardust.model.xpdl.carnot.XmlTextNode;
import org.eclipse.stardust.model.xpdl.carnot.util.AttributeUtil;
import org.eclipse.stardust.model.xpdl.carnot.util.ModelUtils;
import org.eclipse.stardust.model.xpdl.xpdl2.TypeDeclarationType;
import org.eclipse.stardust.model.xpdl.xpdl2.util.TypeDeclarationUtils;
import org.eclipse.stardust.modeling.core.Diagram_Messages;
import org.eclipse.stardust.modeling.core.utils.GenericUtils;
import org.eclipse.xsd.XSDImport;
import org.eclipse.xsd.XSDSchema;

public class ElementSearcher {
    private ModelType model;
    private List processes;
    private List diagrams;
    private Set transitionDatas;
    private Map matchedElements;
    private String searchString;

    public Map search(ModelType model, String search) {
        this.matchedElements = new HashMap();
        this.model = model;
        this.searchString = search;
        if (!StringUtils.isEmpty((String)search)) {
            this.search();
        }
        return this.matchedElements;
    }

    public void search() {
        this.processes = this.model.getProcessDefinition();
        this.getTransitionDatas();
        this.getDiagrams();
        this.checkTypeDeclarations();
        this.checkApplications();
        this.checkData();
        this.checkIModelParticipants();
        this.checkLinkTypes();
    }

    private void getDiagrams() {
        this.diagrams = new ArrayList();
        for (ProcessDefinitionType process : this.processes) {
            EList currentDiagrams = process.getDiagram();
            if (currentDiagrams.isEmpty()) continue;
            this.diagrams.addAll(currentDiagrams);
        }
        EList currentDiagrams = this.model.getDiagram();
        if (!currentDiagrams.isEmpty()) {
            this.diagrams.addAll(currentDiagrams);
        }
    }

    private void getTransitionDatas() {
        this.transitionDatas = new HashSet();
        EList datas = this.model.getData();
        ArrayList transitions = new ArrayList();
        for (ProcessDefinitionType process : this.processes) {
            EList processTransitions = process.getTransition();
            if (processTransitions.isEmpty()) continue;
            transitions.addAll(processTransitions);
        }
        for (TransitionType transition : transitions) {
            String expression;
            String condition = transition.getCondition();
            if (!condition.equals("CONDITION")) continue;
            XmlTextNode type = transition.getExpression();
            String string = expression = type == null ? null : ModelUtils.getCDataString((FeatureMap)transition.getExpression().getMixed());
            if (StringUtils.isEmpty((String)expression) || expression.equals("true") || expression.equals("false")) continue;
            for (DataType data : datas) {
                String dataId = data.getId();
                if (expression.indexOf(dataId) == -1) continue;
                this.transitionDatas.add(data);
            }
        }
    }

    private void addModelChildren(List elements) {
        ArrayList modelChildren = (ArrayList)this.matchedElements.get(this.model);
        if (modelChildren == null) {
            modelChildren = new ArrayList();
        }
        modelChildren.addAll(elements);
        this.matchedElements.put(this.model, modelChildren);
    }

    private void checkTypeDeclarations() {
        ArrayList<TypeDeclarationType> elements = new ArrayList<TypeDeclarationType>();
        EList typeDeclarations = this.model.getTypeDeclarations().getTypeDeclaration();
        if (typeDeclarations.isEmpty()) {
            return;
        }
        for (TypeDeclarationType typeDeclaration : typeDeclarations) {
            if (this.isTypeDeclarationUsedInDatas(typeDeclaration) || this.isTypeDeclarationUsedInTypeDeclarations(typeDeclaration) || this.isElementUsedinApplications((EObject)typeDeclaration)) continue;
            elements.add(typeDeclaration);
        }
        if (!elements.isEmpty()) {
            this.addModelChildren(elements);
        }
    }

    private void checkApplications() {
        ArrayList<ApplicationType> elements = new ArrayList<ApplicationType>();
        EList applications = this.model.getApplication();
        if (applications.isEmpty()) {
            return;
        }
        for (ApplicationType application : applications) {
            if (this.isElementUsedInProcesses((EObject)application)) continue;
            elements.add(application);
        }
        if (!elements.isEmpty()) {
            this.addModelChildren(elements);
        }
    }

    private void checkData() {
        ArrayList<DataType> elements = new ArrayList<DataType>();
        EList datas = this.model.getData();
        if (datas.isEmpty()) {
            return;
        }
        for (DataType data : datas) {
            if (data.isPredefined() || this.isElementUsedInProcesses((EObject)data) || this.isDataUsedInConditionalPerformer(data) || this.transitionDatas.contains(data)) continue;
            elements.add(data);
        }
        if (!elements.isEmpty()) {
            this.addModelChildren(elements);
        }
    }

    private void checkIModelParticipants() {
        ArrayList<IModelParticipant> elements = new ArrayList<IModelParticipant>();
        ArrayList participants = new ArrayList();
        EList roles = this.model.getRole();
        EList conditionalPerformers = this.model.getConditionalPerformer();
        EList organizations = this.model.getOrganization();
        if (!roles.isEmpty()) {
            participants.addAll(roles);
        }
        if (!conditionalPerformers.isEmpty()) {
            participants.addAll(conditionalPerformers);
        }
        if (!organizations.isEmpty()) {
            participants.addAll(organizations);
        }
        for (IModelParticipant element : participants) {
            if (element.getId().equals(Diagram_Messages.BASENAME_Administrator) || this.isParticipantUsedInOrganizations(element) || this.isElementUsedInProcesses((EObject)element)) continue;
            elements.add(element);
        }
        if (!elements.isEmpty()) {
            this.addModelChildren(elements);
        }
    }

    private void checkProcesses() {
        ArrayList elements = new ArrayList();
        EList processes = this.model.getProcessDefinition();
        if (processes.isEmpty()) {
            return;
        }
        for (ProcessDefinitionType process : processes) {
            if (!process.getEventHandler().isEmpty() || !process.getDataPath().isEmpty()) continue;
            process.getExecutingActivities().isEmpty();
        }
        if (!elements.isEmpty()) {
            this.addModelChildren(elements);
        }
    }

    private void checkLinkTypes() {
        ArrayList<LinkTypeType> elements = new ArrayList<LinkTypeType>();
        EList linkTypes = this.model.getLinkType();
        if (linkTypes.isEmpty()) {
            return;
        }
        for (LinkTypeType linkType : linkTypes) {
            if (this.isLinkTypeUsedinDiagrams(linkType)) continue;
            elements.add(linkType);
        }
        if (!elements.isEmpty()) {
            this.addModelChildren(elements);
        }
    }

    private boolean isElementUsedinApplications(EObject element) {
        EList applications = this.model.getApplication();
        for (ApplicationType application : applications) {
            EList accessPoints = application.getAccessPoint();
            for (AccessPointType accessPoint : accessPoints) {
                TypeDeclarationType declaration = (TypeDeclarationType)AttributeUtil.getIdentifiable((IExtensibleElement)accessPoint, (String)"carnot:engine:dataType");
                if (declaration == null || !declaration.equals(element)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isLinkTypeUsedinDiagrams(LinkTypeType link) {
        for (DiagramType diagram : this.diagrams) {
            EList pools = diagram.getPoolSymbols();
            int p = 0;
            while (p < pools.size()) {
                PoolSymbol pool = (PoolSymbol)pools.get(p);
                EList genericLinks = pool.getGenericLinkConnection();
                int i = 0;
                while (i < genericLinks.size()) {
                    GenericLinkConnectionType connection = (GenericLinkConnectionType)genericLinks.get(i);
                    LinkTypeType modelElement = connection.getLinkType();
                    if (modelElement.equals(link)) {
                        return true;
                    }
                    ++i;
                }
                EList lanes = pool.getLanes();
                int l = 0;
                while (l < lanes.size()) {
                    LaneSymbol lane = (LaneSymbol)lanes.get(l);
                    genericLinks = lane.getGenericLinkConnection();
                    int i2 = 0;
                    while (i2 < genericLinks.size()) {
                        GenericLinkConnectionType connection = (GenericLinkConnectionType)genericLinks.get(i2);
                        LinkTypeType modelElement = connection.getLinkType();
                        if (modelElement.equals(link)) {
                            return true;
                        }
                        ++i2;
                    }
                    ++l;
                }
                ++p;
            }
            EList genericLinks = diagram.getGenericLinkConnection();
            int i = 0;
            while (i < genericLinks.size()) {
                GenericLinkConnectionType connection = (GenericLinkConnectionType)genericLinks.get(i);
                LinkTypeType modelElement = connection.getLinkType();
                if (modelElement.equals(link)) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    private boolean isTypeDeclarationUsedInTypeDeclarations(TypeDeclarationType element) {
        EList typeDeclarations = this.model.getTypeDeclarations().getTypeDeclaration();
        for (TypeDeclarationType typeDeclaration : typeDeclarations) {
            List xsdImports;
            XSDSchema schema = typeDeclaration.getSchema();
            if (schema == null || (xsdImports = TypeDeclarationUtils.getImports((XSDSchema)schema)) == null) continue;
            for (XSDImport xsdImport : xsdImports) {
                String nextTypeId;
                String schemaLocation = xsdImport.getSchemaLocation();
                if (schemaLocation == null || !schemaLocation.startsWith("urn:internal:") || !(nextTypeId = schemaLocation.substring("urn:internal:".length())).equals(element.getId())) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isTypeDeclarationUsedInDatas(TypeDeclarationType element) {
        EList datas = this.model.getData();
        for (DataType data : datas) {
            String structuredDataId;
            DataTypeType type = data.getType();
            if (!(type != null && type.getId().equals("struct") ? !StringUtils.isEmpty((String)(structuredDataId = AttributeUtil.getAttributeValue((IExtensibleElement)data, (String)"carnot:engine:dataType"))) && structuredDataId.equals(element.getId()) : GenericUtils.isDMSDataType(data) && !StringUtils.isEmpty((String)(structuredDataId = AttributeUtil.getAttributeValue((IExtensibleElement)data, (String)DmsConstants.RESOURCE_METADATA_SCHEMA_ATT))) && structuredDataId.equals(element.getId()))) continue;
            return true;
        }
        return false;
    }

    private boolean isParticipantUsedInOrganizations(IModelParticipant element) {
        EList organizations = this.model.getOrganization();
        for (OrganizationType organization : organizations) {
            EList participants = organization.getParticipant();
            int cnt = 0;
            while (cnt < participants.size()) {
                IModelParticipant participant = ((ParticipantType)participants.get(cnt)).getParticipant();
                if (participant.equals(element)) {
                    return true;
                }
                ++cnt;
            }
            RoleType role = organization.getTeamLead();
            if (role == null || !role.equals(element)) continue;
            return true;
        }
        return false;
    }

    private boolean isDataUsedInConditionalPerformer(DataType element) {
        EList conditionalPerformers = this.model.getConditionalPerformer();
        for (ConditionalPerformerType conditionalPerformer : conditionalPerformers) {
            DataType realmData;
            DataType dataType = conditionalPerformer.getData();
            if (dataType != null && dataType.equals(element)) {
                return true;
            }
            String dataId = AttributeUtil.getAttributeValue((IExtensibleElement)conditionalPerformer, (String)"carnot:engine:conditionalPerformer:realmData");
            if (StringUtils.isEmpty((String)dataId) || (realmData = (DataType)ModelUtils.findElementById((List)this.model.getData(), (String)dataId)) == null || !realmData.equals(element)) continue;
            return true;
        }
        return false;
    }

    private boolean isElementUsedInProcesses(EObject element) {
        for (ProcessDefinitionType process : this.processes) {
            if (this.isElementUsedInEventHandlers((List)process.getEventHandler(), element)) {
                return true;
            }
            if (this.isElementUsedInActivities(process, element)) {
                return true;
            }
            if (this.isElementUsedInTriggers(process, element)) {
                return true;
            }
            if (this.isParticipantUsedInProcessDiagrams(process, element)) {
                return true;
            }
            EList dataPathList = process.getDataPath();
            for (DataPathType dataPath : dataPathList) {
                DataType data = dataPath.getData();
                if (data == null || !data.equals(element)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isElementUsedInActivities(ProcessDefinitionType process, EObject element) {
        EList activities = process.getActivity();
        for (ActivityType activity : activities) {
            if (this.isElementUsedInDataMappings(activity, element)) {
                return true;
            }
            if (this.isElementUsedInEventHandlers((List)activity.getEventHandler(), element)) {
                return true;
            }
            ApplicationType activityApplication = activity.getApplication();
            if (activityApplication != null && activityApplication.equals(element)) {
                return true;
            }
            ProcessDefinitionType activityProcess = activity.getImplementationProcess();
            if (activityProcess != null && activityProcess.equals(element)) {
                return true;
            }
            IModelParticipant activityParticipant = activity.getPerformer();
            if (activityParticipant == null || !activityParticipant.equals(element)) continue;
            return true;
        }
        return false;
    }

    private boolean isElementUsedInDataMappings(ActivityType activity, EObject element) {
        EList dataMappings = activity.getDataMapping();
        for (DataMappingType dataMapping : dataMappings) {
            DataType data = dataMapping.getData();
            if (data == null || !data.equals(element)) continue;
            return true;
        }
        return false;
    }

    private boolean isElementUsedInEventHandlers(List eventHandlers, EObject element) {
        for (EventHandlerType eventHandler : eventHandlers) {
            EList eventActions = eventHandler.getEventAction();
            for (EventActionType actionType : eventActions) {
                if (!(actionType instanceof IExtensibleElement)) continue;
                EList attributes = actionType.getAttribute();
                for (AttributeType attribute : attributes) {
                    IIdentifiableModelElement referencedElement;
                    if (attribute == null || attribute.getReference() == null || (referencedElement = (IIdentifiableModelElement)attribute.getReference().getIdentifiable()) == null || !referencedElement.equals(element)) continue;
                    return true;
                }
            }
            EList bindActions = eventHandler.getBindAction();
            for (BindActionType actionType : bindActions) {
                if (!(actionType instanceof IExtensibleElement)) continue;
                EList attributes = actionType.getAttribute();
                for (AttributeType attribute : attributes) {
                    IIdentifiableModelElement referencedElement;
                    if (attribute == null || attribute.getReference() == null || (referencedElement = (IIdentifiableModelElement)attribute.getReference().getIdentifiable()) == null || !referencedElement.equals(element)) continue;
                    return true;
                }
            }
            EList unbindActions = eventHandler.getUnbindAction();
            for (UnbindActionType actionType : unbindActions) {
                if (!(actionType instanceof IExtensibleElement)) continue;
                EList attributes = actionType.getAttribute();
                for (AttributeType attribute : attributes) {
                    IIdentifiableModelElement referencedElement;
                    if (attribute == null || attribute.getReference() == null || (referencedElement = (IIdentifiableModelElement)attribute.getReference().getIdentifiable()) == null || !referencedElement.equals(element)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private boolean isElementUsedInTriggers(ProcessDefinitionType process, EObject element) {
        EList triggers = process.getTrigger();
        for (TriggerType trigger : triggers) {
            EList attributes = trigger.getAttribute();
            int a = 0;
            while (a < attributes.size()) {
                EObject referencedElement;
                AttributeType attribute = (AttributeType)attributes.get(a);
                IdentifiableReference reference = attribute.getReference();
                if (reference != null && (referencedElement = reference.getIdentifiable()) != null && referencedElement.equals(element)) {
                    return true;
                }
                ++a;
            }
            EList mappings = trigger.getParameterMapping();
            int m = 0;
            while (m < mappings.size()) {
                ParameterMappingType mappingType = (ParameterMappingType)mappings.get(m);
                DataType data = mappingType.getData();
                if (data != null && data.equals(element)) {
                    return true;
                }
                ++m;
            }
        }
        return false;
    }

    private boolean isParticipantUsedInProcessDiagrams(ProcessDefinitionType process, EObject element) {
        if (element instanceof IModelParticipant) {
            EList diagrams = process.getDiagram();
            for (DiagramType diagram : diagrams) {
                EList pools = diagram.getPoolSymbols();
                for (PoolSymbol pool : pools) {
                    for (LaneSymbol lane : pool.getLanes()) {
                        IModelParticipant participant = lane.getParticipantReference();
                        if (participant == null || !participant.equals(element)) continue;
                        return true;
                    }
                }
            }
        }
        return false;
    }
}

