/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.search;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.ui.actions.SelectionAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.search.ui.ISearchResult;
import org.eclipse.search.ui.ISearchResultListener;
import org.eclipse.search.ui.ISearchResultPage;
import org.eclipse.search.ui.ISearchResultViewPart;
import org.eclipse.search.ui.SearchResultEvent;
import org.eclipse.stardust.model.xpdl.carnot.INodeSymbol;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.model.xpdl.xpdl2.TypeDeclarationsType;
import org.eclipse.stardust.modeling.common.ui.jface.utils.FormBuilder;
import org.eclipse.stardust.modeling.core.Diagram_Messages;
import org.eclipse.stardust.modeling.core.editors.WorkflowModelEditor;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.AbstractModelElementNodeSymbolEditPart;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.DiagramEditPart;
import org.eclipse.stardust.modeling.core.editors.parts.tree.AbstractEObjectTreeEditPart;
import org.eclipse.stardust.modeling.core.editors.parts.tree.IdentifiableModelElementTreeEditPart;
import org.eclipse.stardust.modeling.core.search.ReferenceSearchQuery;
import org.eclipse.stardust.modeling.core.search.ReferencesSearchResult;
import org.eclipse.stardust.modeling.core.search.tree.EditorSelectionChangedListener;
import org.eclipse.stardust.modeling.core.search.tree.ResultViewTreeEditPartFactory;
import org.eclipse.stardust.modeling.core.search.tree.ResultViewTreeViewer;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.IPageSite;
import org.eclipse.ui.part.Page;

public class ReferencesResultPage
extends Page
implements ISearchResultPage,
ISearchResultListener,
ISelectionProvider {
    private String id;
    private String label = "";
    private Object uiState;
    private Composite composite;
    private Tree tree;
    private ResultViewTreeViewer viewer;
    private Collection selectionChangedListeners = new ArrayList();
    private EditorSelectionChangedListener selectionChangedListener;
    private ISelection pageSelection;
    private ReferencesSearchResult searchResult;
    private ISearchResultViewPart part;
    private WorkflowModelEditor editor;
    private ModelType model;
    private MenuManager menuManager;

    public Object getUIState() {
        return this.uiState;
    }

    public void setInput(ISearchResult search, Object uiState) {
        this.uiState = uiState;
        this.searchResult = (ReferencesSearchResult)search;
        if (this.searchResult != null) {
            this.searchResult.addListener(this);
        }
    }

    public void setViewPart(ISearchResultViewPart part) {
        this.part = part;
    }

    public void restoreState(IMemento memento) {
    }

    public void saveState(IMemento memento) {
    }

    public void setID(String id) {
        this.id = id;
    }

    public String getID() {
        return this.id;
    }

    public String getLabel() {
        return this.label;
    }

    public IPageSite getSite() {
        return super.getSite();
    }

    public void init(IPageSite site) {
        super.init(site);
    }

    public void createControl(Composite parent) {
        WorkflowModelEditor editor = (WorkflowModelEditor)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        this.composite = FormBuilder.createComposite((Composite)parent, (int)1);
        this.composite.setLayout((Layout)new FillLayout());
        this.tree = FormBuilder.createTree((Composite)this.composite, (int)2);
        this.viewer = new ResultViewTreeViewer();
        this.viewer.setControl((Control)this.tree);
        this.menuManager = new MenuManager();
        this.tree.setMenu(this.menuManager.createContextMenu((Control)this.tree));
        this.selectionChangedListener = new EditorSelectionChangedListener(this);
        this.model = (ModelType)editor.getModel();
        this.initViewer(editor);
        this.viewer.addSelectionChangedListener(this.selectionChangedListener);
        this.getSite().setSelectionProvider((ISelectionProvider)this.viewer);
        this.viewer.getControl().setVisible(false);
        this.tree.setLayout((Layout)new FillLayout());
        this.tree.setLayoutData(null);
    }

    private void initViewer(WorkflowModelEditor editor) {
        ResultViewTreeEditPartFactory factory = new ResultViewTreeEditPartFactory(editor);
        this.viewer.setEditDomain(editor.getEditDomain());
        this.viewer.setEditPartFactory(factory);
        this.selectionChangedListener.setEditor(editor);
    }

    public void dispose() {
        super.dispose();
    }

    public Control getControl() {
        return this.composite;
    }

    public void setFocus() {
    }

    public void searchResultChanged(SearchResultEvent e) {
        final Map matchedElements = this.searchResult.getMatchedElements();
        this.viewer.getControl().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                ReferencesResultPage.this.getControl().setFocus();
                ReferencesResultPage.this.editor = (WorkflowModelEditor)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
                ReferencesResultPage.this.initViewer(ReferencesResultPage.this.editor);
                ReferencesResultPage.this.model = (ModelType)ReferencesResultPage.this.editor.getModel();
                ReferencesResultPage.this.viewer.setMatchedElements(matchedElements);
                ReferencesResultPage.this.viewer.setContents(ReferencesResultPage.this.model, null, false);
                Integer numberMatchedElements = new Integer(ReferencesResultPage.this.viewer.getResultViewFilter().getNumberMatchedElements());
                ReferencesResultPage.this.label = MessageFormat.format(Diagram_Messages.LB_Result, ((ReferenceSearchQuery)ReferencesResultPage.this.searchResult.getQuery()).getLabel(), numberMatchedElements, numberMatchedElements == 1 ? Diagram_Messages.LB_Reference : Diagram_Messages.LB_References);
                ReferencesResultPage.this.part.updateLabel();
            }
        });
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionChangedListeners.add(listener);
    }

    public ISelection getSelection() {
        return this.pageSelection;
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionChangedListeners.remove(listener);
    }

    public void setSelection(ISelection selection) {
        SelectionAction action;
        EObject model;
        this.menuManager.removeAll();
        if (selection == null) {
            return;
        }
        this.pageSelection = selection;
        for (ISelectionChangedListener listener : this.selectionChangedListeners) {
            listener.selectionChanged(new SelectionChangedEvent((ISelectionProvider)this, selection));
        }
        Object object = ((StructuredSelection)selection).getFirstElement();
        if (object instanceof AbstractEObjectTreeEditPart || object instanceof IdentifiableModelElementTreeEditPart) {
            model = (EObject)((AbstractEObjectTreeEditPart)object).getModel();
            if (!(model instanceof TypeDeclarationsType)) {
                this.editor.selectElement(model);
            }
        } else if (object instanceof DiagramEditPart) {
            model = (EObject)((DiagramEditPart)object).getModel();
            this.editor.selectElement(model);
        } else if (object instanceof AbstractModelElementNodeSymbolEditPart) {
            model = (EObject)((AbstractModelElementNodeSymbolEditPart)object).getModel();
            this.editor.selectSymbol((INodeSymbol)model);
        }
        if ((action = (SelectionAction)this.editor.getActionRegistry().getAction((Object)"org.eclipse.stardust.modeling.core.showInDiagramAction")).isEnabled()) {
            this.menuManager.add((IAction)action);
        }
    }
}

