/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.search.tree;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.stardust.model.xpdl.carnot.ActivityType;
import org.eclipse.stardust.model.xpdl.carnot.ApplicationType;
import org.eclipse.stardust.model.xpdl.carnot.ConditionalPerformerType;
import org.eclipse.stardust.model.xpdl.carnot.DataPathType;
import org.eclipse.stardust.model.xpdl.carnot.DataType;
import org.eclipse.stardust.model.xpdl.carnot.DiagramType;
import org.eclipse.stardust.model.xpdl.carnot.IGraphicalObject;
import org.eclipse.stardust.model.xpdl.carnot.IModelElement;
import org.eclipse.stardust.model.xpdl.carnot.ISymbolContainer;
import org.eclipse.stardust.model.xpdl.carnot.LinkTypeType;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.model.xpdl.carnot.OrganizationType;
import org.eclipse.stardust.model.xpdl.carnot.PoolSymbol;
import org.eclipse.stardust.model.xpdl.carnot.ProcessDefinitionType;
import org.eclipse.stardust.model.xpdl.carnot.RoleType;
import org.eclipse.stardust.model.xpdl.carnot.TransitionType;
import org.eclipse.stardust.model.xpdl.carnot.TriggerType;
import org.eclipse.stardust.model.xpdl.carnot.util.DiagramUtil;
import org.eclipse.stardust.model.xpdl.carnot.util.ModelUtils;
import org.eclipse.stardust.model.xpdl.xpdl2.TypeDeclarationType;

public class ResultViewFilter {
    private ModelType model;
    private int numberMatchedElements;
    private Map matchedElements;
    private List typeDeclarations;
    private List applications;
    private List datas;
    private List participants;
    private List linkTypes;
    private List modelDiagrams;
    private List processes;
    private List diagramProxies;
    private Map diagramChildren;
    private Map currentDiagramChildren;
    private List processProxies;
    private Map processChildren;
    private Map currentProcessChildren;
    private List modelChildren;

    public ResultViewFilter(ModelType model) {
        this.model = model;
        this.init(true);
    }

    public void setMatchedElements(Map matchedElements) {
        this.init(true);
        this.matchedElements = matchedElements;
        if (matchedElements == null || matchedElements.isEmpty()) {
            return;
        }
        this.setContent();
        this.setChildren(false);
    }

    private void init(boolean clear) {
        this.numberMatchedElements = 0;
        this.typeDeclarations = new ArrayList();
        this.applications = new ArrayList();
        this.datas = new ArrayList();
        this.participants = new ArrayList();
        this.linkTypes = new ArrayList();
        this.modelDiagrams = new ArrayList();
        this.processes = new ArrayList();
        this.currentProcessChildren = new HashMap();
        this.currentDiagramChildren = new HashMap();
        if (clear) {
            this.modelChildren = new ArrayList();
            this.diagramProxies = new ArrayList();
            this.diagramChildren = new HashMap();
            this.processProxies = new ArrayList();
            this.processChildren = new HashMap();
        }
    }

    private void setContent() {
        for (Map.Entry entry : this.matchedElements.entrySet()) {
            EObject container = (EObject)entry.getKey();
            List children = (List)entry.getValue();
            if (container instanceof ModelType) {
                this.modelChildren.addAll(children);
                continue;
            }
            if (container instanceof DiagramType) {
                this.diagramProxies.add(container);
                this.diagramChildren.put(container, children);
                continue;
            }
            if (!(container instanceof ProcessDefinitionType)) continue;
            this.processProxies.add(container);
            this.processChildren.put(container, children);
        }
        for (DiagramType diagram : this.diagramProxies) {
            ArrayList<DiagramType> containerChildren;
            ProcessDefinitionType diagramProcess = ModelUtils.findContainingProcess((EObject)diagram);
            if (diagramProcess == null) {
                this.modelChildren.add(diagram);
                continue;
            }
            if (this.processProxies.contains(diagramProcess)) {
                containerChildren = (ArrayList<DiagramType>)this.processChildren.get(diagramProcess);
                containerChildren.add(diagram);
                this.processChildren.put(diagramProcess, containerChildren);
                continue;
            }
            this.processProxies.add(diagramProcess);
            containerChildren = new ArrayList<DiagramType>();
            containerChildren.add(diagram);
            this.processChildren.put(diagramProcess, containerChildren);
        }
    }

    private void setChildren(boolean clear) {
        if (clear) {
            this.init(false);
        }
        this.setModelChildren();
        this.setProcessChildren();
        this.setDiagramChildren();
    }

    private void setModelChildren() {
        for (EObject element : this.modelChildren) {
            if (element instanceof TypeDeclarationType && this.model.getTypeDeclarations().getTypeDeclaration().contains((Object)element)) {
                this.typeDeclarations.add(element);
                ++this.numberMatchedElements;
                continue;
            }
            if (element instanceof ApplicationType && this.model.getApplication().contains((Object)element)) {
                this.applications.add(element);
                ++this.numberMatchedElements;
                continue;
            }
            if (element instanceof DataType && this.model.getData().contains((Object)element)) {
                this.datas.add(element);
                ++this.numberMatchedElements;
                continue;
            }
            if (element instanceof RoleType && this.model.getRole().contains((Object)element)) {
                this.participants.add(element);
                ++this.numberMatchedElements;
                continue;
            }
            if (element instanceof OrganizationType && this.model.getOrganization().contains((Object)element)) {
                this.participants.add(element);
                ++this.numberMatchedElements;
                continue;
            }
            if (element instanceof ConditionalPerformerType && this.model.getConditionalPerformer().contains((Object)element)) {
                this.participants.add(element);
                ++this.numberMatchedElements;
                continue;
            }
            if (element instanceof LinkTypeType && this.model.getLinkType().contains((Object)element)) {
                this.linkTypes.add(element);
                ++this.numberMatchedElements;
                continue;
            }
            if (element instanceof DiagramType && this.model.getDiagram().contains((Object)element)) {
                this.modelDiagrams.add(element);
                ++this.numberMatchedElements;
                continue;
            }
            if (!(element instanceof ProcessDefinitionType) || !this.model.getProcessDefinition().contains((Object)element)) continue;
            this.processes.add(element);
            ++this.numberMatchedElements;
        }
    }

    private void setDiagramChildren() {
        for (DiagramType diagram : this.diagramProxies) {
            ProcessDefinitionType process = ModelUtils.findContainingProcess((EObject)diagram);
            boolean foundElement = false;
            if (process != null) {
                if (this.model.getProcessDefinition().contains((Object)process) && process.getDiagram().contains((Object)diagram)) {
                    foundElement = true;
                }
            } else if (this.model.getDiagram().contains((Object)diagram)) {
                foundElement = true;
            }
            if (!foundElement) continue;
            List containerChildren = (List)this.diagramChildren.get(diagram);
            ArrayList<EObject> diagramChildren = new ArrayList<EObject>();
            for (EObject element : containerChildren) {
                PoolSymbol pool;
                Object symbolContainer;
                List nodes;
                if (!(element instanceof IGraphicalObject) || !(nodes = this.getSymbols((ISymbolContainer)(symbolContainer = (pool = DiagramUtil.getDefaultPool((DiagramType)diagram)) != null ? pool : diagram), (IModelElement)element)).contains(element)) continue;
                diagramChildren.add(element);
                ++this.numberMatchedElements;
            }
            if (diagramChildren.isEmpty()) continue;
            this.currentDiagramChildren.put(diagram, diagramChildren);
        }
    }

    private void setProcessChildren() {
        for (ProcessDefinitionType process : this.processProxies) {
            if (!this.model.getProcessDefinition().contains((Object)process)) continue;
            List containerChildren = (List)this.processChildren.get(process);
            ArrayList<EObject> processChildren = new ArrayList<EObject>();
            for (EObject element : containerChildren) {
                if (element instanceof DiagramType && process.getDiagram().contains((Object)element)) {
                    processChildren.add(element);
                    ++this.numberMatchedElements;
                    continue;
                }
                if (element instanceof ActivityType && process.getActivity().contains((Object)element)) {
                    processChildren.add(element);
                    ++this.numberMatchedElements;
                    continue;
                }
                if (element instanceof TriggerType && process.getTrigger().contains((Object)element)) {
                    processChildren.add(element);
                    ++this.numberMatchedElements;
                    continue;
                }
                if (element instanceof TransitionType && process.getTransition().contains((Object)element)) {
                    processChildren.add(element);
                    ++this.numberMatchedElements;
                    continue;
                }
                if (!(element instanceof DataPathType) || !process.getDataPath().contains((Object)element)) continue;
                processChildren.add(element);
                ++this.numberMatchedElements;
            }
            if (processChildren.isEmpty()) continue;
            this.currentProcessChildren.put(process, processChildren);
        }
    }

    public boolean isDiagramProxy(DiagramType diagram) {
        this.setChildren(true);
        return this.diagramProxies.contains(diagram);
    }

    public boolean isProcessProxy(ProcessDefinitionType process) {
        this.setChildren(true);
        return this.processProxies.contains(process);
    }

    public List getTypeDeclarations() {
        this.setChildren(true);
        return this.typeDeclarations;
    }

    public List getApplications() {
        this.setChildren(true);
        return this.applications;
    }

    public List getDatas() {
        this.setChildren(true);
        return this.datas;
    }

    public List getParticipants() {
        this.setChildren(true);
        return this.participants;
    }

    public List getLinkTypes() {
        this.setChildren(true);
        return this.linkTypes;
    }

    public List getModelDiagrams() {
        this.setChildren(true);
        return this.modelDiagrams;
    }

    public List getModelChildren() {
        this.setChildren(true);
        ArrayList<Object> modelChildren = new ArrayList<Object>();
        if (!this.processProxies.isEmpty()) {
            for (ProcessDefinitionType process : this.processProxies) {
                if (!this.model.getProcessDefinition().contains((Object)process)) continue;
                modelChildren.add(process);
            }
        }
        if (!this.processes.isEmpty()) {
            modelChildren.addAll(this.processes);
        }
        if (!this.linkTypes.isEmpty()) {
            modelChildren.addAll(this.linkTypes);
        }
        if (!this.diagramProxies.isEmpty()) {
            for (DiagramType diagram : this.diagramProxies) {
                if (!this.model.getDiagram().contains((Object)diagram)) continue;
                modelChildren.add(diagram);
            }
        }
        if (!this.modelDiagrams.isEmpty()) {
            modelChildren.addAll(this.modelDiagrams);
        }
        return modelChildren;
    }

    public List getDiagramChildren(DiagramType diagram) {
        this.setChildren(true);
        ArrayList children = (ArrayList)this.currentDiagramChildren.get(diagram);
        if (children == null) {
            children = new ArrayList();
        }
        return children;
    }

    public List getProcessChildren(ProcessDefinitionType process) {
        this.setChildren(true);
        ArrayList children = (ArrayList)this.currentProcessChildren.get(process);
        if (children == null) {
            children = new ArrayList();
        }
        return children;
    }

    private List getSymbols(ISymbolContainer container, IModelElement modelSymbol) {
        for (EStructuralFeature feature : container.getNodeContainingFeatures()) {
            if (!feature.getEType().equals(modelSymbol.eClass())) continue;
            List list = (List)container.eGet(feature);
            return list;
        }
        return new ArrayList();
    }

    public int getNumberMatchedElements() {
        return this.numberMatchedElements;
    }
}

