/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.spi.applicationTypes.jms;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.viewers.IFilter;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.stardust.engine.extensions.jms.app.JMSDirection;
import org.eclipse.stardust.model.xpdl.carnot.AccessPointType;
import org.eclipse.stardust.model.xpdl.carnot.ApplicationType;
import org.eclipse.stardust.model.xpdl.carnot.AttributeType;
import org.eclipse.stardust.model.xpdl.carnot.CarnotWorkflowModelPackage;
import org.eclipse.stardust.model.xpdl.carnot.IAccessPointOwner;
import org.eclipse.stardust.model.xpdl.carnot.IExtensibleElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelElement;
import org.eclipse.stardust.model.xpdl.carnot.util.AccessPointUtil;
import org.eclipse.stardust.model.xpdl.carnot.util.AttributeUtil;
import org.eclipse.stardust.modeling.core.properties.ModelElementNotificationAdapter;

public class JmsAccessPointsTreeContentProvider
extends ModelElementNotificationAdapter
implements ITreeContentProvider {
    private static final String REQUEST = "Request";
    private static final String RESPONSE = "Response";
    private static final int[] elementFeatureIds = new int[]{1};
    private TreeViewer viewer;
    private ModelElementNotificationAdapter attributeNotifier;

    public JmsAccessPointsTreeContentProvider() {
        super((EStructuralFeature)CarnotWorkflowModelPackage.eINSTANCE.getIAccessPointOwner_AccessPoint(), elementFeatureIds, true);
    }

    @Override
    public void elementAdded(EObject element) {
        this.viewer.refresh();
    }

    @Override
    public void elementChanged(EObject element) {
        this.viewer.refresh();
    }

    @Override
    public void elementMoved(EObject element) {
        this.viewer.refresh();
    }

    @Override
    public void elementRemoved(EObject element) {
        this.viewer.refresh();
    }

    @Override
    public void init(EObject target) {
        super.init(target);
        if (target instanceof ApplicationType) {
            this.attributeNotifier = new ModelElementNotificationAdapter((EStructuralFeature)CarnotWorkflowModelPackage.eINSTANCE.getIExtensibleElement_Attribute(), new int[]{6}, new IFilter(){

                public boolean select(Object toTest) {
                    if (toTest instanceof AttributeType) {
                        AttributeType attribute = (AttributeType)toTest;
                        return "carnot:engine:type".equals(attribute.getName());
                    }
                    return false;
                }
            }, true){

                @Override
                public void elementRemoved(EObject element) {
                    JmsAccessPointsTreeContentProvider.this.viewer.refresh();
                }

                @Override
                public void elementMoved(EObject element) {
                }

                @Override
                public void elementChanged(EObject element) {
                    JmsAccessPointsTreeContentProvider.this.viewer.refresh();
                }

                @Override
                public void elementAdded(EObject element) {
                    JmsAccessPointsTreeContentProvider.this.viewer.refresh();
                }
            };
            this.attributeNotifier.init(target);
        }
    }

    @Override
    public void dispose() {
        if (this.attributeNotifier != null) {
            this.attributeNotifier.dispose();
        }
        super.dispose();
    }

    public Object[] getChildren(Object parentElement) {
        if (REQUEST.equals(parentElement)) {
            return AccessPointUtil.getInAccessPonts((IAccessPointOwner)((IAccessPointOwner)this.viewer.getInput())).toArray();
        }
        if (RESPONSE.equals(parentElement)) {
            return AccessPointUtil.getOutAccessPonts((IAccessPointOwner)((IAccessPointOwner)this.viewer.getInput())).toArray();
        }
        return new Object[0];
    }

    public Object getParent(Object element) {
        return element instanceof AccessPointType ? (AccessPointUtil.isDirectionCompatible((AccessPointType)((AccessPointType)element), (boolean)true) ? REQUEST : RESPONSE) : null;
    }

    public boolean hasChildren(Object element) {
        return REQUEST.equals(element) || RESPONSE.equals(element);
    }

    public Object[] getElements(Object inputElement) {
        if (inputElement instanceof ApplicationType) {
            String type = AttributeUtil.getAttributeValue((IExtensibleElement)((IExtensibleElement)inputElement), (String)"carnot:engine:type");
            if (JMSDirection.IN.getId().equals(type)) {
                return new Object[]{RESPONSE};
            }
            if (JMSDirection.OUT.getId().equals(type)) {
                return new Object[]{REQUEST};
            }
            if (JMSDirection.INOUT.getId().equals(type)) {
                return new Object[]{REQUEST, RESPONSE};
            }
        }
        return new Object[0];
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.dispose();
        this.init((EObject)((IModelElement)newInput));
        this.viewer = (TreeViewer)viewer;
    }
}

