/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.spi.applicationTypes.jms;

import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gef.EditPart;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IFilter;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.stardust.engine.extensions.jms.app.JMSDirection;
import org.eclipse.stardust.model.xpdl.carnot.AccessPointType;
import org.eclipse.stardust.model.xpdl.carnot.ApplicationType;
import org.eclipse.stardust.model.xpdl.carnot.CarnotWorkflowModelPackage;
import org.eclipse.stardust.model.xpdl.carnot.DataTypeType;
import org.eclipse.stardust.model.xpdl.carnot.DirectionType;
import org.eclipse.stardust.model.xpdl.carnot.IExtensibleElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelElementNodeSymbol;
import org.eclipse.stardust.model.xpdl.carnot.util.AccessPointUtil;
import org.eclipse.stardust.model.xpdl.carnot.util.AttributeUtil;
import org.eclipse.stardust.model.xpdl.carnot.util.ModelUtils;
import org.eclipse.stardust.modeling.common.ui.IdFactory;
import org.eclipse.stardust.modeling.common.ui.jface.utils.FormBuilder;
import org.eclipse.stardust.modeling.core.DiagramPlugin;
import org.eclipse.stardust.modeling.core.Diagram_Messages;
import org.eclipse.stardust.modeling.core.editors.ui.CarnotPreferenceNode;
import org.eclipse.stardust.modeling.core.editors.ui.EObjectLabelProvider;
import org.eclipse.stardust.modeling.core.editors.ui.TableLabelProvider;
import org.eclipse.stardust.modeling.core.editors.ui.TableUtil;
import org.eclipse.stardust.modeling.core.properties.AbstractModelElementPropertyPage;
import org.eclipse.stardust.modeling.core.properties.DefaultOutlineProvider;
import org.eclipse.stardust.modeling.core.properties.IButtonManager;
import org.eclipse.stardust.modeling.core.properties.ModelElementAdaptable;
import org.eclipse.stardust.modeling.core.properties.ModelElementsOutlineSynchronizer;
import org.eclipse.stardust.modeling.core.spi.ConfigurationElement;
import org.eclipse.stardust.modeling.core.spi.applicationTypes.jms.JmsAccessPointsTreeContentProvider;
import org.eclipse.stardust.modeling.core.spi.applicationTypes.jms.RequestAccessPointPropertyPage;
import org.eclipse.stardust.modeling.core.spi.applicationTypes.jms.RequestPropertyPage;
import org.eclipse.stardust.modeling.core.spi.applicationTypes.jms.ResponseAccessPointPropertyPage;
import org.eclipse.stardust.modeling.core.spi.applicationTypes.jms.ResponsePropertyPage;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Tree;

public class JmsPropertyPage
extends AbstractModelElementPropertyPage
implements IButtonManager {
    private static final String INOUT = JMSDirection.INOUT.getId();
    private static final String OUT = JMSDirection.OUT.getId();
    private static final String IN = JMSDirection.IN.getId();
    static final String EMPTY_STRING = "";
    static final String RESPONSE = "Response";
    static final String REQUEST = "Request";
    private static final String BOOLEAN_TYPE = "boolean";
    private static final String REQUEST_NODE = "_cwm_request_";
    private static final String RESPONSE_NODE = "_cwm_response_";
    private static final String SPI_NODE = "_cwm_spi_application_";
    private static final String[] labelProperties = new String[]{"name"};
    private Button[] buttons;
    private Object selection;
    private TreeViewer viewer;
    private ModelElementsOutlineSynchronizer requestOutlineSynchronizer;
    private ModelElementsOutlineSynchronizer responseOutlineSynchronizer;
    private Button requestButton;
    private Button responseButton;
    private EObjectLabelProvider labelProvider;

    @Override
    public void dispose() {
        this.requestOutlineSynchronizer.dispose();
        this.responseOutlineSynchronizer.dispose();
        super.dispose();
    }

    private Object getSelectedItem() {
        IStructuredSelection sel = (IStructuredSelection)this.viewer.getSelection();
        Object selection = sel.getFirstElement();
        return selection;
    }

    @Override
    public void loadFieldsFromElement(IModelElementNodeSymbol symbol, IModelElement element) {
        ApplicationType application = this.getApplication();
        String type = AttributeUtil.getAttributeValue((IExtensibleElement)application, (String)"carnot:engine:type");
        DirectionType direction = this.getDirection(type);
        this.requestButton.setSelection(direction != null && AccessPointUtil.isOut((DirectionType)direction));
        this.responseButton.setSelection(direction != null && AccessPointUtil.isIn((DirectionType)direction));
        this.updateCreateRequestResponseNodes(application);
        this.viewer.setInput((Object)application);
        this.requestOutlineSynchronizer.init((EObject)application);
        this.responseOutlineSynchronizer.init((EObject)application);
    }

    private void updateCreateRequestResponseNodes(ApplicationType application) {
        if (this.requestButton.getSelection()) {
            this.addJmsType(REQUEST_NODE, REQUEST, RequestPropertyPage.class.getName(), application);
        } else {
            this.removePreferenceNodes(this.composePageId(SPI_NODE, REQUEST_NODE), true);
        }
        if (this.responseButton.getSelection()) {
            this.addJmsType(RESPONSE_NODE, RESPONSE, ResponsePropertyPage.class.getName(), application);
        } else {
            this.removePreferenceNodes(this.composePageId(SPI_NODE, RESPONSE_NODE), true);
        }
    }

    private void addJmsType(String id, String name, String className, ApplicationType application) {
        if (this.getNode(this.composePageId(SPI_NODE, id)) == null) {
            ConfigurationElement config = ConfigurationElement.createPageConfiguration(id, name, null, className);
            CarnotPreferenceNode node = new CarnotPreferenceNode(config, new ModelElementAdaptable(new Class[]{IButtonManager.class, IModelElement.class, IModelElementNodeSymbol.class}, new Object[]{this, application}, this.getElement()), 1001);
            this.addNodeTo(SPI_NODE, node, null);
        }
    }

    private DirectionType getDirection(String type) {
        if (JMSDirection.IN.getId().equals(type)) {
            return DirectionType.IN_LITERAL;
        }
        if (JMSDirection.OUT.getId().equals(type)) {
            return DirectionType.OUT_LITERAL;
        }
        if (JMSDirection.INOUT.getId().equals(type)) {
            return DirectionType.INOUT_LITERAL;
        }
        return null;
    }

    @Override
    public void loadElementFromFields(IModelElementNodeSymbol symbol, IModelElement element) {
    }

    @Override
    public Control createBody(Composite parent) {
        Composite composite = FormBuilder.createComposite((Composite)parent, (int)3);
        FormBuilder.createLabel((Composite)composite, (String)Diagram_Messages.LB_SPI_Type);
        SelectionAdapter listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JmsPropertyPage.this.setJmsType();
            }
        };
        this.requestButton = FormBuilder.createCheckBox((Composite)composite, (String)REQUEST);
        this.requestButton.addSelectionListener((SelectionListener)listener);
        this.responseButton = FormBuilder.createCheckBox((Composite)composite, (String)RESPONSE);
        this.responseButton.addSelectionListener((SelectionListener)listener);
        Tree tree = new Tree(composite, 67584);
        tree.setHeaderVisible(true);
        tree.setLayoutData((Object)FormBuilder.createDefaultMultiLineWidgetGridData((int)3));
        FormBuilder.applyDefaultTextControlWidth((Control)tree);
        tree.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JmsPropertyPage.this.updateButtons(JmsPropertyPage.this.getSelectedItem(), JmsPropertyPage.this.buttons);
            }
        });
        tree.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                Object selection = JmsPropertyPage.this.getSelectedItem();
                if (selection instanceof AccessPointType) {
                    JmsPropertyPage.this.selectPageForObject(selection);
                }
            }
        });
        this.viewer = new TreeViewer(tree);
        TableUtil.createColumns(tree, new String[]{Diagram_Messages.COL_NAME_Name});
        TableUtil.setInitialColumnSizes(tree, new int[]{99});
        this.labelProvider = new EObjectLabelProvider(this.getEditor()){

            @Override
            public Image getImage(Object element) {
                Image image = element instanceof EObject ? super.getImage(element) : null;
                return image == null ? DiagramPlugin.getImage("icons/full/obj16/data.gif") : image;
            }

            @Override
            public String getText(String name, Object element) {
                if (!(element instanceof EObject)) {
                    return this.getText(element);
                }
                return super.getText(name, element);
            }
        };
        TableUtil.setLabelProvider(this.viewer, (TableLabelProvider)this.labelProvider, labelProperties);
        this.viewer.setContentProvider((IContentProvider)new JmsAccessPointsTreeContentProvider());
        this.requestOutlineSynchronizer = new ModelElementsOutlineSynchronizer(new DefaultOutlineProvider(this, (EStructuralFeature)CarnotWorkflowModelPackage.eINSTANCE.getIAccessPointOwner_AccessPoint(), (EStructuralFeature)CarnotWorkflowModelPackage.eINSTANCE.getIIdentifiableElement_Id(), (EStructuralFeature)CarnotWorkflowModelPackage.eINSTANCE.getIIdentifiableElement_Name(), this.composePageId(SPI_NODE, REQUEST_NODE), RequestAccessPointPropertyPage.class.getName(), new IFilter(){

            public boolean select(Object toTest) {
                if (toTest instanceof AccessPointType) {
                    return AccessPointUtil.isDirectionCompatible((AccessPointType)((AccessPointType)toTest), (boolean)true);
                }
                return false;
            }
        }){

            protected List retrievePagesFor(ModelElementAdaptable adaptable) {
                IModelElement accessPoint = (IModelElement)adaptable.getAdapter(IModelElement.class);
                if (accessPoint instanceof AccessPointType) {
                    CarnotPreferenceNode node = new CarnotPreferenceNode(this.createPageConfiguration(accessPoint), adaptable, "propertyPageClass", 0);
                    return Collections.singletonList(node);
                }
                return super.retrievePagesFor(adaptable);
            }
        });
        this.addModelElementsOutlineSynchronizer(this.requestOutlineSynchronizer);
        this.responseOutlineSynchronizer = new ModelElementsOutlineSynchronizer(new DefaultOutlineProvider(this, (EStructuralFeature)CarnotWorkflowModelPackage.eINSTANCE.getIAccessPointOwner_AccessPoint(), (EStructuralFeature)CarnotWorkflowModelPackage.eINSTANCE.getIIdentifiableElement_Id(), (EStructuralFeature)CarnotWorkflowModelPackage.eINSTANCE.getIIdentifiableElement_Name(), this.composePageId(SPI_NODE, RESPONSE_NODE), ResponseAccessPointPropertyPage.class.getName(), new IFilter(){

            public boolean select(Object toTest) {
                if (toTest instanceof AccessPointType) {
                    return AccessPointUtil.isDirectionCompatible((AccessPointType)((AccessPointType)toTest), (boolean)false);
                }
                return false;
            }
        }){

            protected List retrievePagesFor(ModelElementAdaptable adaptable) {
                IModelElement accessPoint = (IModelElement)adaptable.getAdapter(IModelElement.class);
                if (accessPoint instanceof AccessPointType) {
                    CarnotPreferenceNode node = new CarnotPreferenceNode(this.createPageConfiguration(accessPoint), adaptable, "propertyPageClass", 0);
                    return Collections.singletonList(node);
                }
                return super.retrievePagesFor(adaptable);
            }
        });
        this.addModelElementsOutlineSynchronizer(this.responseOutlineSynchronizer);
        return composite;
    }

    private void setJmsType() {
        boolean request = this.requestButton.getSelection();
        boolean response = this.responseButton.getSelection();
        ApplicationType application = this.getApplication();
        String type = INOUT;
        if (!request) {
            AccessPointUtil.removeAccessPoints((List)application.getAccessPoint(), (boolean)true);
            String string = type = response ? IN : EMPTY_STRING;
        }
        if (!response) {
            AccessPointUtil.removeAccessPoints((List)application.getAccessPoint(), (boolean)false);
            type = request ? OUT : EMPTY_STRING;
        }
        AttributeUtil.setAttribute((IExtensibleElement)application, (String)"carnot:engine:type", (String)JMSDirection.class.getName(), (String)type);
        this.updateCreateRequestResponseNodes(application);
        this.refreshTree();
    }

    private ApplicationType getApplication() {
        Object element = this.getElement();
        if (element instanceof EditPart) {
            element = ((EditPart)element).getModel();
        }
        if (element instanceof IModelElementNodeSymbol) {
            element = ((IModelElementNodeSymbol)element).getModelElement();
        }
        return element instanceof ApplicationType ? (ApplicationType)element : null;
    }

    @Override
    public void contributeVerticalButtons(Composite parent) {
        this.buttons = this.createButtons(parent);
    }

    @Override
    public void updateButtons(Object selection, Button[] buttons) {
        this.selection = selection;
        int i = 0;
        while (i < buttons.length) {
            if (buttons[i].isDisposed()) {
                return;
            }
            ++i;
        }
        buttons[0].setEnabled(selection != null);
        buttons[1].setEnabled(selection instanceof AccessPointType);
    }

    @Override
    public Button[] createButtons(Composite parent) {
        Button[] buttons;
        buttons = new Button[]{FormBuilder.createButton((Composite)parent, (String)Diagram_Messages.B_Add, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JmsPropertyPage.this.performAdd(buttons);
            }
        }), FormBuilder.createButton((Composite)parent, (String)Diagram_Messages.B_Delete, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JmsPropertyPage.this.performDelete(buttons);
            }
        })};
        return buttons;
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.updateButtons(this.getSelectedItem(), this.buttons);
        }
        super.setVisible(visible);
    }

    @Override
    public Object getSelection() {
        return this.selection == null ? this.getSelectedItem() : this.selection;
    }

    private void performDelete(Button[] buttons) {
        AccessPointType ap = (AccessPointType)this.getSelection();
        if (ap != null) {
            ApplicationType application = this.getApplication();
            application.getAccessPoint().remove((Object)ap);
            this.updateButtons(null, buttons);
            this.selectPage(SPI_NODE);
        }
    }

    private void performAdd(Button[] buttons) {
        DirectionType direction;
        ApplicationType application = this.getApplication();
        String context = null;
        Object object = this.getSelection();
        context = object instanceof AccessPointType ? (AccessPointUtil.isIn((DirectionType)(direction = ((AccessPointType)object).getDirection())) ? REQUEST : RESPONSE) : (String)object;
        boolean isIn = REQUEST.equals(context);
        String baseId = isIn ? IN : OUT;
        String baseName = isIn ? Diagram_Messages.BASENAME_InAccessPoint : Diagram_Messages.BASENAME_OutAccessPoint;
        EList points = application.getAccessPoint();
        IdFactory factory = new IdFactory(baseId, baseName);
        factory.computeNames((List)points);
        AccessPointType ap = AccessPointUtil.createIntrinsicAccessPoint((String)factory.getId(), (String)factory.getName(), null, (DirectionType)(isIn ? DirectionType.IN_LITERAL : DirectionType.OUT_LITERAL), (!isIn ? 1 : 0) != 0, null, (DataTypeType)ModelUtils.getDataType((IModelElement)application, (String)"serializable"));
        AttributeUtil.setAttribute((IExtensibleElement)ap, (String)"carnot:engine:browsable", (String)BOOLEAN_TYPE, (String)Boolean.FALSE.toString());
        application.getAccessPoint().add((Object)ap);
        this.selectPageForObject(ap);
    }
}

